/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.commons.collections.iterators;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.ResettableIterator;
import org.apache.commons.lang3.Validate;
import org.helenus.commons.collections.iterators.SnapshotEntry;

public class SnapshotIterator<T>
implements ResettableIterator<T>,
Serializable {
    private static final long serialVersionUID = 5564723343035529469L;
    private final List<T> list;
    private int current = 0;

    public SnapshotIterator(Iterator<T> i) {
        Validate.notNull(i, (String)"invalid null iterator", (Object[])new Object[0]);
        if (!i.hasNext()) {
            this.list = Collections.emptyList();
            return;
        }
        this.list = new ArrayList<T>();
        while (i.hasNext()) {
            Object e = i.next();
            if (e instanceof Map.Entry) {
                e = new SnapshotEntry((Map.Entry)e);
            }
            this.list.add(e);
        }
    }

    public SnapshotIterator(Iterable<T> i) {
        this(i.iterator());
    }

    public void reset() {
        this.current = 0;
    }

    public boolean hasNext() {
        return this.current < this.list.size();
    }

    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Snapshot Iterator");
        }
        return this.list.get(this.current++);
    }

    public void remove() {
        throw new UnsupportedOperationException("Snapshot Iterator");
    }
}

