/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.commons.collections.iterators;

import java.util.Comparator;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.comparators.TransformingComparator;

public class TransformSpliterator<I, O>
implements Spliterator<O> {
    private Spliterator<? extends I> i;
    private Transformer<? super I, ? extends O> transformer;
    private Transformer<? super O, ? extends I> reverseTransformer;

    public TransformSpliterator(Spliterator<? extends I> i) {
        this.i = i;
    }

    public TransformSpliterator(Spliterator<? extends I> i, Transformer<? super I, ? extends O> transformer) {
        this.i = i;
        this.transformer = transformer;
    }

    public TransformSpliterator(Spliterator<? extends I> i, Transformer<? super I, ? extends O> transformer, Transformer<? super O, ? extends I> reverseTransformer) {
        this.i = i;
        this.transformer = transformer;
        this.reverseTransformer = reverseTransformer;
    }

    protected O transform(I source) {
        return (O)this.transformer.transform(source);
    }

    @Override
    public boolean tryAdvance(Consumer<? super O> action) {
        return this.i.tryAdvance((? super T ie) -> action.accept((O)this.transform(ie)));
    }

    @Override
    public void forEachRemaining(Consumer<? super O> action) {
        this.i.forEachRemaining((? super T ie) -> action.accept((O)this.transform(ie)));
    }

    @Override
    public Spliterator<O> trySplit() {
        return new TransformSpliterator<I, O>(this.i.trySplit(), this.transformer);
    }

    @Override
    public long estimateSize() {
        return this.i.estimateSize();
    }

    @Override
    public long getExactSizeIfKnown() {
        return this.i.getExactSizeIfKnown();
    }

    @Override
    public int characteristics() {
        return this.i.characteristics();
    }

    @Override
    public boolean hasCharacteristics(int characteristics) {
        return this.i.hasCharacteristics(characteristics);
    }

    @Override
    public Comparator<? super O> getComparator() {
        Comparator<? extends I> c = this.i.getComparator();
        if (c == null) {
            return null;
        }
        if (this.reverseTransformer != null) {
            return new TransformingComparator(this.reverseTransformer, c);
        }
        throw new IllegalStateException("unable to transform comparator");
    }

    public Spliterator<? extends I> getSpliterator() {
        return this.i;
    }

    public void setSpliterator(Spliterator<? extends I> iterator) {
        this.i = iterator;
    }

    public Transformer<? super I, ? extends O> getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer<? super I, ? extends O> transformer) {
        this.transformer = transformer;
    }

    public Transformer<? super O, ? extends I> getReverseTransformer() {
        return this.reverseTransformer;
    }

    public void setReverseTransformer(Transformer<? super O, ? extends I> reverseTransformer) {
        this.reverseTransformer = reverseTransformer;
    }
}

