/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.commons.lang3;

import java.util.IllformedLocaleException;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import sun.util.locale.InternalLocaleBuilder;
import sun.util.locale.LocaleExtensions;
import sun.util.locale.LocaleSyntaxException;

public class LocaleUtils
extends org.apache.commons.lang3.LocaleUtils {
    private static Locale getLocale(String str, String ostr) {
        if (str.isEmpty()) {
            return Locale.ROOT;
        }
        int len = str.length();
        if (len < 2) {
            throw new IllegalArgumentException("invalid locale format: " + ostr);
        }
        char ch0 = str.charAt(0);
        if (ch0 == '_') {
            if (len < 3) {
                throw new IllegalArgumentException("invalid locale format: " + ostr);
            }
            char ch1 = str.charAt(1);
            char ch2 = str.charAt(2);
            if (!Character.isUpperCase(ch1) || !Character.isUpperCase(ch2)) {
                throw new IllegalArgumentException("invalid locale format: " + ostr);
            }
            if (len == 3) {
                return new Locale("", str.substring(1, 3));
            }
            if (len < 5) {
                throw new IllegalArgumentException("invalid locale format: " + ostr);
            }
            if (str.charAt(3) != '_') {
                throw new IllegalArgumentException("invalid locale format: " + ostr);
            }
            return new Locale("", str.substring(1, 3), str.substring(4));
        }
        int i = str.indexOf(95);
        if (i == -1) {
            if (StringUtils.isAllLowerCase((CharSequence)str) && (len == 2 || len == 3)) {
                return new Locale(str);
            }
        } else {
            String lang = str.substring(0, i);
            String lstr = str.substring(i + 1);
            int j = lstr.indexOf(95);
            if (j == -1) {
                if (StringUtils.isAllLowerCase((CharSequence)lang) && (lang.length() == 2 || lang.length() == 3) && (lstr.length() == 0 || lstr.length() == 2 && StringUtils.isAllUpperCase((CharSequence)lstr))) {
                    return new Locale(lang, lstr);
                }
            } else {
                String reg = lstr.substring(0, j);
                String variant = lstr.substring(j + 1);
                if (StringUtils.isAllLowerCase((CharSequence)lang) && (lang.length() == 2 || lang.length() == 3) && (reg.length() == 0 || reg.length() == 2 && StringUtils.isAllUpperCase((CharSequence)reg))) {
                    return new Locale(lang, reg, variant);
                }
            }
        }
        throw new IllegalArgumentException("invalid locale format: " + ostr);
    }

    public static Locale toLocale(String str) {
        if (str == null) {
            return null;
        }
        try {
            int i = str.indexOf("_#");
            if (i != -1) {
                String extns;
                Locale locale = LocaleUtils.getLocale(str.substring(0, i), str);
                String script_extn = str.substring(i + 2);
                if (locale.toString().equals(str)) {
                    return locale;
                }
                Locale.Builder builder = new Locale.Builder();
                builder.setLocale(locale);
                int j = script_extn.indexOf(95);
                if (j == -1) {
                    int k2 = script_extn.indexOf(45);
                    if (k2 == -1) {
                        builder.setScript(script_extn);
                        extns = null;
                    } else {
                        extns = script_extn;
                    }
                } else {
                    builder.setScript(script_extn.substring(0, j));
                    extns = script_extn.substring(j + 1);
                }
                if (extns != null) {
                    InternalLocaleBuilder ibldr = new InternalLocaleBuilder();
                    ibldr.setExtensions(extns);
                    LocaleExtensions lextns = ibldr.getLocaleExtensions();
                    lextns.getKeys().forEach(k -> builder.setExtension(k.charValue(), lextns.getExtensionValue((Character)k)));
                }
                return builder.build();
            }
            return LocaleUtils.getLocale(str, str);
        }
        catch (IllformedLocaleException | LocaleSyntaxException e) {
            throw new IllegalArgumentException("invalid locale format: " + str, e);
        }
    }
}

