/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.commons.lang3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.Validate;

public class SerializationUtils
extends org.apache.commons.lang3.SerializationUtils {
    public static void serializeAndCompress(Serializable obj, OutputStream outputStream) {
        Validate.notNull((Object)outputStream, (String)"invalid null outputStream", (Object[])new Object[0]);
        try {
            GZIPOutputStream os = new GZIPOutputStream(outputStream);
            org.apache.commons.lang3.SerializationUtils.serialize((Serializable)obj, (OutputStream)os);
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    public static byte[] serializeAndCompress(Serializable obj) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        SerializationUtils.serializeAndCompress(obj, baos);
        return baos.toByteArray();
    }

    public static Object decompressAndDeserialize(InputStream inputStream) {
        Validate.notNull((Object)inputStream, (String)"invalid null inputStream", (Object[])new Object[0]);
        try {
            GZIPInputStream is = new GZIPInputStream(inputStream);
            return org.apache.commons.lang3.SerializationUtils.deserialize((InputStream)is);
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    public static Object decompressAndDeserialize(byte[] data) {
        return SerializationUtils.decompressAndDeserialize(new ByteArrayInputStream(data));
    }
}

