/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.commons.lang3.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import org.helenus.commons.lang3.reflect.ReflectionUtils;

class AnnotationProxy
implements InvocationHandler {
    private final AnnotationMirror am;

    AnnotationProxy(AnnotationMirror am) {
        this.am = am;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> rclass = method.getReturnType();
        String name = method.getName();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : this.am.getElementValues().entrySet()) {
            if (!name.equals(e.getKey().getSimpleName().toString())) continue;
            AnnotationValue eav = e.getValue();
            if (Class.class.isAssignableFrom(rclass)) {
                if (eav.getValue() instanceof DeclaredType) {
                    return ReflectionUtils.classFor((DeclaredType)eav.getValue());
                }
                return Class.forName(eav.getValue().toString());
            }
            if (rclass.isArray() && eav.getValue() instanceof List) {
                List list = (List)List.class.cast(eav.getValue());
                Object array = Array.newInstance(rclass.getComponentType(), list.size());
                int i = 0;
                for (Object o : list) {
                    Object av = ((AnnotationValue)o).getValue();
                    if (Class.class.isAssignableFrom(rclass.getComponentType())) {
                        if (av instanceof DeclaredType) {
                            Array.set(array, i++, ReflectionUtils.classFor((DeclaredType)av));
                            continue;
                        }
                        Array.set(array, i++, Class.forName(av.toString()));
                        continue;
                    }
                    Array.set(array, i++, av);
                }
                return array;
            }
            return eav.getValue();
        }
        return method.getDefaultValue();
    }
}

