/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.commons.lang3.reflect;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.lang3.Validate;
import org.helenus.annotation.Keyable;
import org.helenus.commons.lang3.reflect.AnnotationProxy;
import sun.reflect.ReflectionFactory;

public class ReflectionUtils {
    private static final ReflectionFactory reflFactory = (ReflectionFactory)AccessController.doPrivileged(new ReflectionFactory.GetReflectionFactoryAction());

    public static <A extends Annotation> A findFirstAnnotation(Class<?> clazz, Class<A> annotationClass) {
        Validate.notNull(clazz, (String)"invalid null class", (Object[])new Object[0]);
        Validate.notNull(annotationClass, (String)"invalid null annotation class", (Object[])new Object[0]);
        Class<?> c = clazz;
        do {
            Annotation[] as;
            if ((as = c.getDeclaredAnnotationsByType(annotationClass)).length > 0) {
                return (A)as[0];
            }
            for (Class<?> i : c.getInterfaces()) {
                A a = ReflectionUtils.findFirstAnnotation(i, annotationClass);
                if (a == null) continue;
                return a;
            }
        } while ((c = c.getSuperclass()) != null);
        return null;
    }

    public static <T> Class<? super T> findFirstClassAnnotatedWith(Class<T> clazz, Class<? extends Annotation> annotationClass) {
        Validate.notNull(clazz, (String)"invalid null class", (Object[])new Object[0]);
        Validate.notNull(annotationClass, (String)"invalid null annotation class", (Object[])new Object[0]);
        Class<T> c = clazz;
        do {
            if (c.getDeclaredAnnotationsByType(annotationClass).length <= 0) continue;
            return c;
        } while ((c = c.getSuperclass()) != null);
        return null;
    }

    public static <T> Class<? super T> findFirstClassNotAnnotatedWith(Class<T> clazz, Class<? extends Annotation> annotationClass) {
        Class<T> c;
        Validate.notNull(clazz, (String)"invalid null class", (Object[])new Object[0]);
        Validate.notNull(annotationClass, (String)"invalid null annotation class", (Object[])new Object[0]);
        for (c = clazz; c != null && c.getDeclaredAnnotationsByType(annotationClass).length > 0; c = c.getSuperclass()) {
        }
        return c;
    }

    public static <T> Class<? super T> findLastClassAnnotatedWith(Class<T> clazz, Class<? extends Annotation> annotationClass) {
        Validate.notNull(clazz, (String)"invalid null class", (Object[])new Object[0]);
        Validate.notNull(annotationClass, (String)"invalid null annotation class", (Object[])new Object[0]);
        Class<T> p = null;
        for (Class<T> c = clazz; c != null && c.getDeclaredAnnotationsByType(annotationClass).length > 0; c = c.getSuperclass()) {
            p = c;
        }
        return p;
    }

    public static <T> Constructor<T> getSerializationConstructorFromBaseClass(Class<T> clazz, Class<?> bclass) {
        Constructor<?> ctor;
        Validate.notNull(clazz, (String)"invalid null class", (Object[])new Object[0]);
        Validate.notNull(bclass, (String)"invalid null base class", (Object[])new Object[0]);
        Validate.isTrue((boolean)bclass.isAssignableFrom(clazz), (String)(bclass.getName() + " is not a superclass of " + clazz.getName()), (Object[])new Object[0]);
        try {
            ctor = bclass.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("missing default constructor for base class: " + bclass.getName(), e);
        }
        Constructor<?> nc = reflFactory.newConstructorForSerialization(clazz, ctor);
        nc.setAccessible(true);
        return nc;
    }

    public static <T> Constructor<T> getSerializationConstructorFromAnnotation(Class<T> clazz, Class<? extends Annotation> annotationClass) {
        Validate.notNull(clazz, (String)"invalid null class", (Object[])new Object[0]);
        Validate.notNull(annotationClass, (String)"invalid null annotation class", (Object[])new Object[0]);
        Class<T> bclass = ReflectionUtils.findFirstClassNotAnnotatedWith(clazz, annotationClass);
        return ReflectionUtils.getSerializationConstructorFromBaseClass(clazz, bclass);
    }

    public static <T extends Member> T[] getDeclaredMembers(Class<T> type, Class<?> clazz) {
        Validate.notNull(type, (String)"invalid null member type", (Object[])new Object[0]);
        Validate.notNull(clazz, (String)"invalid null class", (Object[])new Object[0]);
        if (type == Field.class) {
            return clazz.getDeclaredFields();
        }
        if (type == Method.class) {
            return clazz.getDeclaredMethods();
        }
        if (type == Constructor.class) {
            return clazz.getDeclaredConstructors();
        }
        throw new IllegalArgumentException("invalid member class: " + type.getName());
    }

    public static <T extends Member> List<T> getAllMembersAnnotatedWith(Class<T> type, Class<?> clazz, Class<? extends Annotation> annotation, boolean up) {
        Validate.notNull(type, (String)"invalid null member type", (Object[])new Object[0]);
        Validate.notNull(clazz, (String)"invalid null class", (Object[])new Object[0]);
        Validate.notNull(annotation, (String)"invalid null annotation class", (Object[])new Object[0]);
        LinkedList<Class> classes = new LinkedList<Class>();
        if (up) {
            while (clazz != null) {
                classes.push(clazz);
                clazz = clazz.getSuperclass();
            }
        } else {
            classes.push(clazz);
        }
        ArrayList<Member> members = new ArrayList<Member>(12);
        while (!classes.isEmpty()) {
            clazz = (Class)classes.pop();
            for (Member m : ReflectionUtils.getDeclaredMembers(type, (Class)clazz)) {
                if (!(m instanceof AnnotatedElement) || ((AnnotatedElement)((Object)m)).getAnnotationsByType(annotation).length <= 0) continue;
                members.add(m);
            }
        }
        return members;
    }

    public static List<Field> getAllFieldsAnnotatedWith(Class<?> clazz, Class<? extends Annotation> annotation, boolean up) {
        return ReflectionUtils.getAllMembersAnnotatedWith(Field.class, clazz, annotation, up);
    }

    public static List<Method> getAllMethodsAnnotatedWith(Class<?> clazz, Class<? extends Annotation> annotation, boolean up) {
        return ReflectionUtils.getAllMembersAnnotatedWith(Method.class, clazz, annotation, up);
    }

    public static <T extends Member, A extends Annotation> Map<T, A[]> getAllAnnotationsForMembersAnnotatedWith(Class<T> type, Class<?> clazz, Class<A> annotation, boolean up) {
        Validate.notNull(type, (String)"invalid null member type", (Object[])new Object[0]);
        Validate.notNull(clazz, (String)"invalid null class", (Object[])new Object[0]);
        Validate.notNull(annotation, (String)"invalid null annotation class", (Object[])new Object[0]);
        LinkedList<Class> classes = new LinkedList<Class>();
        if (up) {
            while (clazz != null) {
                classes.push(clazz);
                clazz = clazz.getSuperclass();
            }
        } else {
            classes.push(clazz);
        }
        LinkedHashMap<Member, Annotation[]> members = new LinkedHashMap<Member, Annotation[]>(12);
        while (!classes.isEmpty()) {
            clazz = (Class)classes.pop();
            for (Member m : ReflectionUtils.getDeclaredMembers(type, (Class)clazz)) {
                Annotation[] as;
                if (!(m instanceof AnnotatedElement) || (as = ((AnnotatedElement)((Object)m)).getAnnotationsByType(annotation)).length <= 0) continue;
                members.put(m, as);
            }
        }
        return members;
    }

    public static <A extends Annotation> Map<Field, A[]> getAllAnnotationsForFieldsAnnotatedWith(Class<?> clazz, Class<A> annotation, boolean up) {
        return ReflectionUtils.getAllAnnotationsForMembersAnnotatedWith(Field.class, clazz, annotation, up);
    }

    public static <A extends Annotation> Map<Method, A[]> getAllAnnotationsForMethodsAnnotatedWith(Class<?> clazz, Class<A> annotation, boolean up) {
        return ReflectionUtils.getAllAnnotationsForMembersAnnotatedWith(Method.class, clazz, annotation, up);
    }

    public static <K, T extends Annotation> Map<K, T> getAnnotationsByType(Class<K> keyClass, Class<T> annotationClass, AnnotatedElement annotatedElement) {
        Method km;
        Validate.notNull(annotationClass, (String)"invalid null annotation class", (Object[])new Object[0]);
        Validate.notNull((Object)annotatedElement, (String)"invalid null annotation element", (Object[])new Object[0]);
        Validate.notNull(keyClass, (String)"invalid null key class", (Object[])new Object[0]);
        Keyable k = annotationClass.getAnnotation(Keyable.class);
        Validate.isTrue((k != null ? 1 : 0) != 0, (String)"annotation @%s not annotated with @Keyable", (Object[])new Object[]{annotationClass.getName()});
        try {
            km = annotationClass.getMethod(k.value(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("annotation key element @" + annotationClass.getName() + "." + k.value() + "() not found", e);
        }
        Validate.isTrue((boolean)keyClass.isAssignableFrom(km.getReturnType()), (String)"annotation key element @%s.%s() doesn't return class: %s", (Object[])new Object[]{annotationClass.getName(), k.value(), keyClass.getName()});
        Annotation[] as = annotatedElement.getAnnotationsByType(annotationClass);
        if (as.length == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Object, Annotation> map = new LinkedHashMap<Object, Annotation>(as.length);
        for (Annotation a : as) {
            Object ak;
            try {
                ak = km.invoke((Object)a, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new IllegalStateException(e);
            }
            Validate.isTrue((map.put(ak, a) == null ? 1 : 0) != 0, (String)"duplicate key '%s' found in annotation @%s", (Object[])new Object[]{ak, annotationClass.getName()});
        }
        return map;
    }

    public static <T extends Member> List<T> getAllDeclaredMembers(Class<T> type, Class<?> clazz, boolean up) {
        Validate.notNull(type, (String)"invalid null member type", (Object[])new Object[0]);
        Validate.notNull(clazz, (String)"invalid null class", (Object[])new Object[0]);
        LinkedList<Class> classes = new LinkedList<Class>();
        if (up) {
            while (clazz != null) {
                classes.push(clazz);
                clazz = clazz.getSuperclass();
            }
        } else {
            classes.push(clazz);
        }
        ArrayList<Member> members = new ArrayList<Member>(12);
        while (!classes.isEmpty()) {
            clazz = (Class)classes.pop();
            for (Member m : ReflectionUtils.getDeclaredMembers(type, (Class)clazz)) {
                members.add(m);
            }
        }
        return members;
    }

    public static List<Field> getAllDeclaredFields(Class<?> clazz, boolean up) {
        return ReflectionUtils.getAllDeclaredMembers(Field.class, clazz, up);
    }

    public static List<Method> getAllDeclaredMethods(Class<?> clazz, boolean up) {
        return ReflectionUtils.getAllDeclaredMembers(Method.class, clazz, up);
    }

    public static Class<?> getRawClass(Type t) {
        Type tt = t;
        while (!(tt instanceof Class)) {
            if (tt instanceof ParameterizedType) {
                tt = ((ParameterizedType)t).getRawType();
                continue;
            }
            throw new IllegalStateException("there should be a raw class for: " + t);
        }
        return (Class)tt;
    }

    public static <T> List<Class<?>> getClassHierarchy(Class<?> clazz) {
        Validate.notNull(clazz, (String)"invalid null class", (Object[])new Object[0]);
        LinkedList classes = new LinkedList();
        while (clazz != null) {
            classes.push(clazz);
            clazz = clazz.getSuperclass();
        }
        return classes;
    }

    public static Collection<Class<?>> findClasses(String pkg) {
        return ReflectionUtils.findClasses(pkg, Thread.currentThread().getContextClassLoader());
    }

    public static Collection<Class<?>> findClasses(String pkg, ClassLoader cl) {
        Enumeration<URL> resources;
        Validate.notNull((Object)pkg, (String)"invalid null pkg", (Object[])new Object[0]);
        String scannedPath = pkg.replace('.', File.separatorChar);
        try {
            resources = cl.getResources(scannedPath);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to get resources from path '" + scannedPath + "'. Are you sure the given '" + pkg + "' package exists?", e);
        }
        LinkedList classes = new LinkedList();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if ("jar".equals(url.getProtocol())) {
                ReflectionUtils.findClassesFromJar(classes, url, scannedPath, cl);
                continue;
            }
            if ("file".equals(url.getProtocol())) {
                File file = new File(url.getFile());
                ReflectionUtils.findClassesFromFile(classes, file, pkg, cl);
                continue;
            }
            throw new IllegalArgumentException("package is provided by an unknown url: " + url);
        }
        return classes;
    }

    private static void findClassesFromJar(Collection<Class<?>> classes, URL url, String resource, ClassLoader cl) {
        block19: {
            try {
                JarURLConnection conn = (JarURLConnection)url.openConnection();
                URL jurl = conn.getJarFileURL();
                JarInputStream jar = new JarInputStream(jurl.openStream());
                Throwable throwable = null;
                block13: while (true) {
                    try {
                        while (true) {
                            JarEntry entry;
                            if ((entry = jar.getNextJarEntry()) == null) {
                                break block19;
                            }
                            String name = entry.getName();
                            if (!name.endsWith(".class") || !name.startsWith(resource)) continue;
                            String cname = name.substring(0, name.length() - 6).replace(File.separatorChar, '.');
                            try {
                                classes.add(cl.loadClass(cname));
                                continue block13;
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (jar != null) {
                        if (throwable != null) {
                            try {
                                jar.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            jar.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("unable to find classes in package", e);
            }
        }
    }

    private static void findClassesFromFile(Collection<Class<?>> classes, File file, String resource, ClassLoader cl) {
        block4: {
            block3: {
                if (!file.isDirectory()) break block3;
                for (File f : file.listFiles()) {
                    ReflectionUtils.findClassesFromFile(classes, f, resource + "." + f.getName(), cl);
                }
                break block4;
            }
            if (!resource.endsWith(".class")) break block4;
            String cname = resource.substring(0, resource.length() - 6);
            try {
                classes.add(cl.loadClass(cname));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public static Collection<URL> findResources(String pkg) {
        return ReflectionUtils.findResources(pkg, Thread.currentThread().getContextClassLoader());
    }

    public static Collection<URL> findResources(String pkg, ClassLoader cl) {
        Enumeration<URL> resources;
        Validate.notNull((Object)pkg, (String)"invalid null pkg", (Object[])new Object[0]);
        String scannedPath = pkg.replace('.', File.separatorChar);
        try {
            resources = cl.getResources(scannedPath);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to get resources from path '" + scannedPath + "'. Are you sure the given '" + pkg + "' package exists?", e);
        }
        LinkedList<URL> urls = new LinkedList<URL>();
        try {
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                if ("jar".equals(url.getProtocol())) {
                    ReflectionUtils.findResourcesFromJar(urls, url, scannedPath, cl);
                    continue;
                }
                if ("file".equals(url.getProtocol())) {
                    File file = new File(URLDecoder.decode(url.getFile(), "UTF-8"));
                    ReflectionUtils.findResourcesFromFile(urls, file, scannedPath, cl);
                    continue;
                }
                throw new IllegalArgumentException("package is provided by an unknown url: " + url);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(e);
        }
        return urls;
    }

    private static void findResourcesFromJar(Collection<URL> urls, URL url, String resource, ClassLoader cl) {
        try {
            JarURLConnection conn = (JarURLConnection)url.openConnection();
            URL jurl = conn.getJarFileURL();
            try (JarInputStream jar = new JarInputStream(jurl.openStream());){
                JarEntry entry;
                while ((entry = jar.getNextJarEntry()) != null) {
                    URL u;
                    String name = entry.getName();
                    if (!name.startsWith(resource) || (u = cl.getResource(name)) == null) continue;
                    urls.add(u);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("unable to find resources in package", e);
        }
    }

    private static void findResourcesFromFile(Collection<URL> urls, File file, String resource, ClassLoader cl) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                ReflectionUtils.findResourcesFromFile(urls, f, resource + File.separatorChar + f.getName(), cl);
            }
        } else {
            URL u = cl.getResource(resource);
            if (u != null) {
                urls.add(u);
            }
        }
    }

    public static final boolean isAssignableFrom(Class<?>[] classes, Class<?> clazz) {
        for (Class<?> c : classes) {
            if (!c.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public static Class<?> classFor(DeclaredType type) throws ClassNotFoundException {
        StringBuilder sb = new StringBuilder(40);
        LinkedList<Element> es = new LinkedList<Element>();
        for (Element e = type.asElement(); e != null; e = e.getEnclosingElement()) {
            es.push(e);
        }
        Element previous = null;
        for (Element e : es) {
            if (previous != null) {
                if (previous.getKind().isClass() || previous.getKind().isInterface()) {
                    sb.append('$');
                } else {
                    sb.append('.');
                }
            }
            if (e instanceof PackageElement) {
                sb.append(((PackageElement)e).getQualifiedName());
            } else if (e.getKind() == ElementKind.PACKAGE) {
                sb.append(e);
            } else {
                sb.append(e.getSimpleName());
            }
            previous = e;
        }
        return Class.forName(sb.toString());
    }

    private static Class<?> primitiveClassFor(TypeKind kind) throws ClassNotFoundException {
        switch (kind) {
            case BYTE: {
                return Byte.TYPE;
            }
            case CHAR: {
                return Character.TYPE;
            }
            case SHORT: {
                return Short.TYPE;
            }
            case INT: {
                return Integer.TYPE;
            }
            case LONG: {
                return Long.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
            case BOOLEAN: {
                return Boolean.TYPE;
            }
        }
        throw new ClassNotFoundException("unknown primitive kind: " + (Object)((Object)kind));
    }

    private static Class<?> primitiveArrayClassFor(TypeKind kind) throws ClassNotFoundException {
        switch (kind) {
            case BYTE: {
                return byte[].class;
            }
            case CHAR: {
                return char[].class;
            }
            case SHORT: {
                return short[].class;
            }
            case INT: {
                return int[].class;
            }
            case LONG: {
                return long[].class;
            }
            case FLOAT: {
                return float[].class;
            }
            case DOUBLE: {
                return double[].class;
            }
            case BOOLEAN: {
                return boolean[].class;
            }
        }
        throw new ClassNotFoundException("unknown primitive array element kind: " + (Object)((Object)kind));
    }

    public static Class<?> classFor(TypeMirror tm) throws ClassNotFoundException {
        if (tm instanceof ArrayType) {
            ArrayType array = (ArrayType)tm;
            TypeMirror compType = array.getComponentType();
            if (compType.getKind().isPrimitive()) {
                return ReflectionUtils.primitiveArrayClassFor(compType.getKind());
            }
            if (compType instanceof DeclaredType) {
                return Array.newInstance(ReflectionUtils.classFor((DeclaredType)compType), 0).getClass();
            }
            return Array.newInstance(Class.forName(compType.toString()), 0).getClass();
        }
        if (tm.getKind().isPrimitive()) {
            return ReflectionUtils.primitiveClassFor(tm.getKind());
        }
        if (tm.getKind() == TypeKind.VOID) {
            return Void.TYPE;
        }
        if (tm instanceof DeclaredType) {
            return ReflectionUtils.classFor((DeclaredType)tm);
        }
        return Class.forName(tm.toString());
    }

    public static <T extends Annotation> Stream<T> annotationsByType(Element annotatedElement, Class<T> annotationClass) {
        String aname = annotationClass.getName();
        return annotatedElement.getAnnotationMirrors().stream().filter(am -> aname.equals(am.getAnnotationType().toString())).map(am -> (Annotation)Proxy.newProxyInstance(annotationClass.getClassLoader(), new Class[]{annotationClass}, (InvocationHandler)new AnnotationProxy((AnnotationMirror)am)));
    }

    public static Stream<Annotation> annotationsAnnotatedWith(Element annotatedElement, Class<? extends Annotation> annotationClass) {
        return annotatedElement.getAnnotationMirrors().stream().map(am -> {
            try {
                Class<?> aclass = ReflectionUtils.classFor(am.getAnnotationType());
                if (!aclass.isAnnotationPresent(annotationClass)) {
                    return null;
                }
                return (Annotation)Proxy.newProxyInstance(aclass.getClassLoader(), new Class[]{aclass}, (InvocationHandler)new AnnotationProxy((AnnotationMirror)am));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }).filter(a -> a != null);
    }

    public static Stream<Annotation> annotations(Element annotatedElement) {
        return annotatedElement.getAnnotationMirrors().stream().map(am -> {
            try {
                Class<?> aclass = ReflectionUtils.classFor(am.getAnnotationType());
                return (Annotation)Proxy.newProxyInstance(aclass.getClassLoader(), new Class[]{aclass}, (InvocationHandler)new AnnotationProxy((AnnotationMirror)am));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }).filter(a -> a != null);
    }

    public static Annotation[] getAnnotationsAnnotatedWith(Element annotatedElement, Class<? extends Annotation> annotationClass) {
        return (Annotation[])ReflectionUtils.annotationsAnnotatedWith(annotatedElement, annotationClass).toArray(Annotation[]::new);
    }

    public static Annotation[] getAnnotations(Element annotatedElement) {
        return (Annotation[])ReflectionUtils.annotations(annotatedElement).toArray(Annotation[]::new);
    }

    public static <T extends Annotation> T[] getAnnotationsByType(Element annotatedElement, Class<T> annotationClass) {
        return (Annotation[])ReflectionUtils.annotationsByType(annotatedElement, annotationClass).toArray(size -> (Annotation[])Array.newInstance(annotationClass, size));
    }

    public static <T extends Annotation> T getAnnotation(Element annotatedElement, Class<T> annotationClass) {
        return (T)((Annotation)ReflectionUtils.annotationsByType(annotatedElement, annotationClass).findFirst().orElse(null));
    }

    private ReflectionUtils() {
        throw new IllegalStateException("invalid constructor called");
    }
}

