/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.jackson.databind;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.MethodUtils;

public class ExtendedBeanProperty
implements BeanProperty {
    private final BeanProperty bean;

    public ExtendedBeanProperty(BeanProperty bean) {
        this.bean = bean;
    }

    public BeanProperty getBean() {
        return this.bean;
    }

    public String getName() {
        return this.bean.getName();
    }

    public PropertyName getFullName() {
        return this.bean.getFullName();
    }

    public JavaType getType() {
        return this.bean.getType();
    }

    public PropertyName getWrapperName() {
        return this.bean.getWrapperName();
    }

    public PropertyMetadata getMetadata() {
        return this.bean.getMetadata();
    }

    public boolean isRequired() {
        return this.bean.isRequired();
    }

    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return (A)this.bean.getAnnotation(acls);
    }

    public <A extends Annotation> A[] getAnnotationByType(Class<A> acls) {
        Annotation ca;
        A a = this.getAnnotation(acls);
        if (a != null) {
            Annotation[] as = (Annotation[])Array.newInstance(acls, 1);
            Array.set(as, 0, a);
            return as;
        }
        Repeatable r = acls.getAnnotation(Repeatable.class);
        if (r != null && (ca = this.getAnnotation(r.value())) != null) {
            try {
                return (Annotation[])MethodUtils.invokeExactMethod((Object)ca, (String)"value");
            }
            catch (InvocationTargetException e) {
                throw new InternalError(e.getTargetException());
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new InternalError(e);
            }
        }
        return (Annotation[])Array.newInstance(acls, 0);
    }

    public <A extends Annotation> A getContextAnnotation(Class<A> acls) {
        return (A)this.bean.getContextAnnotation(acls);
    }

    public <A extends Annotation> A[] getContextAnnotationByType(Class<A> acls) {
        Annotation ca;
        A a = this.getContextAnnotation(acls);
        if (a != null) {
            Annotation[] as = (Annotation[])Array.newInstance(acls, 1);
            Array.set(as, 0, a);
            return as;
        }
        Repeatable r = acls.getAnnotation(Repeatable.class);
        if (r != null && (ca = this.getContextAnnotation(r.value())) != null) {
            try {
                return (Annotation[])MethodUtils.invokeExactMethod((Object)ca, (String)"value");
            }
            catch (InvocationTargetException e) {
                throw new InternalError(e.getTargetException());
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new InternalError(e);
            }
        }
        return (Annotation[])Array.newInstance(acls, 0);
    }

    public AnnotatedMember getMember() {
        return this.bean.getMember();
    }

    public JsonFormat.Value findFormatOverrides(AnnotationIntrospector intr) {
        return this.bean.findFormatOverrides(intr);
    }

    public void depositSchemaProperty(JsonObjectFormatVisitor objectVisitor) throws JsonMappingException {
        this.bean.depositSchemaProperty(objectVisitor);
    }

    public String toString() {
        return this.bean.getMember().toString() + " (" + this.bean.getFullName() + ")";
    }
}

