/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.jackson.databind.ser.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.impl.TypeWrappedSerializer;
import java.io.IOException;

public class TypeWrappedSchemaSerializer
extends JsonSerializer<Object> {
    private final TypeSerializer typeSerializer;
    private final JsonSerializer<Object> serializer;

    public TypeWrappedSchemaSerializer(TypeSerializer typeSer, JsonSerializer<?> ser) {
        this.typeSerializer = typeSer;
        this.serializer = ser;
    }

    public TypeWrappedSchemaSerializer(TypeWrappedSerializer ser) {
        this.typeSerializer = ser.typeSerializer();
        this.serializer = ser.valueSerializer();
    }

    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        this.serializer.serializeWithType(value, jgen, provider, this.typeSerializer);
    }

    public void serializeWithType(Object value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        this.serializer.serializeWithType(value, jgen, provider, typeSer);
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType type) throws JsonMappingException {
        this.serializer.acceptJsonFormatVisitor(visitor, type);
    }

    public Class<Object> handledType() {
        return Object.class;
    }

    public JsonSerializer<Object> valueSerializer() {
        return this.serializer;
    }

    public TypeSerializer typeSerializer() {
        return this.typeSerializer;
    }
}

