/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.jackson.jsonSchema.factories;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonAnyFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonBooleanFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNullFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.fasterxml.jackson.databind.ser.std.JsonValueSerializer;
import com.fasterxml.jackson.databind.ser.std.StdKeySerializers;
import com.fasterxml.jackson.databind.ser.std.StringSerializer;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.ArrayVisitor;
import com.fasterxml.jackson.module.jsonSchema.factories.MapVisitor;
import com.fasterxml.jackson.module.jsonSchema.factories.ObjectVisitor;
import com.fasterxml.jackson.module.jsonSchema.factories.ObjectVisitorDecorator;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.module.jsonSchema.factories.StringVisitor;
import com.fasterxml.jackson.module.jsonSchema.factories.Visitor;
import com.fasterxml.jackson.module.jsonSchema.factories.VisitorContext;
import com.fasterxml.jackson.module.jsonSchema.factories.WrapperFactory;
import com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;
import com.fasterxml.jackson.module.jsonSchema.types.ContainerTypeSchema;
import com.fasterxml.jackson.module.jsonSchema.types.IntegerSchema;
import com.fasterxml.jackson.module.jsonSchema.types.NumberSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ReferenceSchema;
import com.fasterxml.jackson.module.jsonSchema.types.SimpleTypeSchema;
import com.fasterxml.jackson.module.jsonSchema.types.StringSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ValueTypeSchema;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.iterators.EnumerationIterator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.helenus.commons.lang3.reflect.ReflectionUtils;
import org.helenus.jackson.annotation.JsonPropertyDefaultValues;
import org.helenus.jackson.annotation.JsonPropertyDefaultValuesProvider;
import org.helenus.jackson.annotation.JsonPropertyDivisibleBy;
import org.helenus.jackson.annotation.JsonPropertyEnumValues;
import org.helenus.jackson.annotation.JsonPropertyEnumValuesProvider;
import org.helenus.jackson.annotation.JsonPropertyKeyDescription;
import org.helenus.jackson.annotation.JsonPropertyLength;
import org.helenus.jackson.annotation.JsonPropertyMaximumValue;
import org.helenus.jackson.annotation.JsonPropertyMinimumValue;
import org.helenus.jackson.annotation.JsonPropertyOneOfDoubleValues;
import org.helenus.jackson.annotation.JsonPropertyOneOfFloatValues;
import org.helenus.jackson.annotation.JsonPropertyOneOfIntegerValues;
import org.helenus.jackson.annotation.JsonPropertyOneOfLongValues;
import org.helenus.jackson.annotation.JsonPropertyPattern;
import org.helenus.jackson.annotation.JsonPropertyReadOnly;
import org.helenus.jackson.annotation.JsonPropertyTitle;
import org.helenus.jackson.annotation.JsonPropertyUniqueItems;
import org.helenus.jackson.annotation.JsonPropertyValueDescription;
import org.helenus.jackson.annotation.JsonPropertyValueFormat;
import org.helenus.jackson.jsonSchema.factories.JsonAnnotationSchemaFactoryProvider;
import org.helenus.jackson.jsonSchema.factories.JsonAnnotationSchemaFactoryWrapperFactory;
import org.helenus.jackson.jsonSchema.factories.JsonAnnotationVisitorContext;
import org.helenus.jackson.jsonSchema.types.MapTypesSchema;
import org.helenus.jackson.jsonSchema.types.ObjectTypesSchema;
import org.helenus.jackson.jsonSchema.types.ReferenceTypesSchema;
import org.helenus.jackson.jsonSchema.types.StringTypesSchema;

public class JsonAnnotationSchemaFactoryWrapper
extends SchemaFactoryWrapper {
    static final boolean ENABLE_ADHOC_REFS = false;
    private JavaType type;

    private static String getViewName(Class<?> clazz) {
        String cname = clazz.getSimpleName();
        Class<?> pclazz = clazz.getDeclaringClass();
        if (pclazz != null) {
            return pclazz.getSimpleName() + "." + cname;
        }
        return cname;
    }

    private static Set<String> getEnumValues(JsonPropertyEnumValues ae, Set<Enum<?>> filteredEnums, boolean keys) {
        JsonSubTypes jst;
        Class[] sclasses = keys ? ae.keySubTypesOf() : ae.valueSubTypesOf();
        Stream<Object> s = Stream.empty();
        if (sclasses.length > 0 && (jst = ReflectionUtils.findFirstAnnotation(sclasses[0], JsonSubTypes.class)) != null) {
            s = Stream.of(jst.value()).filter(t -> sclasses[0].isAssignableFrom(t.value())).map(t -> {
                if (!t.name().isEmpty()) {
                    return t.name();
                }
                JsonTypeName jtn = t.value().getAnnotation(JsonTypeName.class);
                if (jtn != null) {
                    return jtn.value();
                }
                return t.value().getName();
            });
        }
        Class[] iclasses = keys ? ae.keyAvailablesOf() : ae.valueAvailablesOf();
        Stream<Object> i = Stream.empty();
        if (iclasses.length > 0) {
            Set<Method> providers = ReflectionUtils.getAllAnnotationsForMethodsAnnotatedWith(iclasses[0], JsonPropertyEnumValuesProvider.class, true).keySet();
            if (!providers.isEmpty()) {
                i = providers.stream().flatMap(m -> {
                    if (!Modifier.isStatic(m.getModifiers())) {
                        throw new IllegalArgumentException("json property enum values provider method '" + m.getName() + "' is not static in class: " + iclasses[0].getSimpleName());
                    }
                    try {
                        Object ret = m.getParameterCount() == 1 ? m.invoke(null, filteredEnums) : m.invoke(null, new Object[0]);
                        if (ret == null) {
                            return Stream.empty();
                        }
                        Class<?> type = m.getReturnType();
                        if (type.isArray()) {
                            return IntStream.range(0, Array.getLength(ret)).mapToObj(j -> Array.get(ret, j));
                        }
                        if (ret instanceof Collection) {
                            return ((Collection)ret).stream();
                        }
                        if (ret instanceof Stream) {
                            return (Stream)ret;
                        }
                        if (ret instanceof Iterator) {
                            return StreamSupport.stream(Spliterators.spliteratorUnknownSize((Iterator)ret, 16), false);
                        }
                        if (ret instanceof Enumeration) {
                            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new EnumerationIterator((Enumeration)ret), 16), false);
                        }
                        if (ret instanceof Iterable) {
                            return StreamSupport.stream(((Iterable)ret).spliterator(), false);
                        }
                        return Stream.of(ret);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException(e);
                    }
                    catch (InvocationTargetException e) {
                        Throwable t = e.getTargetException();
                        if (t instanceof Error) {
                            throw (Error)t;
                        }
                        if (t instanceof RuntimeException) {
                            throw (RuntimeException)t;
                        }
                        throw new IllegalStateException(t);
                    }
                }).filter(o -> o != null).map(o -> o.toString());
            } else if (iclasses[0] == Locale.class) {
                i = Stream.of(Locale.getAvailableLocales()).map(Locale::toString);
            } else if (iclasses[0] == ZoneId.class) {
                i = ZoneId.getAvailableZoneIds().stream();
            } else if (Enum.class.isAssignableFrom(iclasses[0])) {
                i = Stream.of(iclasses[0].getEnumConstants()).map(e -> ((Enum)e).name());
            }
        }
        String[] exclude = keys ? ae.keyExclude() : ae.valueExclude();
        return Stream.of(Stream.of(keys ? ae.key() : ae.value()), s, i).flatMap(e -> e).filter(e -> !ArrayUtils.contains((Object[])exclude, (Object)e)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public JsonAnnotationSchemaFactoryWrapper() {
        super((WrapperFactory)new JsonAnnotationSchemaFactoryWrapperFactory());
        this.schemaProvider = new JsonAnnotationSchemaFactoryProvider();
    }

    void updateSchema(JsonSchema cschema, JsonSchema schema, BeanProperty prop, Set<Enum<?>> filteredEnumValues, Set<Enum<?>> filteredEnumKeyValues, Boolean which) {
        JsonPropertyLength al;
        Annotation ad;
        JsonPropertyEnumValues ae;
        SimpleTypeSchema sschema;
        JsonPropertyReadOnly aro;
        boolean keys = which != null && which != false;
        JavaType jtype = prop.getType();
        if (Optional.class.isAssignableFrom(jtype.getRawClass())) {
            jtype = jtype.containedType(0);
        }
        if (cschema == null && (aro = (JsonPropertyReadOnly)prop.getAnnotation(JsonPropertyReadOnly.class)) != null) {
            schema.setReadonly(Boolean.valueOf(true));
        }
        if (which != null) {
            if (which.booleanValue()) {
                JsonPropertyKeyDescription ak = (JsonPropertyKeyDescription)prop.getAnnotation(JsonPropertyKeyDescription.class);
                if (ak != null && !ak.value().isEmpty()) {
                    schema.setDescription(ak.value());
                }
            } else {
                JsonPropertyDescription apd;
                JsonPropertyValueDescription av = (JsonPropertyValueDescription)prop.getAnnotation(JsonPropertyValueDescription.class);
                if (av != null && !av.value().isEmpty()) {
                    schema.setDescription(av.value());
                } else if (StringUtils.isEmpty((CharSequence)schema.getDescription()) && (apd = (JsonPropertyDescription)prop.getAnnotation(JsonPropertyDescription.class)) != null) {
                    schema.setDescription(apd.value());
                }
            }
        }
        if (schema instanceof SimpleTypeSchema) {
            JsonPropertyDefaultValues adv;
            sschema = (SimpleTypeSchema)schema;
            JsonPropertyTitle at = (JsonPropertyTitle)prop.getAnnotation(JsonPropertyTitle.class);
            if (at != null) {
                String t;
                String string = t = keys ? at.key() : at.value();
                if (!t.isEmpty()) {
                    sschema.setTitle(t);
                }
            }
            if ((adv = (JsonPropertyDefaultValues)prop.getAnnotation(JsonPropertyDefaultValues.class)) != null) {
                sschema.setDefault(Stream.concat(Stream.of(adv.value()), Stream.of(adv.valueFromClass()).flatMap(c -> ReflectionUtils.getAllAnnotationsForMethodsAnnotatedWith(c, JsonPropertyDefaultValuesProvider.class, true).keySet().stream()).flatMap(m -> {
                    if (!Modifier.isStatic(m.getModifiers())) {
                        throw new IllegalArgumentException("json property default values provider method '" + m.getName() + "' is not static in class: " + m.getDeclaringClass().getSimpleName());
                    }
                    try {
                        Object ret = m.getParameterCount() == 1 ? m.invoke(null, keys ? filteredEnumKeyValues : filteredEnumValues) : m.invoke(null, new Object[0]);
                        if (ret == null) {
                            return Stream.empty();
                        }
                        Class<?> type = m.getReturnType();
                        if (type.isArray()) {
                            return IntStream.range(0, Array.getLength(ret)).mapToObj(j -> Array.get(ret, j));
                        }
                        if (ret instanceof Collection) {
                            return ((Collection)ret).stream();
                        }
                        if (ret instanceof Stream) {
                            return (Stream)ret;
                        }
                        if (ret instanceof Iterator) {
                            return StreamSupport.stream(Spliterators.spliteratorUnknownSize((Iterator)ret, 16), false);
                        }
                        if (ret instanceof Enumeration) {
                            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new EnumerationIterator((Enumeration)ret), 16), false);
                        }
                        if (ret instanceof Iterable) {
                            return StreamSupport.stream(((Iterable)ret).spliterator(), false);
                        }
                        return Stream.of(ret);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException(e);
                    }
                    catch (InvocationTargetException e) {
                        Throwable t = e.getTargetException();
                        if (t instanceof Error) {
                            throw (Error)t;
                        }
                        if (t instanceof RuntimeException) {
                            throw (RuntimeException)t;
                        }
                        throw new IllegalStateException(t);
                    }
                }).filter(o -> o != null).map(o -> o.toString())).collect(Collectors.joining(", ")));
            }
        }
        if (schema instanceof ValueTypeSchema) {
            JsonPropertyValueFormat avf;
            ValueTypeSchema vtschema = (ValueTypeSchema)schema;
            ae = (JsonPropertyEnumValues)prop.getAnnotation(JsonPropertyEnumValues.class);
            if (ae != null) {
                vtschema.setEnums(JsonAnnotationSchemaFactoryWrapper.getEnumValues(ae, keys ? filteredEnumKeyValues : filteredEnumValues, keys));
            }
            if ((avf = (JsonPropertyValueFormat)prop.getAnnotation(JsonPropertyValueFormat.class)) != null) {
                JsonValueFormat[] jvf;
                JsonValueFormat[] jsonValueFormatArray = jvf = keys ? avf.key() : avf.value();
                if (jvf.length > 0) {
                    vtschema.setFormat(jvf[0]);
                }
            }
        }
        if (schema instanceof ContainerTypeSchema) {
            ContainerTypeSchema ctschema = (ContainerTypeSchema)schema;
            if (!(schema instanceof MapTypesSchema) && (ae = (JsonPropertyEnumValues)prop.getAnnotation(JsonPropertyEnumValues.class)) != null) {
                ctschema.setEnums(JsonAnnotationSchemaFactoryWrapper.getEnumValues(ae, keys ? filteredEnumKeyValues : filteredEnumValues, keys));
            }
            JsonPropertyOneOfIntegerValues ai = (JsonPropertyOneOfIntegerValues)prop.getAnnotation(JsonPropertyOneOfIntegerValues.class);
            JsonPropertyOneOfLongValues al2 = (JsonPropertyOneOfLongValues)prop.getAnnotation(JsonPropertyOneOfLongValues.class);
            JsonPropertyOneOfFloatValues af = (JsonPropertyOneOfFloatValues)prop.getAnnotation(JsonPropertyOneOfFloatValues.class);
            ad = (JsonPropertyOneOfDoubleValues)prop.getAnnotation(JsonPropertyOneOfDoubleValues.class);
            Stream[] streamArray = new Stream[4];
            Stream<Object> stream = ai != null ? Stream.of(keys ? ai.key() : ai.value()) : (streamArray[0] = Stream.empty());
            Stream<Object> stream2 = al2 != null ? Stream.of(keys ? al2.key() : al2.value()) : (streamArray[1] = Stream.empty());
            Stream<Object> stream3 = af != null ? Stream.of(keys ? af.key() : af.value()) : (streamArray[2] = Stream.empty());
            streamArray[3] = ad != null ? Stream.of(keys ? ad.key() : ad.value()) : Stream.empty();
            ctschema.setOneOf((Set)Stream.of(streamArray).flatMap(n -> n).collect(Collectors.toCollection(LinkedHashSet::new)));
        }
        if (schema instanceof MapTypesSchema) {
            MapTypesSchema mschema = (MapTypesSchema)schema;
            this.updateSchema(schema, mschema.getKeysSchema(), prop, filteredEnumValues, filteredEnumKeyValues, true);
            this.updateSchema(schema, mschema.getValuesSchema(), prop, filteredEnumValues, filteredEnumKeyValues, false);
        } else if (schema.isObjectSchema()) {
            ObjectSchema oschema = (ObjectSchema)schema;
            ObjectSchema.AdditionalProperties aprops = oschema.getAdditionalProperties();
            if (aprops instanceof ObjectSchema.SchemaAdditionalProperties) {
                ObjectSchema.SchemaAdditionalProperties saprops = (ObjectSchema.SchemaAdditionalProperties)aprops;
                JsonSchema sschema2 = saprops.getJsonSchema();
                this.updateSchema(schema, sschema2, prop, filteredEnumValues, filteredEnumKeyValues, null);
            }
        } else if (schema.isArraySchema()) {
            ArraySchema aschema = schema.asArraySchema();
            al = (JsonPropertyLength)prop.getAnnotation(JsonPropertyLength.class);
            if (al != null) {
                int l;
                int n2 = l = keys ? al.key() : al.value();
                if (l >= 0) {
                    aschema.setMinItems(Integer.valueOf(l));
                    aschema.setMaxItems(Integer.valueOf(l));
                } else {
                    int max;
                    int min = keys ? al.keyMin() : al.valueMin();
                    int n3 = max = keys ? al.keyMax() : al.valueMax();
                    if (min >= 0) {
                        aschema.setMinItems(Integer.valueOf(min));
                    }
                    if (max >= 0) {
                        aschema.setMaxItems(Integer.valueOf(max));
                    }
                }
            }
            if (Set.class.isAssignableFrom(jtype.getRawClass())) {
                aschema.setUniqueItems(Boolean.valueOf(true));
            } else {
                JsonPropertyUniqueItems au = (JsonPropertyUniqueItems)prop.getAnnotation(JsonPropertyUniqueItems.class);
                if (au != null) {
                    aschema.setUniqueItems(Boolean.valueOf(true));
                }
            }
            ArraySchema.Items items = aschema.getItems();
            if (items.isArrayItems()) {
                ArraySchema.ArrayItems aitems = (ArraySchema.ArrayItems)items;
                for (JsonSchema ischema : aitems.getJsonSchemas()) {
                    this.updateSchema(schema, ischema, prop, filteredEnumValues, filteredEnumKeyValues, false);
                }
            } else if (items.isSingleItems()) {
                ArraySchema.SingleItems sitems = (ArraySchema.SingleItems)items;
                JsonSchema ischema = sitems.getSchema();
                this.updateSchema(schema, ischema, prop, filteredEnumValues, filteredEnumKeyValues, false);
            }
        } else if (schema.isNumberSchema()) {
            NumberSchema nschema = schema.asNumberSchema();
            JsonPropertyMaximumValue ama = (JsonPropertyMaximumValue)prop.getAnnotation(JsonPropertyMaximumValue.class);
            JsonPropertyMinimumValue ami = (JsonPropertyMinimumValue)prop.getAnnotation(JsonPropertyMinimumValue.class);
            if (ama != null) {
                double[] max;
                double[] dArray = max = keys ? ama.key() : ama.value();
                if (max.length > 0) {
                    nschema.setMaximum(Double.valueOf(max[0]));
                    if (keys ? ama.keyExclusive() : ama.valueExclusive()) {
                        nschema.setExclusiveMaximum(Boolean.valueOf(true));
                    }
                }
            }
            if (ami != null) {
                double[] min;
                double[] dArray = min = keys ? ami.key() : ami.value();
                if (min.length > 0) {
                    nschema.setMinimum(Double.valueOf(min[0]));
                    if (keys ? ami.keyExclusive() : ami.valueExclusive()) {
                        nschema.setExclusiveMinimum(Boolean.valueOf(true));
                    }
                }
            }
            if (schema.isIntegerSchema()) {
                IntegerSchema ischema = (IntegerSchema)schema;
                ad = (JsonPropertyDivisibleBy)prop.getAnnotation(JsonPropertyDivisibleBy.class);
                if (ad != null) {
                    int div;
                    int n4 = div = keys ? ad.key() : ad.value();
                    if (div > 0) {
                        ischema.setDivisibleBy(Integer.valueOf(div));
                    }
                }
            }
        } else if (schema.isStringSchema()) {
            JsonPropertyPattern ap;
            sschema = schema.asStringSchema();
            al = (JsonPropertyLength)prop.getAnnotation(JsonPropertyLength.class);
            if (al != null) {
                int l;
                int n5 = l = keys ? al.key() : al.value();
                if (l >= 0) {
                    sschema.setMinLength(Integer.valueOf(l));
                    sschema.setMaxLength(Integer.valueOf(l));
                } else {
                    int max;
                    int min = keys ? al.keyMin() : al.valueMin();
                    int n6 = max = keys ? al.keyMax() : al.valueMax();
                    if (min >= 0) {
                        sschema.setMinLength(Integer.valueOf(min));
                    }
                    if (max >= 0) {
                        sschema.setMaxLength(Integer.valueOf(max));
                    }
                }
            }
            if ((ap = (JsonPropertyPattern)prop.getAnnotation(JsonPropertyPattern.class)) != null) {
                sschema.setPattern(keys ? ap.key() : ap.value());
            } else {
                Class clazz = jtype.getRawClass();
                if (cschema != null) {
                    if (Map.class.isAssignableFrom(clazz)) {
                        clazz = (keys ? jtype.getKeyType() : jtype.getContentType()).getRawClass();
                    } else if (Collection.class.isAssignableFrom(clazz)) {
                        clazz = jtype.getContentType().getRawClass();
                    }
                }
            }
        }
    }

    public JsonArrayFormatVisitor expectArrayFormat(JavaType type) {
        this.type = type;
        if (type.getContentType().getRawClass().equals(Byte.TYPE)) {
            final StringVisitor visitor = (StringVisitor)this.expectStringFormat(type);
            this.schema = visitor.getSchema();
            return new ArrayVisitor(null, null){

                public JsonSchema getSchema() {
                    return visitor.getSchema();
                }

                public void itemsFormat(JsonFormatVisitable handler, JavaType contentType) throws JsonMappingException {
                }

                public void itemsFormat(JsonFormatTypes format) throws JsonMappingException {
                }
            };
        }
        if (this.visitorContext == null) {
            this.visitorContext = new JsonAnnotationVisitorContext();
        }
        final ArrayVisitor visitor = (ArrayVisitor)super.expectArrayFormat(type);
        final ArraySchema aschema = (ArraySchema)visitor.getSchema();
        return new ArrayVisitor(visitor.getProvider(), aschema, visitor.getWrapperFactory()){

            public SerializerProvider getProvider() {
                return visitor.getProvider();
            }

            public void setProvider(SerializerProvider provider) {
                visitor.setProvider(provider);
            }

            public void itemsFormat(JsonFormatVisitable handler, JavaType elementType) throws JsonMappingException {
                visitor.itemsFormat(handler, elementType);
                ArraySchema.Items items = aschema.getItems();
                if (items instanceof ArraySchema.SingleItems) {
                    ArraySchema.SingleItems sitems = (ArraySchema.SingleItems)items;
                    JsonSchema ischema = sitems.getSchema();
                    if (ischema instanceof ReferenceSchema && !(ischema instanceof ReferenceTypesSchema)) {
                        sitems.setSchema((JsonSchema)new ReferenceTypesSchema((ReferenceSchema)ischema, elementType));
                    }
                } else if (items instanceof ArraySchema.ArrayItems) {
                    ArraySchema.ArrayItems aitems = (ArraySchema.ArrayItems)aschema.getItems();
                    JsonSchema[] ischemas = aitems.getJsonSchemas();
                    for (int i = 0; i < ischemas.length; ++i) {
                        if (ischemas[i] instanceof ReferenceTypesSchema) continue;
                        ischemas[i] = new ReferenceTypesSchema((ReferenceSchema)ischemas[i], elementType);
                    }
                } else {
                    aschema.setItemsSchema((JsonSchema)JsonAnnotationSchemaFactoryWrapper.this.schemaProvider.anySchema());
                }
            }

            public void itemsFormat(JsonFormatTypes format) throws JsonMappingException {
                visitor.itemsFormat(format);
            }

            public JsonSchema getSchema() {
                return visitor.getSchema();
            }

            public WrapperFactory getWrapperFactory() {
                return visitor.getWrapperFactory();
            }

            public void setWrapperFactory(WrapperFactory wrapperFactory) {
                visitor.setWrapperFactory(wrapperFactory);
            }

            public Visitor setVisitorContext(VisitorContext rvc) {
                return visitor.setVisitorContext(rvc);
            }
        };
    }

    public JsonObjectFormatVisitor expectObjectFormat(JavaType type) {
        String typeName;
        String typeIdName;
        SerializerProvider p;
        ObjectVisitor visitor;
        this.type = type;
        if (this.visitorContext == null) {
            this.visitorContext = new JsonAnnotationVisitorContext();
        }
        if ((visitor = (ObjectVisitor)super.expectObjectFormat(type)).getSchema() instanceof ObjectTypesSchema) {
            ((ObjectTypesSchema)visitor.getSchema()).setJavaTypesFor(type);
        }
        final Class view = (p = this.getProvider()) != null ? p.getActiveView() : null;
        JsonTypeInfo jti = ReflectionUtils.findFirstAnnotation(type.getRawClass(), JsonTypeInfo.class);
        if (jti != null && jti.use() == JsonTypeInfo.Id.NAME) {
            typeIdName = jti.property();
            JsonTypeName jtn = type.getRawClass().getAnnotation(JsonTypeName.class);
            typeName = jtn != null ? jtn.value() : null;
        } else {
            typeIdName = null;
            typeName = null;
        }
        return new ObjectVisitorDecorator(visitor){

            private JsonSchema getPropertySchema(BeanProperty writer) {
                Map properties = ((ObjectSchema)this.getSchema()).getProperties();
                Object schema = (JsonSchema)properties.get(writer.getName());
                if (schema instanceof ReferenceSchema && !(schema instanceof ReferenceTypesSchema)) {
                    schema = new ReferenceTypesSchema((ReferenceSchema)schema, writer.getType());
                    properties.put(writer.getName(), schema);
                }
                return schema;
            }

            private boolean isIncluded(BeanProperty writer) {
                if (view == null) {
                    return true;
                }
                JsonView a = (JsonView)writer.getAnnotation(JsonView.class);
                if (a == null || ArrayUtils.isEmpty((Object[])a.value())) {
                    return true;
                }
                for (Class clazz : a.value()) {
                    if (!clazz.isAssignableFrom(view)) continue;
                    return true;
                }
                return false;
            }

            private void updateForTypeId(JsonSchema schema, BeanProperty writer) {
                SimpleTypeSchema sschema;
                if (schema instanceof SimpleTypeSchema && writer.getName().equals(typeIdName) && (sschema = (SimpleTypeSchema)schema).getDefault() == null) {
                    sschema.setDefault(typeName);
                }
            }

            private Set<Enum<?>> getPropertyEnumValues(JsonSchema schema, BeanProperty writer, boolean keys) {
                JsonPropertyEnumValues ae;
                if (schema instanceof ObjectSchema && writer.getType().isEnumType() && (ae = (JsonPropertyEnumValues)writer.getAnnotation(JsonPropertyEnumValues.class)) != null) {
                    Class[] aclasses;
                    Class[] classArray = aclasses = keys ? ae.keyAvailablesOf() : ae.valueAvailablesOf();
                    if (aclasses.length > 0) {
                        Set set = ReflectionUtils.getAllAnnotationsForMethodsAnnotatedWith(aclasses[0], JsonPropertyEnumValuesProvider.class, true).keySet().stream().flatMap(m -> {
                            if (!Modifier.isStatic(m.getModifiers())) {
                                throw new IllegalArgumentException("json property enum values provider method '" + m.getName() + "' is not static in class: " + aclasses[0].getSimpleName());
                            }
                            try {
                                Object ret = m.invoke(null, new Object[0]);
                                if (ret == null) {
                                    return Stream.empty();
                                }
                                Class<?> type = m.getReturnType();
                                if (type.isArray()) {
                                    return IntStream.range(0, Array.getLength(ret)).mapToObj(j -> Array.get(ret, j));
                                }
                                if (ret instanceof Collection) {
                                    return ((Collection)ret).stream();
                                }
                                if (ret instanceof Stream) {
                                    return (Stream)ret;
                                }
                                if (ret instanceof Iterator) {
                                    return StreamSupport.stream(Spliterators.spliteratorUnknownSize((Iterator)ret, 16), false);
                                }
                                if (ret instanceof Enumeration) {
                                    return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new EnumerationIterator((Enumeration)ret), 16), false);
                                }
                                if (ret instanceof Iterable) {
                                    return StreamSupport.stream(((Iterable)ret).spliterator(), false);
                                }
                                return Stream.of(ret);
                            }
                            catch (IllegalAccessException e) {
                                throw new IllegalStateException(e);
                            }
                            catch (InvocationTargetException e) {
                                Throwable t = e.getTargetException();
                                if (t instanceof Error) {
                                    throw (Error)t;
                                }
                                if (t instanceof RuntimeException) {
                                    throw (RuntimeException)t;
                                }
                                throw new IllegalStateException(t);
                            }
                        }).filter(o -> writer.getType().getRawClass().isInstance(o)).map(o -> (Enum)o).collect(Collectors.toCollection(LinkedHashSet::new));
                        return Collections.unmodifiableSet(set);
                    }
                }
                return Collections.emptySet();
            }

            public void optionalProperty(BeanProperty writer) throws JsonMappingException {
                if (this.isIncluded(writer)) {
                    ((JsonAnnotationVisitorContext)JsonAnnotationSchemaFactoryWrapper.this.visitorContext).withEnumValuesDo(this.getPropertyEnumValues(JsonAnnotationSchemaFactoryWrapper.this.schema, writer, false), this.getPropertyEnumValues(JsonAnnotationSchemaFactoryWrapper.this.schema, writer, true), (evs, eks) -> {
                        super.optionalProperty(writer);
                        JsonSchema schema = this.getPropertySchema(writer);
                        JsonAnnotationSchemaFactoryWrapper.this.updateSchema(null, schema, writer, (Set<Enum<?>>)evs, (Set<Enum<?>>)eks, null);
                        this.updateForTypeId(schema, writer);
                    });
                    if (this.getSchema() instanceof ObjectTypesSchema) {
                        ((ObjectTypesSchema)this.getSchema()).addBeanProperty(writer);
                    }
                }
            }

            public void property(BeanProperty writer) throws JsonMappingException {
                if (this.isIncluded(writer)) {
                    ((JsonAnnotationVisitorContext)JsonAnnotationSchemaFactoryWrapper.this.visitorContext).withEnumValuesDo(this.getPropertyEnumValues(JsonAnnotationSchemaFactoryWrapper.this.schema, writer, false), this.getPropertyEnumValues(JsonAnnotationSchemaFactoryWrapper.this.schema, writer, true), (evs, eks) -> {
                        super.property(writer);
                        JsonSchema schema = this.getPropertySchema(writer);
                        JsonAnnotationSchemaFactoryWrapper.this.updateSchema(null, schema, writer, (Set<Enum<?>>)evs, (Set<Enum<?>>)eks, null);
                        this.updateForTypeId(schema, writer);
                    });
                    if (this.getSchema() instanceof ObjectTypesSchema) {
                        ((ObjectTypesSchema)this.getSchema()).addBeanProperty(writer);
                    }
                }
            }
        };
    }

    public JsonMapFormatVisitor expectMapFormat(JavaType type) throws JsonMappingException {
        this.type = type;
        if (this.visitorContext == null) {
            this.visitorContext = new JsonAnnotationVisitorContext();
        }
        MapVisitor visitor = (MapVisitor)super.expectMapFormat(type);
        final MapTypesSchema mschema = new MapTypesSchema();
        this.schema = mschema;
        MapVisitor mvisitor = new MapVisitor(visitor.getProvider(), mschema, new JsonAnnotationSchemaFactoryWrapperFactory()){
            final MapTypesSchema schema;
            {
                super(x0, x1, x2);
                this.schema = mschema;
            }

            protected JsonSchema propertySchema(JsonFormatVisitable handler, JavaType propertyTypeHint, boolean key) throws JsonMappingException {
                JsonValueSerializer jvhandler;
                if (key && handler instanceof JsonValueSerializer && (jvhandler = (JsonValueSerializer)handler).handledType().equals(String.class)) {
                    return new StringTypesSchema(propertyTypeHint);
                }
                JsonSchema schema = super.propertySchema(handler, propertyTypeHint);
                if (schema instanceof ReferenceSchema) {
                    if (key) {
                        return new StringTypesSchema((ReferenceSchema)schema, propertyTypeHint);
                    }
                    if (!(schema instanceof ReferenceTypesSchema)) {
                        return new ReferenceTypesSchema((ReferenceSchema)schema, propertyTypeHint);
                    }
                }
                return schema;
            }

            public void keyFormat(JsonFormatVisitable handler, JavaType keyType) throws JsonMappingException {
                if (handler instanceof StdKeySerializers.StringKeySerializer) {
                    handler = new StringSerializer();
                }
                JsonSchema kschema = this.propertySchema(handler, keyType, true);
                this.schema.setKeysSchema(kschema);
                this.schema.setKeysType(keyType);
            }

            public void valueFormat(JsonFormatVisitable handler, JavaType valueType) throws JsonMappingException {
                JsonSchema vschema = this.propertySchema(handler, valueType, false);
                this.schema.setValuesSchema(vschema);
                this.schema.setValuesType(valueType);
            }
        };
        mvisitor.setVisitorContext(this.visitorContext);
        return mvisitor;
    }

    public JsonAnyFormatVisitor expectAnyFormat(JavaType type) {
        this.type = type;
        return super.expectAnyFormat(type);
    }

    public JsonBooleanFormatVisitor expectBooleanFormat(JavaType type) {
        this.type = type;
        return super.expectBooleanFormat(type);
    }

    public JsonIntegerFormatVisitor expectIntegerFormat(JavaType type) {
        this.type = type;
        return super.expectIntegerFormat(type);
    }

    public JsonNullFormatVisitor expectNullFormat(JavaType type) {
        this.type = type;
        return super.expectNullFormat(type);
    }

    public JsonNumberFormatVisitor expectNumberFormat(JavaType type) {
        this.type = type;
        return super.expectNumberFormat(type);
    }

    public JsonStringFormatVisitor expectStringFormat(JavaType type) {
        this.type = type;
        JsonStringFormatVisitor visitor = super.expectStringFormat(type);
        if (this.schema instanceof StringSchema) {
            StringTypesSchema sschema = new StringTypesSchema((StringSchema)this.schema, type);
            this.schema = sschema;
            return new StringVisitor((StringSchema)sschema);
        }
        return visitor;
    }

    public JsonSchema finalSchemaWithTitle() {
        JsonSchema schema = super.finalSchema();
        SimpleTypeSchema sschema = schema.asSimpleTypeSchema();
        if (sschema != null) {
            String title;
            if (this.type != null && sschema.getTitle() == null) {
                sschema.setTitle(this.type.getRawClass().getSimpleName());
            }
            if ((title = sschema.getTitle()) != null) {
                Class view;
                SerializerProvider p = this.getProvider();
                Class clazz = view = p != null ? p.getActiveView() : null;
                if (view != null) {
                    sschema.setTitle(title + " with view '" + JsonAnnotationSchemaFactoryWrapper.getViewName(view) + "'");
                }
            }
        }
        return schema;
    }
}

