/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.jackson.jsonSchema.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ReferenceSchema;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.helenus.jackson.databind.ExtendedBeanProperty;
import org.helenus.jackson.jsonSchema.types.ReferenceTypesSchema;

public class ObjectTypesSchema
extends ObjectSchema {
    @JsonIgnore
    private JavaType javaType;
    @JsonIgnore
    private final Set<JavaType> javaTypes;
    @JsonIgnore
    private final Map<String, BeanProperty> beans;

    public ObjectTypesSchema(ObjectTypesSchema schema) {
        this.javaType = schema.javaType;
        this.javaTypes = schema.javaTypes;
        this.beans = schema.beans;
        this.setId(schema.getId());
        this.set$ref(schema.get$ref());
        this.set$schema(schema.get$schema());
        this.setDisallow(schema.getDisallow());
        this.setExtends(schema.getExtends());
        this.setRequired(schema.getRequired());
        this.setReadonly(schema.getReadonly());
        this.setDescription(schema.getDescription());
        this.setDefault(schema.getDefault());
        this.setTitle(schema.getTitle());
        this.setPathStart(schema.getPathStart());
        this.setLinks(schema.getLinks());
        this.setEnums(schema.getEnums());
        this.setOneOf(schema.getOneOf());
        this.setAdditionalProperties(schema.getAdditionalProperties());
        this.setDependencies(schema.getDependencies());
        this.setPatternProperties(schema.getPatternProperties());
        this.setProperties(schema.getProperties());
    }

    public ObjectTypesSchema(ObjectTypesSchema schema, ReferenceSchema ref) {
        this(schema);
        this.setDisallow(ref.getDisallow());
        this.setExtends(ref.getExtends());
        this.setRequired(ref.getRequired());
        this.setReadonly(ref.getReadonly());
        this.setDescription(ref.getDescription());
        this.setDefault(ref.getDefault());
        this.setTitle(ref.getTitle());
        this.setPathStart(ref.getPathStart());
        this.setLinks(ref.getLinks());
    }

    public ObjectTypesSchema() {
        this.javaTypes = new LinkedHashSet<JavaType>(16);
        this.beans = new LinkedHashMap<String, BeanProperty>();
    }

    public void setJavaTypesFor(JavaType jtype) {
        if (Optional.class.isAssignableFrom(jtype.getRawClass())) {
            jtype = jtype.containedType(0);
        }
        this.javaType = jtype;
        this.javaTypes.clear();
        ReferenceTypesSchema.getJsonSubTypesFrom(jtype.getRawClass()).map(c -> SimpleType.construct((Class)c)).forEach(t -> this.javaTypes.add((JavaType)t));
        if (this.javaTypes.isEmpty()) {
            this.javaTypes.add(jtype);
        }
    }

    public JavaType getJavaType() {
        return this.javaType;
    }

    public Set<JavaType> getJavaTypes() {
        return this.javaTypes;
    }

    public ExtendedBeanProperty getBeanProperty(String name) {
        BeanProperty bean = this.beans.get(name);
        return bean != null ? new ExtendedBeanProperty(bean) : null;
    }

    public void addBeanProperty(BeanProperty prop) {
        if (prop instanceof ExtendedBeanProperty) {
            prop = ((ExtendedBeanProperty)prop).getBean();
        }
        this.beans.put(prop.getName(), prop);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)((Object)this));
    }
}

