/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.jackson.jsonSchema.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.module.jsonSchema.types.ReferenceSchema;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.helenus.commons.lang3.reflect.ReflectionUtils;
import org.helenus.jackson.jsonSchema.types.ObjectTypesSchema;

public class ReferenceTypesSchema
extends ReferenceSchema {
    @JsonIgnore
    private JavaType javaType;
    @JsonIgnore
    private final Set<JavaType> javaTypes;

    static <T> Stream<Class<? extends T>> getJsonSubTypesFrom(Class<T> clazz) {
        JsonSubTypes jst = ReflectionUtils.findFirstAnnotation(clazz, JsonSubTypes.class);
        if (jst != null) {
            return Stream.of(jst.value()).map(t -> t.value()).filter(c -> clazz.isAssignableFrom((Class<?>)c)).map(c -> c);
        }
        return Stream.empty();
    }

    public ReferenceTypesSchema(ReferenceSchema schema, JavaType jtype) {
        super(schema.get$ref());
        Set jtypes = null;
        if (schema instanceof ReferenceTypesSchema) {
            this.javaType = ((ReferenceTypesSchema)schema).javaType;
            jtypes = ((ReferenceTypesSchema)schema).javaTypes;
        }
        if (this.javaType == null) {
            if (Optional.class.isAssignableFrom(jtype.getRawClass())) {
                jtype = jtype.containedType(0);
            }
            this.javaType = jtype;
            jtypes = ReferenceTypesSchema.getJsonSubTypesFrom(jtype.getRawClass()).map(c -> SimpleType.construct((Class)c)).collect(Collectors.toCollection(LinkedHashSet::new));
            if (jtypes.isEmpty()) {
                jtypes.add(jtype);
            }
        }
        this.javaTypes = jtypes;
        this.setId(schema.getId());
        this.set$ref(schema.get$ref());
        this.set$schema(schema.get$schema());
        this.setDisallow(schema.getDisallow());
        this.setExtends(schema.getExtends());
        this.setRequired(schema.getRequired());
        this.setReadonly(schema.getReadonly());
        this.setDescription(schema.getDescription());
        this.setDefault(schema.getDefault());
        this.setTitle(schema.getTitle());
        this.setPathStart(schema.getPathStart());
        this.setLinks(schema.getLinks());
    }

    public ReferenceTypesSchema(ObjectTypesSchema schema) {
        super(schema.getId());
        this.javaType = schema.getJavaType();
        this.javaTypes = new LinkedHashSet<JavaType>(schema.getJavaTypes());
    }

    public JavaType getJavaType() {
        return this.javaType;
    }

    public Set<JavaType> getJavaTypes() {
        return this.javaTypes;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)((Object)this));
    }
}

