/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.jackson.jsonSchema.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.module.jsonSchema.types.ReferenceSchema;
import com.fasterxml.jackson.module.jsonSchema.types.StringSchema;
import java.time.ZoneId;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.helenus.jackson.jsonSchema.types.ReferenceTypesSchema;

public class StringTypesSchema
extends StringSchema {
    @JsonIgnore
    private JavaType javaType;
    @JsonIgnore
    private final Set<JavaType> javaTypes;

    public StringTypesSchema(ReferenceSchema schema, JavaType jtype) {
        Set jtypes = null;
        if (schema instanceof ReferenceTypesSchema) {
            this.javaType = ((ReferenceTypesSchema)schema).getJavaType();
            jtypes = ((ReferenceTypesSchema)schema).getJavaTypes();
        }
        if (this.javaType == null) {
            if (Optional.class.isAssignableFrom(jtype.getRawClass())) {
                jtype = jtype.containedType(0);
            }
            this.javaType = jtype;
            jtypes = ReferenceTypesSchema.getJsonSubTypesFrom(jtype.getRawClass()).map(c -> SimpleType.construct((Class)c)).collect(Collectors.toCollection(LinkedHashSet::new));
            if (jtypes.isEmpty()) {
                jtypes.add(jtype);
            }
        }
        this.javaTypes = jtypes;
        this.setId(schema.getId());
        this.set$ref(schema.get$ref());
        this.set$schema(schema.get$schema());
        this.setDisallow(schema.getDisallow());
        this.setExtends(schema.getExtends());
        this.setRequired(schema.getRequired());
        this.setReadonly(schema.getReadonly());
        this.setDescription(schema.getDescription());
        this.setDefault(schema.getDefault());
        this.setTitle(schema.getTitle());
        this.setPathStart(schema.getPathStart());
        this.setLinks(schema.getLinks());
    }

    public StringTypesSchema(StringSchema schema, JavaType jtype) {
        Set jtypes = null;
        if (schema instanceof StringTypesSchema) {
            this.javaType = ((StringTypesSchema)schema).getJavaType();
            jtypes = ((StringTypesSchema)schema).getJavaTypes();
        }
        if (this.javaType == null) {
            if (jtype == null) {
                jtypes = Collections.emptySet();
            } else {
                if (Optional.class.isAssignableFrom(jtype.getRawClass())) {
                    jtype = jtype.containedType(0);
                }
                this.javaType = jtype;
                jtypes = ReferenceTypesSchema.getJsonSubTypesFrom(jtype.getRawClass()).map(c -> SimpleType.construct((Class)c)).collect(Collectors.toCollection(LinkedHashSet::new));
                if (jtypes.isEmpty()) {
                    jtypes.add(jtype);
                }
            }
        }
        this.javaTypes = jtypes;
        this.setId(schema.getId());
        this.set$ref(schema.get$ref());
        this.set$schema(schema.get$schema());
        this.setDisallow(schema.getDisallow());
        this.setExtends(schema.getExtends());
        this.setRequired(schema.getRequired());
        this.setReadonly(schema.getReadonly());
        this.setDescription(schema.getDescription());
        this.setDefault(schema.getDefault());
        this.setTitle(schema.getTitle());
        this.setPathStart(schema.getPathStart());
        this.setLinks(schema.getLinks());
        this.getEnums().addAll(schema.getEnums());
        this.setFormat(schema.getFormat());
        this.setMaxLength(schema.getMaxLength());
        this.setMinLength(schema.getMinLength());
        this.setPattern(schema.getPattern());
        if (jtype != null) {
            if (Locale.class.isAssignableFrom(jtype.getRawClass())) {
                this.setPattern("^([a-zA-Z]{2,8}(_[a-zA-Z]{2}|[0-9]{3})?([-_]([0-9][0-9a-zA-Z]{3}|[0-9a-zA-Z]{5,8}))?)?$");
            } else if (ZoneId.class.isAssignableFrom(jtype.getRawClass())) {
                this.setEnums(Stream.of(TimeZone.getAvailableIDs()).collect(Collectors.toCollection(TreeSet::new)));
            } else if (UUID.class.isAssignableFrom(jtype.getRawClass())) {
                this.setPattern("^(?i)[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$");
            } else if (Class.class.isAssignableFrom(jtype.getRawClass())) {
                this.setPattern("\\p{ASCII}+");
            } else if (jtype.isArrayType() && jtype.getContentType().getRawClass().equals(Byte.TYPE)) {
                this.setPattern("^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$");
            }
        }
    }

    public StringTypesSchema(JavaType jtype) {
        if (Optional.class.isAssignableFrom(jtype.getRawClass())) {
            jtype = jtype.containedType(0);
        }
        this.javaType = jtype;
        this.javaTypes = ReferenceTypesSchema.getJsonSubTypesFrom(jtype.getRawClass()).map(c -> SimpleType.construct((Class)c)).collect(Collectors.toCollection(LinkedHashSet::new));
        if (this.javaTypes.isEmpty()) {
            this.javaTypes.add(jtype);
        }
    }

    public JavaType getJavaType() {
        return this.javaType;
    }

    public Set<JavaType> getJavaTypes() {
        return this.javaTypes;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)((Object)this));
    }
}

