/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.lang;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class CloneUtils {
    public static <T> T clone(T obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Cloneable) {
            Method m;
            Class<?> clazz = obj.getClass();
            try {
                m = clazz.getMethod("clone", null);
            }
            catch (NoSuchMethodException e) {
                throw (NoSuchMethodError)new NoSuchMethodError(e.getMessage()).initCause(e);
            }
            try {
                return (T)m.invoke(obj, (Object[])null);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof CloneNotSupportedException) {
                    throw new IllegalArgumentException(cause.getMessage(), cause);
                }
                throw new IllegalStateException("unexpected exception", cause);
            }
            catch (IllegalAccessException e) {
                throw (IllegalAccessError)new IllegalAccessError(e.getMessage()).initCause(e);
            }
        }
        throw new IllegalArgumentException("clone not supported: " + obj.getClass().getName());
    }

    private CloneUtils() {
    }
}

