/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.util;

import org.helenus.util.Objects;

public class Arrays {
    static boolean deepEquals0(Object e1, Object e2, double epsilon) {
        assert (e1 != null);
        if (e1 instanceof Object[] && e2 instanceof Object[]) {
            return Arrays.deepEquals((Object[])e1, (Object[])e2, epsilon);
        }
        if (e1 instanceof byte[] && e2 instanceof byte[]) {
            return java.util.Arrays.equals((byte[])e1, (byte[])e2);
        }
        if (e1 instanceof short[] && e2 instanceof short[]) {
            return java.util.Arrays.equals((short[])e1, (short[])e2);
        }
        if (e1 instanceof int[] && e2 instanceof int[]) {
            return java.util.Arrays.equals((int[])e1, (int[])e2);
        }
        if (e1 instanceof long[] && e2 instanceof long[]) {
            return java.util.Arrays.equals((long[])e1, (long[])e2);
        }
        if (e1 instanceof char[] && e2 instanceof char[]) {
            return java.util.Arrays.equals((char[])e1, (char[])e2);
        }
        if (e1 instanceof float[] && e2 instanceof float[]) {
            return Arrays.equals((float[])e1, (float[])e2, epsilon);
        }
        if (e1 instanceof double[] && e2 instanceof double[]) {
            return Arrays.equals((double[])e1, (double[])e2, epsilon);
        }
        if (e1 instanceof boolean[] && e2 instanceof boolean[]) {
            return java.util.Arrays.equals((boolean[])e1, (boolean[])e2);
        }
        return Objects.equals(e1, e2, epsilon);
    }

    public static boolean equals(double[] a, double[] a2, double epsilon) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (!(Math.abs(a[i] - a2[i]) > epsilon) || Double.doubleToLongBits(a[i]) == Double.doubleToLongBits(a2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(float[] a, float[] a2, double epsilon) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (!((double)Math.abs(a[i] - a2[i]) > epsilon) || Float.floatToIntBits(a[i]) == Float.floatToIntBits(a2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object[] a, Object[] a2, double epsilon) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (Objects.equals(a[i], a2[i], epsilon)) continue;
            return false;
        }
        return true;
    }

    public static boolean deepEquals(Object[] a1, Object[] a2, double epsilon) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        int length = a1.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            Object e1 = a1[i];
            Object e2 = a2[i];
            if (e1 == e2) continue;
            if (e1 == null) {
                return false;
            }
            if (Arrays.deepEquals0(e1, e2, epsilon)) continue;
            return false;
        }
        return true;
    }
}

