/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.util;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.Validate;
import org.helenus.commons.lang3.ExceptionUtils;
import org.helenus.util.function.E2Runnable;
import org.helenus.util.function.E2Supplier;
import org.helenus.util.function.EConsumer;
import org.helenus.util.function.EFunction;
import org.helenus.util.function.ERunnable;
import org.helenus.util.function.ESupplier;

public class Inhibit {
    public static void interruptionsWhileSleeping(long delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static <E extends Exception> void interruptionsAndThrowOtherWhileSleeping(long delay, E e) throws E {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw ExceptionUtils.withRootCause(e, ie);
        }
    }

    public static final boolean interruptionsWhileTryingLock(Lock lock, long time, TimeUnit unit) {
        Validate.notNull((Object)lock, (String)"invalid null lock", (Object[])new Object[0]);
        try {
            return lock.tryLock(time, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void interruptionsWhileWaitingForNotificationFrom(Object obj) {
        Validate.notNull((Object)obj, (String)"invalid null object", (Object[])new Object[0]);
        try {
            Object object = obj;
            synchronized (object) {
                obj.wait();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static final <T> T interruptionsWhileWaitingFor(Future<T> future) throws ExecutionException {
        Validate.notNull(future, (String)"invalid null future", (Object[])new Object[0]);
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public static final <T> T interruptionsWhileWaitingFor(Future<T> future, long time, TimeUnit unit) throws ExecutionException, TimeoutException {
        Validate.notNull(future, (String)"invalid null future", (Object[])new Object[0]);
        try {
            return future.get(time, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T, E extends Throwable> T interruptionsAndReturn(E2Supplier<T, E, InterruptedException> cmd, EFunction<InterruptedException, T, E> handle) throws E {
        Validate.notNull(cmd, (String)"invalid null operation", (Object[])new Object[0]);
        Validate.notNull(handle, (String)"invalid null handle function", (Object[])new Object[0]);
        try {
            return cmd.get();
        }
        catch (InterruptedException e) {
            try {
                T t = handle.apply(e);
                return t;
            }
            finally {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static final <E extends Throwable> void interruptions(E2Runnable<E, InterruptedException> cmd, EConsumer<InterruptedException, E> handle) throws E {
        Validate.notNull(cmd, (String)"invalid null command", (Object[])new Object[0]);
        Validate.notNull(handle, (String)"invalid null handle consumer", (Object[])new Object[0]);
        try {
            cmd.run();
        }
        catch (InterruptedException e) {
            try {
                handle.accept(e);
            }
            finally {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T, E extends Exception> T interruptionsAndExceptionsAndReturn(ESupplier<T, Exception> cmd, EFunction<Exception, T, E> handle) throws E {
        Validate.notNull(cmd, (String)"invalid null operation", (Object[])new Object[0]);
        Validate.notNull(handle, (String)"invalid null handle function", (Object[])new Object[0]);
        try {
            return cmd.get();
        }
        catch (InterruptedException e) {
            try {
                T t = handle.apply(e);
                return t;
            }
            finally {
                Thread.currentThread().interrupt();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            return handle.apply(e);
        }
    }

    public static final <E extends Exception> void interruptionsAndExceptions(ERunnable<Exception> cmd, EConsumer<Exception, E> handle) throws E {
        Validate.notNull(cmd, (String)"invalid null command", (Object[])new Object[0]);
        Validate.notNull(handle, (String)"invalid null handle consumer", (Object[])new Object[0]);
        try {
            cmd.run();
        }
        catch (InterruptedException e) {
            try {
                handle.accept(e);
            }
            finally {
                Thread.currentThread().interrupt();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            handle.accept(e);
        }
    }

    public static final <T, E extends Throwable> T interruptionsWhileRetryingAndReturn(E2Supplier<T, E, InterruptedException> cmd) throws E {
        Validate.notNull(cmd, (String)"invalid null operation", (Object[])new Object[0]);
        boolean interrupted = false;
        while (true) {
            try {
                T t = cmd.get();
                return t;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static final <E extends Throwable> void interruptionsWhileRetrying(E2Runnable<E, InterruptedException> cmd) throws E {
        Validate.notNull(cmd, (String)"invalid null command", (Object[])new Object[0]);
        boolean interrupted = false;
        try {
            while (true) {
                try {
                    while (true) {
                        cmd.run();
                    }
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            throw throwable;
        }
    }

    public static final boolean interruptionsWhileRetryingTryingLock(Lock lock, long time, TimeUnit unit) {
        long end = System.nanoTime() + unit.toNanos(time);
        boolean interrupted = false;
        try {
            long nanos = end - System.nanoTime();
            if (nanos < 0L) {
                boolean bl = false;
                return bl;
            }
            boolean bl = lock.tryLock(nanos, TimeUnit.NANOSECONDS);
            return bl;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static final <T> T interruptionsWhileRetryingWaitingFor(Future<T> future) throws ExecutionException {
        Validate.notNull(future, (String)"invalid null future", (Object[])new Object[0]);
        boolean interrupted = false;
        while (true) {
            try {
                T t = future.get();
                return t;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static final <T> T interruptionsWhileRetryingWaitingFor(Future<T> future, long time, TimeUnit unit) throws ExecutionException, TimeoutException {
        Validate.notNull(future, (String)"invalid null future", (Object[])new Object[0]);
        long end = System.nanoTime() + unit.toNanos(time);
        boolean interrupted = false;
        while (true) {
            T t;
            long nanos = end - System.nanoTime();
            if (nanos < 0L) {
                throw new TimeoutException();
            }
            try {
                t = future.get(nanos, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            return t;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static final void interruptionsWhileRetryingWaitingForNotificationFrom(Object obj) {
        Validate.notNull((Object)obj, (String)"invalid null object", (Object[])new Object[0]);
        boolean interrupted = false;
        try {
            Object object = obj;
            synchronized (object) {
                while (true) {
                    try {
                        obj.wait();
                        return;
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        continue;
                    }
                    break;
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static final <T, E extends Exception> T interruptionsWhileRetryingAndExceptionsAndReturn(ESupplier<T, Exception> cmd, EFunction<Exception, T, E> handle) throws E {
        Validate.notNull(cmd, (String)"invalid null operation", (Object[])new Object[0]);
        Validate.notNull(handle, (String)"invalid null handle function", (Object[])new Object[0]);
        try {
            return (T)Inhibit.interruptionsWhileRetryingAndReturn(() -> cmd.get());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            return handle.apply(e);
        }
    }

    public static final <E extends Exception> void interruptionsWhileRetryingAndExceptions(ERunnable<Exception> cmd, EConsumer<Exception, E> handle) throws E {
        Validate.notNull(cmd, (String)"invalid null command", (Object[])new Object[0]);
        Validate.notNull(handle, (String)"invalid null handle consumer", (Object[])new Object[0]);
        try {
            Inhibit.interruptionsWhileRetrying(() -> cmd.run());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            handle.accept(e);
        }
    }

    public static final void exceptionsWhileClosing(Reader r) {
        if (r != null) {
            try {
                r.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void exceptionsWhileClosing(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final <T, E extends Throwable> T throwablesAndReturn(ESupplier<T, Throwable> cmd, EFunction<Throwable, T, E> handle) throws E {
        Validate.notNull(cmd, (String)"invalid null operation", (Object[])new Object[0]);
        Validate.notNull(handle, (String)"invalid null handle function", (Object[])new Object[0]);
        try {
            return cmd.get();
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (StackOverflowError e) {
            throw e;
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (ThreadDeath t) {
            throw t;
        }
        catch (Throwable t) {
            return handle.apply(t);
        }
    }

    public static final <E extends Throwable> void throwables(ERunnable<Throwable> cmd, EConsumer<Throwable, E> handle) throws E {
        Validate.notNull(cmd, (String)"invalid null command", (Object[])new Object[0]);
        Validate.notNull(handle, (String)"invalid null handle consumer", (Object[])new Object[0]);
        try {
            cmd.run();
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (StackOverflowError e) {
            throw e;
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (ThreadDeath t) {
            throw t;
        }
        catch (Throwable t) {
            handle.accept(t);
        }
    }

    public static final void throwables(ERunnable<Throwable> cmd) {
        Validate.notNull(cmd, (String)"invalid null command", (Object[])new Object[0]);
        try {
            cmd.run();
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (StackOverflowError e) {
            throw e;
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (ThreadDeath t) {
            throw t;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final <T, R, E extends Throwable> R throwablesAndReturn(T arg, EFunction<T, R, Throwable> cmd, EFunction<Throwable, R, E> handle) throws E {
        Validate.notNull(cmd, (String)"invalid null operation", (Object[])new Object[0]);
        Validate.notNull(handle, (String)"invalid null handle function", (Object[])new Object[0]);
        try {
            return cmd.apply(arg);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (StackOverflowError e) {
            throw e;
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (ThreadDeath t) {
            throw t;
        }
        catch (Throwable t) {
            return handle.apply(t);
        }
    }

    public static final <T, E extends Throwable> void throwables(T arg, EConsumer<T, Throwable> cmd, EConsumer<Throwable, E> handle) throws E {
        Validate.notNull(cmd, (String)"invalid null consumer", (Object[])new Object[0]);
        Validate.notNull(handle, (String)"invalid null handle consumer", (Object[])new Object[0]);
        try {
            cmd.accept(arg);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (StackOverflowError e) {
            throw e;
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (ThreadDeath t) {
            throw t;
        }
        catch (Throwable t) {
            handle.accept(t);
        }
    }

    public static final <T, E extends Throwable> T unwrappedThrowablesAndReturn(ESupplier<T, Throwable> cmd, EFunction<Throwable, T, E> handle) throws E {
        Validate.notNull(cmd, (String)"invalid null operation", (Object[])new Object[0]);
        return (T)Inhibit.throwablesAndReturn(() -> {
            try {
                return cmd.get();
            }
            catch (InvocationTargetException e) {
                Throwable te = e.getTargetException();
                throw te != null ? te : e;
            }
            catch (ExceptionInInitializerError e) {
                Throwable te = e.getException();
                throw te != null ? te : e;
            }
        }, handle);
    }

    public static final <E extends Throwable> void unwrappedThrowables(ERunnable<Throwable> cmd, EConsumer<Throwable, E> handle) throws E {
        Validate.notNull(cmd, (String)"invalid null command", (Object[])new Object[0]);
        Inhibit.unwrappedThrowables(() -> {
            try {
                cmd.run();
            }
            catch (InvocationTargetException e) {
                Throwable te = e.getTargetException();
                throw te != null ? te : e;
            }
            catch (ExceptionInInitializerError e) {
                Throwable te = e.getException();
                throw te != null ? te : e;
            }
        }, handle);
    }

    public static final <T, R, E extends Throwable> R unwrappedThrowablesAndReturn(T arg, EFunction<T, R, Throwable> cmd, EFunction<Throwable, R, E> handle) throws E {
        Validate.notNull(cmd, (String)"invalid null operation", (Object[])new Object[0]);
        return (R)Inhibit.throwablesAndReturn(arg, a -> {
            try {
                return cmd.apply(a);
            }
            catch (InvocationTargetException e) {
                Throwable te = e.getTargetException();
                throw te != null ? te : e;
            }
            catch (ExceptionInInitializerError e) {
                Throwable te = e.getException();
                throw te != null ? te : e;
            }
        }, handle);
    }

    public static final <T, E extends Throwable> void unwrappedThrowables(T arg, EConsumer<T, Throwable> cmd, EConsumer<Throwable, E> handle) throws E {
        Validate.notNull(cmd, (String)"invalid null consumer", (Object[])new Object[0]);
        Inhibit.throwables(arg, a -> {
            try {
                cmd.accept(a);
            }
            catch (InvocationTargetException e) {
                Throwable te = e.getTargetException();
                throw te != null ? te : e;
            }
            catch (ExceptionInInitializerError e) {
                Throwable te = e.getException();
                throw te != null ? te : e;
            }
        }, handle);
    }

    private Inhibit() {
    }
}

