/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.helenus.lang.Tolerable;
import org.helenus.util.Arrays;

public class Objects {
    public static boolean equalsIgnoreCase(Collection<String> a, Collection<String> b) {
        if (a == b) {
            return true;
        }
        if (a instanceof Set && b instanceof Set) {
            return java.util.Objects.equals(a.stream().map(StringUtils::lowerCase).collect(Collectors.toSet()), b.stream().map(StringUtils::lowerCase).collect(Collectors.toSet()));
        }
        if (a instanceof List && b instanceof List) {
            return java.util.Objects.equals(a.stream().map(StringUtils::lowerCase).collect(Collectors.toList()), b.stream().map(StringUtils::lowerCase).collect(Collectors.toList()));
        }
        return false;
    }

    public static boolean equals(Object a, Object b, double epsilon) {
        if (a == b) {
            return true;
        }
        if (a instanceof Tolerable) {
            return ((Tolerable)a).equals(b, epsilon);
        }
        if (a instanceof Optional) {
            if (b instanceof Optional) {
                Object ao = ((Optional)a).orElse(null);
                Object bo = ((Optional)b).orElse(null);
                return Objects.equals(ao, bo, epsilon);
            }
            return false;
        }
        if (a instanceof Float || a instanceof Double) {
            float bf;
            if (!(a instanceof Number)) {
                return false;
            }
            float af = ((Number)a).floatValue();
            if ((double)Math.abs(af - (bf = ((Number)b).floatValue())) > epsilon) {
                return Float.floatToIntBits(af) == Float.floatToIntBits(bf);
            }
            return true;
        }
        if (a instanceof Double || a instanceof Double) {
            double bd;
            if (!(a instanceof Number)) {
                return false;
            }
            double ad = ((Number)a).doubleValue();
            if (Math.abs(ad - (bd = ((Number)b).doubleValue())) > epsilon) {
                return Double.doubleToLongBits(ad) == Double.doubleToLongBits(bd);
            }
            return true;
        }
        if (a instanceof BigDecimal) {
            if (!(b instanceof Number)) {
                return false;
            }
            BigDecimal bd = b instanceof BigDecimal ? (BigDecimal)b : (b instanceof BigInteger ? new BigDecimal((BigInteger)b) : new BigDecimal(((Number)b).doubleValue()));
            return ((BigDecimal)a).subtract(bd).abs().compareTo(new BigDecimal(epsilon)) <= 0;
        }
        return a != null && a.equals(b);
    }

    public static boolean deepEquals(Object a, Object b, double epsilon) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return Arrays.deepEquals0(a, b, epsilon);
    }
}

