/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.util.stream;

import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;

public class Collectors {
    public static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toLinkedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return java.util.stream.Collectors.toMap(keyMapper, valueMapper, Collectors.throwingMerger(), LinkedHashMap::new);
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toLinkedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        return java.util.stream.Collectors.toMap(keyMapper, valueMapper, mergeFunction, LinkedHashMap::new);
    }

    public static <T, K, U> Collector<T, ?, TreeMap<K, U>> toTreeMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return java.util.stream.Collectors.toMap(keyMapper, valueMapper, Collectors.throwingMerger(), TreeMap::new);
    }

    public static <T, K, U> Collector<T, ?, TreeMap<K, U>> toTreeMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        return java.util.stream.Collectors.toMap(keyMapper, valueMapper, mergeFunction, TreeMap::new);
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toIdentityMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return java.util.stream.Collectors.toMap(keyMapper, valueMapper, Collectors.throwingMerger(), IdentityHashMap::new);
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toIdentityMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        return java.util.stream.Collectors.toMap(keyMapper, valueMapper, mergeFunction, IdentityHashMap::new);
    }
}

