/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria;

import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.AuditProperty;
import org.hibernate.envers.query.criteria.IdentifierEqAuditExpression;
import org.hibernate.envers.query.projection.AuditProjection;
import org.hibernate.envers.query.projection.PropertyAuditProjection;
import org.hibernate.envers.query.property.EntityPropertyName;
import org.hibernate.envers.query.property.OriginalIdPropertyName;
import org.hibernate.envers.query.property.PropertyNameGetter;

public class AuditId<T>
extends AuditProperty<T> {
    public static final String IDENTIFIER_PLACEHOLDER = "$$id$$";
    private static final PropertyNameGetter identifierPropertyGetter = new EntityPropertyName("$$id$$");

    public AuditId() {
        super(identifierPropertyGetter);
    }

    @Override
    public AuditCriterion eq(Object id) {
        return new IdentifierEqAuditExpression(id, true);
    }

    @Override
    public AuditCriterion ne(Object id) {
        return new IdentifierEqAuditExpression(id, false);
    }

    public AuditProjection count(String idPropertyName) {
        return new PropertyAuditProjection(new OriginalIdPropertyName(idPropertyName), "count", false);
    }

    @Override
    public AuditCriterion hasChanged() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AuditCriterion hasNotChanged() {
        throw new UnsupportedOperationException();
    }
}

