/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jmx.impl;

import java.util.Properties;
import javax.naming.InitialContext;
import org.hibernate.CacheMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.engine.service.classloading.spi.ClassLoaderService;
import org.hibernate.search.engine.service.classloading.spi.ClassLoadingException;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.jmx.IndexControlMBean;
import org.hibernate.search.util.impl.JNDIHelper;

public class IndexControl
implements IndexControlMBean {
    private final Properties jndiProperties;
    private final String sessionFactoryJndiName;
    private final ServiceManager serviceManager;
    private int batchSize = 25;
    private int numberOfObjectLoadingThreads = 2;
    private int numberOfFetchingThreads = 4;

    public IndexControl(Properties properties, ServiceManager serviceManager) {
        this.sessionFactoryJndiName = properties.getProperty("hibernate.session_factory_name");
        this.jndiProperties = JNDIHelper.getJndiProperties((Properties)properties, (String)"hibernate.jndi.");
        this.serviceManager = serviceManager;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setNumberOfObjectLoadingThreads(int numberOfThreads) {
        this.numberOfObjectLoadingThreads = numberOfThreads;
    }

    public int getNumberOfObjectLoadingThreads() {
        return this.numberOfObjectLoadingThreads;
    }

    public void setNumberOfFetchingThreads(int numberOfThreads) {
        this.numberOfFetchingThreads = numberOfThreads;
    }

    public int getNumberOfFetchingThreads() {
        return this.numberOfFetchingThreads;
    }

    public void index(String entity) {
        Class<?> clazz = this.getEntityClass(entity);
        SessionFactory factory = this.getSessionFactory();
        Session session = factory.openSession();
        FullTextSession fulltextSession = Search.getFullTextSession(session);
        try {
            fulltextSession.createIndexer(clazz).batchSizeToLoadObjects(this.batchSize).cacheMode(CacheMode.NORMAL).threadsToLoadObjects(this.numberOfObjectLoadingThreads).startAndWait();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SearchException("Unable to complete indexing");
        }
        session.close();
    }

    public void optimize(String entity) {
        Class<?> clazz = this.getEntityClass(entity);
        SessionFactory factory = this.getSessionFactory();
        Session session = factory.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession(session);
        fullTextSession.beginTransaction();
        fullTextSession.getSearchFactory().optimize(clazz);
        fullTextSession.getTransaction().commit();
        session.close();
    }

    public void purge(String entity) {
        Class<?> clazz = this.getEntityClass(entity);
        SessionFactory factory = this.getSessionFactory();
        Session session = factory.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession(session);
        fullTextSession.beginTransaction();
        fullTextSession.purgeAll(clazz);
        fullTextSession.getTransaction().commit();
        session.close();
    }

    private Class<?> getEntityClass(String entity) {
        Class clazz;
        ClassLoaderService classLoaderService = (ClassLoaderService)this.serviceManager.requestService(ClassLoaderService.class);
        try {
            clazz = classLoaderService.classForName(entity);
        }
        catch (ClassLoadingException e) {
            throw new IllegalArgumentException(entity + " not a indexed entity");
        }
        finally {
            this.serviceManager.releaseService(ClassLoaderService.class);
        }
        return clazz;
    }

    private SessionFactory getSessionFactory() {
        try {
            InitialContext initialContext = this.jndiProperties.isEmpty() ? new InitialContext() : new InitialContext(this.jndiProperties);
            return (SessionFactory)initialContext.lookup(this.sessionFactoryJndiName);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("In order for this operation to work the SessionFactory must be bound to JNDI");
        }
    }
}

