/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.sqlserver;

import java.io.Serializable;
import java.util.Map;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.spatial.GeolatteGeometryJavaTypeDescriptor;
import org.hibernate.spatial.GeolatteGeometryType;
import org.hibernate.spatial.JTSGeometryJavaTypeDescriptor;
import org.hibernate.spatial.JTSGeometryType;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.dialect.sqlserver.SqlServer2008GeometryTypeDescriptor;
import org.hibernate.spatial.dialect.sqlserver.SqlServerFunctions;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

class SqlServerSupport
implements SpatialDialect,
Serializable {
    private SqlServerFunctions functions = new SqlServerFunctions();

    SqlServerSupport() {
    }

    Iterable<? extends Map.Entry<String, SQLFunction>> functionsToRegister() {
        return this.functions;
    }

    void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        typeContributions.contributeType((BasicType)new GeolatteGeometryType(SqlServer2008GeometryTypeDescriptor.INSTANCE));
        typeContributions.contributeType((BasicType)new JTSGeometryType(SqlServer2008GeometryTypeDescriptor.INSTANCE));
        typeContributions.contributeJavaTypeDescriptor((JavaTypeDescriptor)GeolatteGeometryJavaTypeDescriptor.INSTANCE);
        typeContributions.contributeJavaTypeDescriptor(JTSGeometryJavaTypeDescriptor.INSTANCE);
    }

    @Override
    public String getSpatialRelateSQL(String columnName, int spatialRelation) {
        String stfunction;
        switch (spatialRelation) {
            case 4: {
                stfunction = "STWithin";
                break;
            }
            case 6: {
                stfunction = "STContains";
                break;
            }
            case 3: {
                stfunction = "STCrosses";
                break;
            }
            case 5: {
                stfunction = "STOverlaps";
                break;
            }
            case 1: {
                stfunction = "STDisjoint";
                break;
            }
            case 7: {
                stfunction = "STIntersects";
                break;
            }
            case 2: {
                stfunction = "STTouches";
                break;
            }
            case 0: {
                stfunction = "STEquals";
                break;
            }
            default: {
                throw new IllegalArgumentException("Spatial relation is not known by this dialect");
            }
        }
        return columnName + "." + stfunction + "(?) = 1";
    }

    @Override
    public String getSpatialFilterExpression(String columnName) {
        return columnName + ".Filter(?) = 1";
    }

    @Override
    public String getSpatialAggregateSQL(String columnName, int aggregation) {
        throw new UnsupportedOperationException("No spatial aggregate SQL functions.");
    }

    @Override
    public String getDWithinSQL(String columnName) {
        throw new UnsupportedOperationException("SQL Server has no DWithin function.");
    }

    @Override
    public String getHavingSridSQL(String columnName) {
        return columnName + ".STSrid = (?)";
    }

    @Override
    public String getIsEmptySQL(String columnName, boolean isEmpty) {
        String base = "(" + columnName + ".STIsEmpty() ";
        return isEmpty ? base + " = 1 )" : base + " = 0 )";
    }

    @Override
    public boolean supportsFiltering() {
        return true;
    }

    @Override
    public boolean supports(SpatialFunction function) {
        return this.functions.get(function.toString()) != null;
    }
}

