/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbmlint.detector;

import java.util.Iterator;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.tool.hbmlint.Detector;
import org.hibernate.tool.hbmlint.IssueCollector;

public abstract class EntityModelDetector
extends Detector {
    @Override
    public void visit(IssueCollector collector) {
        for (PersistentClass clazz : this.getMetadata().getEntityBindings()) {
            this.visit(clazz, collector);
        }
    }

    protected void visit(PersistentClass clazz, IssueCollector collector) {
        this.visitProperties(clazz, collector);
    }

    private void visitProperties(PersistentClass clazz, IssueCollector collector) {
        if (clazz.hasIdentifierProperty()) {
            this.visitProperty(clazz, clazz.getIdentifierProperty(), collector);
        }
        Iterator propertyIterator = clazz.getPropertyIterator();
        while (propertyIterator.hasNext()) {
            Property property = (Property)propertyIterator.next();
            this.visitProperty(clazz, property, collector);
        }
    }

    protected abstract void visitProperty(PersistentClass var1, Property var2, IssueCollector var3);
}

