/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.process.exec.maven.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.net.util.SSLContextUtils;
import org.apache.commons.net.util.TrustManagerUtils;
import org.apache.maven.plugin.logging.Log;
import org.honton.chas.process.exec.maven.plugin.HealthCheckUrl;

public class ProcessHealthCondition {
    private static final int SECONDS_BETWEEN_CHECKS = 1;
    private final Log log;
    private final HealthCheckUrl healthCheckUrl;
    private final int timeoutInSeconds;
    private final boolean validateSsl;

    public ProcessHealthCondition(Log log, HealthCheckUrl healthCheckUrl, int timeoutInSeconds, boolean validateSsl) {
        this.log = log;
        this.healthCheckUrl = healthCheckUrl;
        this.timeoutInSeconds = timeoutInSeconds;
        this.validateSsl = validateSsl;
    }

    public void waitSecondsUntilHealthy() {
        if (this.healthCheckUrl.getUrl() == null) {
            this.sleep(this.timeoutInSeconds);
            return;
        }
        long start = System.currentTimeMillis();
        while ((System.currentTimeMillis() - start) / 1000L < (long)this.timeoutInSeconds) {
            if (this.isSuccess()) {
                return;
            }
            this.sleep(1);
        }
        throw new RuntimeException("Process was not healthy even after " + this.timeoutInSeconds + " seconds");
    }

    private SSLSocketFactory getFactory() {
        try {
            if (this.validateSsl) {
                return SSLContext.getDefault().getSocketFactory();
            }
            return SSLContextUtils.createSSLContext((String)"TLS", null, (TrustManager)TrustManagerUtils.getAcceptAllTrustManager()).getSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to obtain SSLSocketFactory", e);
        }
    }

    private boolean isSuccess() {
        try {
            URL url = this.healthCheckUrl.getUrl();
            URLConnection connection = url.openConnection();
            if (connection instanceof HttpURLConnection) {
                return this.isHttpSuccess(url);
            }
            url.openStream().close();
            return true;
        }
        catch (IOException e) {
            this.log.debug((CharSequence)e.getMessage());
            return false;
        }
    }

    private boolean isHttpSuccess(URL url) throws IOException {
        HttpURLConnection http = (HttpURLConnection)url.openConnection();
        if (http instanceof HttpsURLConnection) {
            ((HttpsURLConnection)http).setSSLSocketFactory(this.getFactory());
        }
        this.log.debug((CharSequence)("GET " + url));
        http.setRequestMethod("GET");
        this.setHeaders(http);
        http.connect();
        try (InputStream in = http.getInputStream();){
            int code = http.getResponseCode();
            boolean bl = 200 <= code && code < 300;
            return bl;
        }
    }

    private void setHeaders(HttpURLConnection http) {
        if (this.healthCheckUrl.getHeaders() != null) {
            for (Map.Entry<Object, Object> entry : this.healthCheckUrl.getHeaders().entrySet()) {
                this.log.debug((CharSequence)(entry.getKey() + " = " + entry.getValue()));
                http.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private void sleep(int seconds) {
        try {
            this.log.debug((CharSequence)("waiting for " + seconds + " seconds"));
            Thread.sleep(TimeUnit.SECONDS.toMillis(seconds));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

