/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest.queue.push;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.hornetq.rest.HornetQRestLogger;
import org.hornetq.rest.queue.push.PushStore;
import org.hornetq.rest.queue.push.xml.PushRegistration;
import org.hornetq.rest.topic.PushTopicRegistration;

public class FilePushStore
implements PushStore {
    protected Map<String, PushRegistration> map = new HashMap<String, PushRegistration>();
    protected File dir;
    protected JAXBContext ctx;

    public FilePushStore(String dirname) throws Exception {
        this.dir = new File(dirname);
        this.ctx = JAXBContext.newInstance((Class[])new Class[]{PushRegistration.class, PushTopicRegistration.class});
        if (this.dir.exists()) {
            HornetQRestLogger.LOGGER.loadingRestStore(this.dir.getAbsolutePath());
            for (File file : this.dir.listFiles()) {
                if (!file.isFile()) continue;
                PushRegistration reg = null;
                try {
                    reg = (PushRegistration)this.ctx.createUnmarshaller().unmarshal(file);
                    reg.setLoadedFrom(file);
                    HornetQRestLogger.LOGGER.addingPushRegistration(reg.getId());
                    this.map.put(reg.getId(), reg);
                }
                catch (Exception e) {
                    HornetQRestLogger.LOGGER.errorLoadingStore(e, file.getName());
                }
            }
        }
    }

    public synchronized List<PushRegistration> getRegistrations() {
        ArrayList<PushRegistration> list = new ArrayList<PushRegistration>();
        list.addAll(this.map.values());
        return list;
    }

    @Override
    public synchronized List<PushRegistration> getByDestination(String destination) {
        ArrayList<PushRegistration> list = new ArrayList<PushRegistration>();
        for (PushRegistration reg : this.map.values()) {
            if (!reg.getDestination().equals(destination)) continue;
            list.add(reg);
        }
        return list;
    }

    @Override
    public synchronized void update(PushRegistration reg) throws Exception {
        if (reg.getLoadedFrom() == null) {
            return;
        }
        this.save(reg);
    }

    protected void save(PushRegistration reg) throws JAXBException {
        Marshaller marshaller = this.ctx.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)reg, (File)reg.getLoadedFrom());
    }

    @Override
    public synchronized void add(PushRegistration reg) throws Exception {
        this.map.put(reg.getId(), reg);
        if (!this.dir.exists()) {
            this.dir.mkdirs();
        }
        File fp = new File(this.dir, "reg-" + reg.getId() + ".xml");
        reg.setLoadedFrom(fp);
        this.save(reg);
    }

    @Override
    public synchronized void remove(PushRegistration reg) throws Exception {
        this.map.remove(reg.getId());
        if (reg.getLoadedFrom() == null) {
            return;
        }
        File fp = (File)reg.getLoadedFrom();
        fp.delete();
    }

    @Override
    public synchronized void removeAll() throws Exception {
        ArrayList<PushRegistration> copy = new ArrayList<PushRegistration>();
        copy.addAll(this.map.values());
        for (PushRegistration reg : copy) {
            this.remove(reg);
        }
        this.dir.delete();
    }
}

