/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.bind.JAXBContext;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.core.client.impl.ServerLocatorImpl;
import org.hornetq.core.remoting.impl.invm.InVMConnectorFactory;
import org.hornetq.rest.HornetQRestLogger;
import org.hornetq.rest.MessageServiceConfiguration;
import org.hornetq.rest.queue.DestinationSettings;
import org.hornetq.rest.queue.QueueServiceManager;
import org.hornetq.rest.topic.TopicServiceManager;
import org.hornetq.rest.util.CustomHeaderLinkStrategy;
import org.hornetq.rest.util.LinkHeaderLinkStrategy;
import org.hornetq.rest.util.LinkStrategy;
import org.hornetq.rest.util.TimeoutTask;
import org.hornetq.spi.core.naming.BindingRegistry;
import org.hornetq.utils.XMLUtil;

public class MessageServiceManager {
    protected ExecutorService threadPool;
    protected QueueServiceManager queueManager = new QueueServiceManager();
    protected TopicServiceManager topicManager = new TopicServiceManager();
    protected TimeoutTask timeoutTask;
    protected int timeoutTaskInterval = 1;
    protected MessageServiceConfiguration configuration = new MessageServiceConfiguration();
    protected boolean configSet = false;
    protected String configResourcePath;
    protected BindingRegistry registry;

    public BindingRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(BindingRegistry registry) {
        this.registry = registry;
    }

    public int getTimeoutTaskInterval() {
        return this.timeoutTaskInterval;
    }

    public void setTimeoutTaskInterval(int timeoutTaskInterval) {
        this.timeoutTaskInterval = timeoutTaskInterval;
        if (this.timeoutTask != null) {
            this.timeoutTask.setInterval(timeoutTaskInterval);
        }
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    public QueueServiceManager getQueueManager() {
        return this.queueManager;
    }

    public TopicServiceManager getTopicManager() {
        return this.topicManager;
    }

    public MessageServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getConfigResourcePath() {
        return this.configResourcePath;
    }

    public void setConfigResourcePath(String configResourcePath) {
        this.configResourcePath = configResourcePath;
    }

    public void setConfiguration(MessageServiceConfiguration configuration) {
        this.configuration = configuration;
        this.configSet = true;
    }

    public void start() throws Exception {
        if (this.configuration == null || !this.configSet) {
            if (this.configResourcePath == null) {
                this.configuration = new MessageServiceConfiguration();
            } else {
                URL url = this.getClass().getClassLoader().getResource(this.configResourcePath);
                if (url == null) {
                    url = new URL(this.configResourcePath);
                }
                JAXBContext jaxb = JAXBContext.newInstance((Class[])new Class[]{MessageServiceConfiguration.class});
                InputStreamReader reader = new InputStreamReader(url.openStream());
                String xml = XMLUtil.readerToString((Reader)reader);
                xml = XMLUtil.replaceSystemProps((String)xml);
                this.configuration = (MessageServiceConfiguration)jaxb.createUnmarshaller().unmarshal((Reader)new StringReader(xml));
            }
        }
        if (this.threadPool == null) {
            this.threadPool = Executors.newCachedThreadPool();
        }
        this.timeoutTaskInterval = this.configuration.getTimeoutTaskInterval();
        this.timeoutTask = new TimeoutTask(this.timeoutTaskInterval);
        this.threadPool.execute(this.timeoutTask);
        DestinationSettings defaultSettings = new DestinationSettings();
        defaultSettings.setConsumerSessionTimeoutSeconds(this.configuration.getConsumerSessionTimeoutSeconds());
        defaultSettings.setDuplicatesAllowed(this.configuration.isDupsOk());
        defaultSettings.setDurableSend(this.configuration.isDefaultDurableSend());
        HashMap<String, String> transportConfig = new HashMap<String, String>();
        transportConfig.put("server-id", this.configuration.getInVmId());
        ServerLocatorImpl consumerLocator = new ServerLocatorImpl(false, new TransportConfiguration[]{new TransportConfiguration(InVMConnectorFactory.class.getName(), transportConfig)});
        HornetQRestLogger.LOGGER.debug("Created ServerLocator: " + consumerLocator);
        if (this.configuration.getConsumerWindowSize() != -1) {
            consumerLocator.setConsumerWindowSize(this.configuration.getConsumerWindowSize());
        }
        ClientSessionFactory consumerSessionFactory = consumerLocator.createSessionFactory();
        HornetQRestLogger.LOGGER.debug("Created ClientSessionFactory: " + consumerSessionFactory);
        ServerLocatorImpl defaultLocator = new ServerLocatorImpl(false, new TransportConfiguration[]{new TransportConfiguration(InVMConnectorFactory.class.getName(), transportConfig)});
        ClientSessionFactory sessionFactory = defaultLocator.createSessionFactory();
        LinkStrategy linkStrategy = new LinkHeaderLinkStrategy();
        linkStrategy = this.configuration.isUseLinkHeaders() ? new LinkHeaderLinkStrategy() : new CustomHeaderLinkStrategy();
        this.queueManager.setServerLocator((ServerLocator)defaultLocator);
        this.queueManager.setSessionFactory(sessionFactory);
        this.queueManager.setTimeoutTask(this.timeoutTask);
        this.queueManager.setConsumerServerLocator((ServerLocator)consumerLocator);
        this.queueManager.setConsumerSessionFactory(consumerSessionFactory);
        this.queueManager.setDefaultSettings(defaultSettings);
        this.queueManager.setPushStoreFile(this.configuration.getQueuePushStoreDirectory());
        this.queueManager.setProducerPoolSize(this.configuration.getProducerSessionPoolSize());
        this.queueManager.setProducerTimeToLive(this.configuration.getProducerTimeToLive());
        this.queueManager.setLinkStrategy(linkStrategy);
        this.queueManager.setRegistry(this.registry);
        this.topicManager.setServerLocator((ServerLocator)defaultLocator);
        this.topicManager.setSessionFactory(sessionFactory);
        this.topicManager.setTimeoutTask(this.timeoutTask);
        this.topicManager.setConsumerServerLocator((ServerLocator)consumerLocator);
        this.topicManager.setConsumerSessionFactory(consumerSessionFactory);
        this.topicManager.setDefaultSettings(defaultSettings);
        this.topicManager.setPushStoreFile(this.configuration.getTopicPushStoreDirectory());
        this.topicManager.setProducerPoolSize(this.configuration.getProducerSessionPoolSize());
        this.queueManager.setProducerTimeToLive(this.configuration.getProducerTimeToLive());
        this.topicManager.setLinkStrategy(linkStrategy);
        this.topicManager.setRegistry(this.registry);
        this.queueManager.start();
        this.topicManager.start();
    }

    public void stop() {
        if (this.queueManager != null) {
            this.queueManager.stop();
        }
        this.queueManager = null;
        if (this.topicManager != null) {
            this.topicManager.stop();
        }
        this.topicManager = null;
    }
}

