/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest.topic;

import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.rest.HornetQRestLogger;
import org.hornetq.rest.queue.AcknowledgedQueueConsumer;
import org.hornetq.rest.queue.Acknowledgement;
import org.hornetq.rest.queue.DestinationServiceManager;
import org.hornetq.rest.queue.QueueConsumer;
import org.hornetq.rest.topic.AcknowledgedSubscriptionResource;
import org.hornetq.rest.topic.Subscription;
import org.hornetq.rest.topic.SubscriptionResource;
import org.hornetq.rest.util.TimeoutTask;

public class SubscriptionsResource
implements TimeoutTask.Callback {
    protected ConcurrentHashMap<String, QueueConsumer> queueConsumers = new ConcurrentHashMap();
    protected ClientSessionFactory sessionFactory;
    protected String destination;
    protected final String startup = Long.toString(System.currentTimeMillis());
    protected AtomicLong sessionCounter = new AtomicLong(1L);
    protected int consumerTimeoutSeconds;
    protected DestinationServiceManager serviceManager;

    public DestinationServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void setServiceManager(DestinationServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public int getConsumerTimeoutSeconds() {
        return this.consumerTimeoutSeconds;
    }

    public void setConsumerTimeoutSeconds(int consumerTimeoutSeconds) {
        this.consumerTimeoutSeconds = consumerTimeoutSeconds;
    }

    public ClientSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(ClientSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    @Override
    public boolean testTimeout(String target, boolean autoShutdown) {
        QueueConsumer consumer = this.queueConsumers.get(target);
        Subscription subscription = (Subscription)((Object)consumer);
        if (consumer == null) {
            return false;
        }
        if (System.currentTimeMillis() - consumer.getLastPingTime() > subscription.getTimeout()) {
            HornetQRestLogger.LOGGER.shutdownRestSubscription(consumer.getId());
            if (autoShutdown) {
                this.shutdown(consumer);
            }
            return true;
        }
        return false;
    }

    @Override
    public void shutdown(String target) {
        QueueConsumer consumer = this.queueConsumers.get(target);
        if (consumer == null) {
            return;
        }
        this.shutdown(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(QueueConsumer consumer) {
        QueueConsumer queueConsumer = consumer;
        synchronized (queueConsumer) {
            consumer.shutdown();
            this.queueConsumers.remove(consumer.getId());
            Subscription subscription = (Subscription)((Object)consumer);
            if (subscription.isDeleteWhenIdle()) {
                this.deleteSubscriberQueue(consumer);
            }
        }
    }

    public void stop() {
        for (QueueConsumer consumer : this.queueConsumers.values()) {
            consumer.shutdown();
            Subscription subscription = (Subscription)((Object)consumer);
            if (subscription.isDurable()) continue;
            this.deleteSubscriberQueue(consumer);
        }
        this.queueConsumers.clear();
    }

    protected String generateSubscriptionName() {
        return this.startup + "-" + this.sessionCounter.getAndIncrement() + "-" + this.destination;
    }

    @POST
    public Response createSubscription(@FormParam(value="durable") @DefaultValue(value="false") boolean durable, @FormParam(value="autoAck") @DefaultValue(value="true") boolean autoAck, @FormParam(value="name") String subscriptionName, @FormParam(value="selector") String selector, @FormParam(value="delete-when-idle") Boolean destroyWhenIdle, @FormParam(value="idle-timeout") Long timeout, @Context UriInfo uriInfo) {
        boolean deleteWhenIdle;
        HornetQRestLogger.LOGGER.debug("Handling POST request for \"" + uriInfo.getPath() + "\"");
        if (timeout == null) {
            timeout = this.consumerTimeoutSeconds * 1000;
        }
        boolean bl = deleteWhenIdle = !durable;
        if (destroyWhenIdle != null) {
            deleteWhenIdle = destroyWhenIdle;
        }
        if (subscriptionName != null) {
            QueueConsumer consumer = this.queueConsumers.get(subscriptionName);
            if (consumer != null) {
                boolean acked = consumer instanceof AcknowledgedSubscriptionResource;
                boolean bl2 = acked = !acked;
                if (acked != autoAck) {
                    throw new WebApplicationException(Response.status((int)412).entity((Object)"Consumer already exists and ack-modes don't match.").type("text/plain").build());
                }
                Subscription sub = (Subscription)((Object)consumer);
                if (sub.isDurable() != durable) {
                    throw new WebApplicationException(Response.status((int)412).entity((Object)"Consumer already exists and durability doesn't match.").type("text/plain").build());
                }
                Response.ResponseBuilder builder = Response.noContent();
                if (autoAck) {
                    this.headAutoAckSubscriptionResponse(uriInfo, consumer, builder);
                    consumer.setSessionLink(builder, uriInfo, (String)uriInfo.getMatchedURIs().get(1) + "/auto-ack/" + consumer.getId());
                } else {
                    this.headAcknowledgedConsumerResponse(uriInfo, (AcknowledgedQueueConsumer)consumer, builder);
                    consumer.setSessionLink(builder, uriInfo, (String)uriInfo.getMatchedURIs().get(1) + "/acknowledged/" + consumer.getId());
                }
                return builder.build();
            }
        } else {
            subscriptionName = this.generateSubscriptionName();
        }
        ClientSession session = null;
        try {
            if (!this.subscriptionExists(subscriptionName)) {
                session = this.sessionFactory.createSession();
                if (durable) {
                    session.createQueue(this.destination, subscriptionName, true);
                } else {
                    session.createTemporaryQueue(this.destination, subscriptionName);
                }
            }
            QueueConsumer consumer = this.createConsumer(durable, autoAck, subscriptionName, selector, timeout, deleteWhenIdle);
            this.queueConsumers.put(consumer.getId(), consumer);
            this.serviceManager.getTimeoutTask().add(this, consumer.getId());
            UriBuilder location = uriInfo.getAbsolutePathBuilder();
            if (autoAck) {
                location.path("auto-ack");
            } else {
                location.path("acknowledged");
            }
            location.path(consumer.getId());
            Response.ResponseBuilder builder = Response.created((URI)location.build(new Object[0]));
            if (autoAck) {
                QueueConsumer.setConsumeNextLink(this.serviceManager.getLinkStrategy(), builder, uriInfo, (String)uriInfo.getMatchedURIs().get(1) + "/auto-ack/" + consumer.getId(), "-1");
            } else {
                AcknowledgedQueueConsumer.setAcknowledgeNextLink(this.serviceManager.getLinkStrategy(), builder, uriInfo, (String)uriInfo.getMatchedURIs().get(1) + "/acknowledged/" + consumer.getId(), "-1");
            }
            Response response = builder.build();
            return response;
        }
        catch (HornetQException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (HornetQException e) {}
            }
        }
    }

    protected QueueConsumer createConsumer(boolean durable, boolean autoAck, String subscriptionName, String selector, long timeout, boolean deleteWhenIdle) throws HornetQException {
        QueueConsumer consumer;
        if (autoAck) {
            SubscriptionResource subscription = new SubscriptionResource(this.sessionFactory, subscriptionName, subscriptionName, this.serviceManager, selector, durable, timeout);
            subscription.setDurable(durable);
            subscription.setDeleteWhenIdle(deleteWhenIdle);
            consumer = subscription;
        } else {
            AcknowledgedSubscriptionResource subscription = new AcknowledgedSubscriptionResource(this.sessionFactory, subscriptionName, subscriptionName, this.serviceManager, selector, durable, timeout);
            subscription.setDurable(durable);
            subscription.setDeleteWhenIdle(deleteWhenIdle);
            consumer = subscription;
        }
        return consumer;
    }

    @Path(value="auto-ack/{consumer-id}")
    @GET
    public Response getAutoAckSubscription(@PathParam(value="consumer-id") String consumerId, @Context UriInfo uriInfo) throws Exception {
        HornetQRestLogger.LOGGER.debug("Handling GET request for \"" + uriInfo.getPath() + "\"");
        return this.internalHeadAutoAckSubscription(uriInfo, consumerId);
    }

    @Path(value="auto-ack/{consumer-id}")
    @HEAD
    public Response headAutoAckSubscription(@PathParam(value="consumer-id") String consumerId, @Context UriInfo uriInfo) throws Exception {
        HornetQRestLogger.LOGGER.debug("Handling HEAD request for \"" + uriInfo.getPath() + "\"");
        return this.internalHeadAutoAckSubscription(uriInfo, consumerId);
    }

    private Response internalHeadAutoAckSubscription(UriInfo uriInfo, String consumerId) {
        QueueConsumer consumer = this.findAutoAckSubscription(consumerId);
        Response.ResponseBuilder builder = Response.noContent();
        this.headAutoAckSubscriptionResponse(uriInfo, consumer, builder);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void headAutoAckSubscriptionResponse(UriInfo uriInfo, QueueConsumer consumer, Response.ResponseBuilder builder) {
        QueueConsumer queueConsumer = consumer;
        synchronized (queueConsumer) {
            QueueConsumer.setConsumeNextLink(this.serviceManager.getLinkStrategy(), builder, uriInfo, (String)uriInfo.getMatchedURIs().get(1) + "/acknowledged/" + consumer.getId(), Long.toString(consumer.getConsumeIndex()));
        }
    }

    @Path(value="auto-ack/{subscription-id}")
    public QueueConsumer findAutoAckSubscription(@PathParam(value="subscription-id") String subscriptionId) {
        QueueConsumer consumer = this.queueConsumers.get(subscriptionId);
        if (consumer == null) {
            consumer = this.recreateTopicConsumer(subscriptionId, true);
        }
        return consumer;
    }

    @Path(value="acknowledged/{consumer-id}")
    @GET
    public Response getAcknowledgedConsumer(@PathParam(value="consumer-id") String consumerId, @Context UriInfo uriInfo) throws Exception {
        HornetQRestLogger.LOGGER.debug("Handling GET request for \"" + uriInfo.getPath() + "\"");
        return this.internalHeadAcknowledgedConsumer(uriInfo, consumerId);
    }

    @Path(value="acknowledged/{consumer-id}")
    @HEAD
    public Response headAcknowledgedConsumer(@PathParam(value="consumer-id") String consumerId, @Context UriInfo uriInfo) throws Exception {
        HornetQRestLogger.LOGGER.debug("Handling HEAD request for \"" + uriInfo.getPath() + "\"");
        return this.internalHeadAcknowledgedConsumer(uriInfo, consumerId);
    }

    private Response internalHeadAcknowledgedConsumer(UriInfo uriInfo, String consumerId) {
        AcknowledgedQueueConsumer consumer = (AcknowledgedQueueConsumer)this.findAcknoledgeSubscription(consumerId);
        Response.ResponseBuilder builder = Response.ok();
        this.headAcknowledgedConsumerResponse(uriInfo, consumer, builder);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void headAcknowledgedConsumerResponse(UriInfo uriInfo, AcknowledgedQueueConsumer consumer, Response.ResponseBuilder builder) {
        AcknowledgedQueueConsumer acknowledgedQueueConsumer = consumer;
        synchronized (acknowledgedQueueConsumer) {
            Acknowledgement ack = consumer.getAck();
            if (ack == null || ack.wasSet()) {
                AcknowledgedQueueConsumer.setAcknowledgeNextLink(this.serviceManager.getLinkStrategy(), builder, uriInfo, (String)uriInfo.getMatchedURIs().get(1) + "/acknowledged/" + consumer.getId(), Long.toString(consumer.getConsumeIndex()));
            } else {
                consumer.setAcknowledgementLink(builder, uriInfo, (String)uriInfo.getMatchedURIs().get(1) + "/acknowledged/" + consumer.getId());
            }
        }
    }

    @Path(value="acknowledged/{subscription-id}")
    public QueueConsumer findAcknoledgeSubscription(@PathParam(value="subscription-id") String subscriptionId) {
        QueueConsumer consumer = this.queueConsumers.get(subscriptionId);
        if (consumer == null) {
            consumer = this.recreateTopicConsumer(subscriptionId, false);
        }
        return consumer;
    }

    private boolean subscriptionExists(String subscriptionId) {
        ClientSession session = null;
        try {
            session = this.sessionFactory.createSession();
            ClientSession.QueueQuery query = session.queueQuery(new SimpleString(subscriptionId));
            boolean bl = query.isExists();
            return bl;
        }
        catch (HornetQException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (HornetQException e) {}
            }
        }
    }

    private QueueConsumer recreateTopicConsumer(String subscriptionId, boolean autoAck) {
        QueueConsumer consumer;
        if (this.subscriptionExists(subscriptionId)) {
            QueueConsumer tmp = null;
            try {
                tmp = this.createConsumer(true, autoAck, subscriptionId, null, this.consumerTimeoutSeconds * 1000, false);
            }
            catch (HornetQException e) {
                throw new RuntimeException(e);
            }
            consumer = this.queueConsumers.putIfAbsent(subscriptionId, tmp);
            if (consumer == null) {
                consumer = tmp;
                this.serviceManager.getTimeoutTask().add(this, subscriptionId);
            } else {
                tmp.shutdown();
            }
        } else {
            throw new WebApplicationException(Response.status((int)405).entity((Object)("Failed to find subscriber " + subscriptionId + " you will have to reconnect")).type("text/plain").build());
        }
        return consumer;
    }

    @Path(value="acknowledged/{subscription-id}")
    @DELETE
    public void deleteAckSubscription(@Context UriInfo uriInfo, @PathParam(value="subscription-id") String consumerId) {
        HornetQRestLogger.LOGGER.debug("Handling DELETE request for \"" + uriInfo.getPath() + "\"");
        this.internalDeleteSubscription(consumerId);
    }

    @Path(value="auto-ack/{subscription-id}")
    @DELETE
    public void deleteSubscription(@Context UriInfo uriInfo, @PathParam(value="subscription-id") String consumerId) {
        HornetQRestLogger.LOGGER.debug("Handling DELETE request for \"" + uriInfo.getPath() + "\"");
        this.internalDeleteSubscription(consumerId);
    }

    private void internalDeleteSubscription(String consumerId) {
        QueueConsumer consumer = this.queueConsumers.remove(consumerId);
        if (consumer == null) {
            String msg = "Failed to match a subscription to URL " + consumerId;
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)msg).type("text/plain").build());
        }
        consumer.shutdown();
        this.deleteSubscriberQueue(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSubscriberQueue(QueueConsumer consumer) {
        String subscriptionName = consumer.getId();
        ClientSession session = null;
        try {
            session = this.sessionFactory.createSession();
            session.deleteQueue(subscriptionName);
        }
        catch (HornetQException e) {
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (HornetQException e) {}
            }
        }
    }
}

