/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest.queue;

import javax.ws.rs.core.Response;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.rest.HornetQRestLogger;
import org.hornetq.rest.HttpHeaderProperty;
import org.hornetq.rest.queue.ConsumedHttpMessage;
import org.hornetq.rest.queue.ConsumedObjectMessage;

public abstract class ConsumedMessage {
    public static final String POSTED_AS_HTTP_MESSAGE = "postedAsHttpMessage";
    protected ClientMessage message;

    public ConsumedMessage(ClientMessage message) {
        this.message = message;
    }

    public long getMessageID() {
        return this.message.getMessageID();
    }

    public abstract void build(Response.ResponseBuilder var1);

    protected void buildHeaders(Response.ResponseBuilder builder) {
        for (SimpleString key : this.message.getPropertyNames()) {
            String k = key.toString();
            String headerName = HttpHeaderProperty.fromPropertyName(k);
            if (headerName == null) continue;
            builder.header(headerName, (Object)this.message.getStringProperty(k));
            HornetQRestLogger.LOGGER.debug("Adding " + headerName + "=" + this.message.getStringProperty(k));
        }
    }

    public static ConsumedMessage createConsumedMessage(ClientMessage message) {
        Boolean aBoolean = message.getBooleanProperty(POSTED_AS_HTTP_MESSAGE);
        if (aBoolean != null && aBoolean.booleanValue()) {
            return new ConsumedHttpMessage(message);
        }
        if (message.getType() == 2) {
            return new ConsumedObjectMessage(message);
        }
        throw new IllegalArgumentException("ClientMessage must be an HTTP message or an Object message: " + message + " type: " + message.getType());
    }
}

