/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest.queue.push;

import java.io.IOException;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.jms.client.ConnectionFactoryOptions;
import org.hornetq.rest.HornetQRestLogger;
import org.hornetq.rest.queue.push.PushStrategy;
import org.hornetq.rest.queue.push.xml.BasicAuth;
import org.hornetq.rest.queue.push.xml.PushRegistration;
import org.hornetq.rest.queue.push.xml.XmlHttpHeader;
import org.hornetq.rest.util.HttpMessageHelper;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jboss.resteasy.specimpl.ResteasyUriBuilder;

public class UriStrategy
implements PushStrategy {
    ThreadSafeClientConnManager connManager = new ThreadSafeClientConnManager();
    protected HttpClient client = new DefaultHttpClient((ClientConnectionManager)this.connManager);
    protected BasicHttpContext localContext;
    protected ApacheHttpClient4Executor executor = new ApacheHttpClient4Executor(this.client);
    protected PushRegistration registration;
    protected UriBuilder targetUri;
    protected String method;
    protected String contentType;
    protected ConnectionFactoryOptions jmsOptions;

    UriStrategy() {
        this.connManager.setDefaultMaxPerRoute(100);
        this.connManager.setMaxTotal(1000);
    }

    @Override
    public void setRegistration(PushRegistration reg) {
        this.registration = reg;
    }

    @Override
    public void start() throws Exception {
        this.initAuthentication();
        this.method = this.registration.getTarget().getMethod();
        if (this.method == null) {
            this.method = "POST";
        }
        this.contentType = this.registration.getTarget().getType();
        this.targetUri = ResteasyUriBuilder.fromTemplate((String)this.registration.getTarget().getHref());
    }

    protected void initAuthentication() {
        if (this.registration.getAuthenticationMechanism() != null && this.registration.getAuthenticationMechanism().getType() instanceof BasicAuth) {
            BasicAuth basic = (BasicAuth)this.registration.getAuthenticationMechanism().getType();
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(basic.getUsername(), basic.getPassword());
            AuthScope authScope = new AuthScope(AuthScope.ANY);
            ((DefaultHttpClient)this.client).getCredentialsProvider().setCredentials(authScope, (Credentials)creds);
            this.localContext = new BasicHttpContext();
            BasicScheme basicAuth = new BasicScheme();
            this.localContext.setAttribute("preemptive-auth", (Object)basicAuth);
            ((DefaultHttpClient)this.client).addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuth(), 0);
            this.executor.setHttpContext((HttpContext)this.localContext);
        }
    }

    @Override
    public void stop() {
        this.connManager.shutdown();
    }

    @Override
    public void setJmsOptions(ConnectionFactoryOptions jmsOptions) {
        this.jmsOptions = jmsOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean push(ClientMessage message) {
        HornetQRestLogger.LOGGER.debug("Pushing " + message);
        uri = this.createUri(message);
        for (i = 0; i < this.registration.getMaxRetries(); ++i) {
            block21: {
                wait = this.registration.getRetryWaitMillis();
                System.out.println("Creating request from " + uri);
                request = this.executor.createRequest(uri);
                request.followRedirects(false);
                HornetQRestLogger.LOGGER.debug("Created request " + request);
                for (XmlHttpHeader header : this.registration.getHeaders()) {
                    HornetQRestLogger.LOGGER.debug("Setting XmlHttpHeader: " + header.getName() + "=" + header.getValue());
                    request.header(header.getName(), (Object)header.getValue());
                }
                HttpMessageHelper.buildMessage(message, request, this.contentType, this.jmsOptions);
                res = null;
                try {
                    HornetQRestLogger.LOGGER.debug(this.method + " " + uri);
                    res = request.httpMethod(this.method);
                    status = res.getStatus();
                    HornetQRestLogger.LOGGER.debug("Status of push: " + status);
                    if (status == 503) {
                        retryAfter = (String)res.getStringHeaders().getFirst((Object)"Retry-After");
                        if (retryAfter != null) {
                            wait = Long.parseLong(retryAfter) * 1000L;
                        }
                        break block21;
                    }
                    if (status == 307) {
                        uri = res.getLocation().toString();
                        wait = 0L;
                        break block21;
                    }
                    if (status >= 200 && status < 299 || status == 303 || status == 304) {
                        HornetQRestLogger.LOGGER.debug("Success");
                        var9_12 = true;
                        return var9_12;
                    }
                    if (status < 400) break block21;
                    switch (status) {
                        case 400: 
                        case 411: 
                        case 412: 
                        case 413: 
                        case 414: 
                        case 415: 
                        case 416: {
                            throw new RuntimeException("Something is wrong with the message, status returned: " + status + " for push registration of URI: " + uri);
                        }
                        case 401: 
                        case 402: 
                        case 403: 
                        case 405: 
                        case 406: 
                        case 407: 
                        case 417: 
                        case 505: {
                            var9_13 = false;
                            return var9_13;
                        }
                        case 404: 
                        case 408: 
                        case 409: 
                        case 410: {
                            ** break;
lbl44:
                            // 1 sources

                            break;
                        }
                        ** default:
lbl46:
                        // 1 sources

                        break;
                    }
                }
                catch (Exception e) {
                    HornetQRestLogger.LOGGER.debug("failed to push message to " + uri, e);
                    e.printStackTrace();
                    var9_14 = false;
                    return var9_14;
                }
                finally {
                    if (res != null) {
                        res.releaseConnection();
                    }
                }
            }
            try {
                if (wait <= 0L) continue;
                Thread.sleep(wait);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted");
            }
        }
        return false;
    }

    protected String createUri(ClientMessage message) {
        String uri = this.targetUri.build(new Object[0]).toString();
        return uri;
    }

    static class PreemptiveAuth
    implements HttpRequestInterceptor {
        PreemptiveAuth() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                AuthScheme authScheme = (AuthScheme)context.getAttribute("preemptive-auth");
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
                if (authScheme != null) {
                    Credentials creds = credsProvider.getCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()));
                    if (creds == null) {
                        throw new HttpException("No credentials for preemptive authentication");
                    }
                    authState.setAuthScheme(authScheme);
                    authState.setCredentials(creds);
                }
            }
        }
    }
}

