/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest.topic;

import java.util.ArrayList;
import java.util.List;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.jms.client.ConnectionFactoryOptions;
import org.hornetq.rest.queue.DestinationServiceManager;
import org.hornetq.rest.topic.FileTopicPushStore;
import org.hornetq.rest.topic.TopicDeployment;
import org.hornetq.rest.topic.TopicDestinationsResource;
import org.hornetq.rest.topic.TopicPushStore;
import org.hornetq.rest.topic.TopicResource;

public class TopicServiceManager
extends DestinationServiceManager {
    protected TopicPushStore pushStore;
    protected List<TopicDeployment> topics = new ArrayList<TopicDeployment>();
    protected TopicDestinationsResource destination;

    public TopicServiceManager(ConnectionFactoryOptions jmsOptions) {
        super(jmsOptions);
    }

    public TopicPushStore getPushStore() {
        return this.pushStore;
    }

    public void setPushStore(TopicPushStore pushStore) {
        this.pushStore = pushStore;
    }

    public List<TopicDeployment> getTopics() {
        return this.topics;
    }

    public void setTopics(List<TopicDeployment> topics) {
        this.topics = topics;
    }

    public TopicDestinationsResource getDestination() {
        return this.destination;
    }

    public void setDestination(TopicDestinationsResource destination) {
        this.destination = destination;
    }

    @Override
    public void start() throws Exception {
        this.initDefaults();
        this.started = true;
        if (this.pushStoreFile != null && this.pushStore == null) {
            this.pushStore = new FileTopicPushStore(this.pushStoreFile);
        }
        if (this.destination == null) {
            this.destination = new TopicDestinationsResource(this);
        }
        for (TopicDeployment topic : this.topics) {
            this.deploy(topic);
        }
    }

    public void deploy(TopicDeployment topicDeployment) throws Exception {
        if (!this.started) {
            throw new Exception("You must start() this class instance before deploying");
        }
        String queueName = topicDeployment.getName();
        ClientSession session = this.sessionFactory.createSession(false, false, false);
        ClientSession.QueueQuery query = session.queueQuery(new SimpleString(queueName));
        boolean defaultDurable = topicDeployment.isDurableSend();
        if (query.isExists()) {
            defaultDurable = query.isDurable();
        } else {
            session.createQueue(queueName, queueName, topicDeployment.isDurableSend());
        }
        session.close();
        this.destination.createTopicResource(queueName, defaultDurable, topicDeployment.getConsumerSessionTimeoutSeconds(), topicDeployment.isDuplicatesAllowed());
    }

    @Override
    public void stop() {
        if (!this.started) {
            return;
        }
        for (TopicResource topic : this.destination.getTopics().values()) {
            topic.stop();
        }
        try {
            this.sessionFactory.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

