/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.access;

import hprose.common.HproseException;
import hprose.io.access.Accessors;
import hprose.io.access.MemberAccessor;
import hprose.io.serialize.ValueWriter;
import hprose.io.serialize.Writer;
import hprose.io.unserialize.ByteUnserializer;
import hprose.io.unserialize.Reader;
import java.io.IOException;
import java.lang.reflect.Field;

public final class ByteFieldAccessor
implements MemberAccessor {
    private final long offset;

    public ByteFieldAccessor(Field accessor) {
        accessor.setAccessible(true);
        this.offset = Accessors.unsafe.objectFieldOffset(accessor);
    }

    @Override
    public void serialize(Writer writer, Object obj) throws IOException {
        byte value;
        try {
            value = Accessors.unsafe.getByte(obj, this.offset);
        }
        catch (Exception e) {
            throw new HproseException(e.getMessage());
        }
        ValueWriter.write(writer.stream, value);
    }

    @Override
    public void unserialize(Reader reader, Object obj) throws IOException {
        byte value = ByteUnserializer.instance.read(reader);
        try {
            Accessors.unsafe.putInt(obj, this.offset, value);
        }
        catch (Exception e) {
            throw new HproseException(e.getMessage());
        }
    }
}

