/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.convert.java8;

import hprose.io.convert.Converter;
import hprose.util.DateTime;
import java.lang.reflect.Type;
import java.time.LocalDateTime;

public class LocalDateTimeConverter
implements Converter<LocalDateTime> {
    public static final LocalDateTimeConverter instance = new LocalDateTimeConverter();

    public LocalDateTime convertTo(DateTime dt) {
        return LocalDateTime.of(dt.year, dt.month, dt.day, dt.hour, dt.minute, dt.second, dt.nanosecond);
    }

    public LocalDateTime convertTo(String str) {
        return LocalDateTime.parse(str);
    }

    public LocalDateTime convertTo(char[] chars) {
        return LocalDateTime.parse(new String(chars));
    }

    @Override
    public LocalDateTime convertTo(Object obj, Type type) {
        if (obj instanceof DateTime) {
            return this.convertTo((DateTime)obj);
        }
        if (obj instanceof String) {
            return LocalDateTime.parse((String)obj);
        }
        if (obj instanceof char[]) {
            return LocalDateTime.parse(new String((char[])obj));
        }
        return (LocalDateTime)obj;
    }
}

