/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.serialize.java8;

import hprose.io.serialize.ReferenceSerializer;
import hprose.io.serialize.ValueWriter;
import hprose.io.serialize.Writer;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDate;

public final class LocalDateSerializer
extends ReferenceSerializer<LocalDate> {
    public static final LocalDateSerializer instance = new LocalDateSerializer();

    @Override
    public final void serialize(Writer writer, LocalDate date) throws IOException {
        super.serialize(writer, date);
        OutputStream stream = writer.stream;
        int year = date.getYear();
        if (year > 9999 || year < 1) {
            stream.write(115);
            ValueWriter.write(stream, date.toString());
        } else {
            ValueWriter.writeDate(stream, year, date.getMonthValue(), date.getDayOfMonth());
            stream.write(59);
        }
    }
}

