/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.convert.CalendarConverter;
import hprose.io.unserialize.BaseUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.ReferenceReader;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Calendar;

public final class CalendarUnserializer
extends BaseUnserializer<Calendar> {
    public static final CalendarUnserializer instance = new CalendarUnserializer();

    @Override
    public Calendar unserialize(Reader reader, int tag, Type type) throws IOException {
        CalendarConverter converter = CalendarConverter.instance;
        switch (tag) {
            case 68: {
                return ReferenceReader.readDateTime(reader).toCalendar();
            }
            case 84: {
                return ReferenceReader.readTime(reader).toCalendar();
            }
            case 101: {
                return null;
            }
            case 105: 
            case 108: {
                return converter.convertTo(ValueReader.readLong(reader));
            }
            case 100: {
                return converter.convertTo(ValueReader.readDouble(reader));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return converter.convertTo(Long.valueOf(tag - 48));
        }
        return (Calendar)super.unserialize(reader, tag, type);
    }

    public Calendar read(Reader reader) throws IOException {
        return (Calendar)this.read(reader, (Type)((Object)Calendar.class));
    }
}

