/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.BaseUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.ReferenceReader;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.lang.reflect.Type;

public final class DefaultUnserializer
extends BaseUnserializer {
    public static final DefaultUnserializer instance = new DefaultUnserializer();

    public Object unserialize(Reader reader, int tag, Type type) throws IOException {
        switch (tag) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 101: {
                return "";
            }
            case 116: {
                return true;
            }
            case 102: {
                return false;
            }
            case 78: {
                return Double.NaN;
            }
            case 105: {
                return ValueReader.readInt(reader);
            }
            case 108: {
                return ValueReader.readBigInteger(reader);
            }
            case 100: {
                return ValueReader.readDouble(reader);
            }
            case 73: {
                return ValueReader.readInfinity(reader);
            }
            case 117: {
                return ValueReader.readUTF8Char(reader);
            }
            case 115: {
                return ReferenceReader.readString(reader);
            }
            case 98: {
                return ReferenceReader.readBytes(reader);
            }
            case 68: {
                return ReferenceReader.readDateTime(reader).toCalendar();
            }
            case 84: {
                return ReferenceReader.readTime(reader).toCalendar();
            }
            case 103: {
                return ReferenceReader.readUUID(reader);
            }
            case 97: {
                return ReferenceReader.readArrayList(reader);
            }
            case 109: {
                return ReferenceReader.readHashMap(reader);
            }
            case 111: {
                return ReferenceReader.readObject(reader);
            }
        }
        return super.unserialize(reader, tag, type);
    }

    public Object read(Reader reader) throws IOException {
        return this.read(reader, (Type)((Object)Object.class));
    }
}

