/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.BaseUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.ReferenceReader;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.lang.reflect.Type;

public class ShortObjectUnserializer
extends BaseUnserializer<Short> {
    public static final ShortObjectUnserializer instance = new ShortObjectUnserializer();

    @Override
    public Short unserialize(Reader reader, int tag, Type type) throws IOException {
        if (tag >= 48 && tag <= 57) {
            return (short)(tag - 48);
        }
        if (tag == 105) {
            return (short)ValueReader.readInt(reader, 59);
        }
        switch (tag) {
            case 108: {
                return (short)ValueReader.readLong(reader, 59);
            }
            case 100: {
                return Double.valueOf(ValueReader.readDouble(reader)).shortValue();
            }
            case 101: {
                return (short)0;
            }
            case 116: {
                return (short)1;
            }
            case 102: {
                return (short)0;
            }
            case 117: {
                return Short.parseShort(ValueReader.readUTF8Char(reader));
            }
            case 115: {
                return Short.parseShort(ReferenceReader.readString(reader));
            }
        }
        return (Short)super.unserialize(reader, tag, type);
    }

    public Short read(Reader reader) throws IOException {
        return (Short)this.read(reader, (Type)((Object)Short.class));
    }
}

