/*
 * Decompiled with CFR 0.152.
 */
package hprose.server;

import hprose.common.HproseContext;
import hprose.common.HproseMethods;
import hprose.io.ByteBufferStream;
import hprose.server.HproseService;
import hprose.server.HproseWebSocketMethods;
import hprose.server.ServiceContext;
import hprose.server.WebSocketContext;
import hprose.util.concurrent.Action;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import javax.websocket.EndpointConfig;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;

public class HproseWebSocketService
extends HproseService {
    private static final ThreadLocal<WebSocketContext> currentContext = new ThreadLocal();
    private EndpointConfig config = null;

    public static WebSocketContext getCurrentContext() {
        return currentContext.get();
    }

    @Override
    public HproseMethods getGlobalMethods() {
        if (this.globalMethods == null) {
            this.globalMethods = new HproseWebSocketMethods();
        }
        return this.globalMethods;
    }

    @Override
    public void setGlobalMethods(HproseMethods methods) {
        if (!(methods instanceof HproseWebSocketMethods)) {
            throw new ClassCastException("methods must be a HproseWebSocketMethods instance");
        }
        this.globalMethods = methods;
    }

    @Override
    protected Object[] fixArguments(Type[] argumentTypes, Object[] arguments, ServiceContext context) {
        int count = arguments.length;
        WebSocketContext wsContext = (WebSocketContext)context;
        if (argumentTypes.length != count) {
            Object[] args = new Object[argumentTypes.length];
            System.arraycopy(arguments, 0, args, 0, count);
            Class argType = (Class)argumentTypes[count];
            if (argType.equals(HproseContext.class) || argType.equals(ServiceContext.class)) {
                args[count] = context;
            } else if (argType.equals(WebSocketContext.class)) {
                args[count] = wsContext;
            } else if (argType.equals(EndpointConfig.class)) {
                args[count] = wsContext.getConfig();
            } else if (argType.equals(Session.class)) {
                args[count] = wsContext.getSession();
            }
            return args;
        }
        return arguments;
    }

    public void setConfig(EndpointConfig config) {
        this.config = config;
    }

    public void handle(final ByteBuffer buf, final Session session) throws IOException {
        WebSocketContext context = new WebSocketContext(this, session, this.config);
        final int id = buf.getInt();
        currentContext.set(context);
        this.handle(buf.slice(), context).then(new Action<ByteBuffer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void call(ByteBuffer value) throws Throwable {
                try {
                    ByteBuffer buffer = ByteBuffer.allocate(4 + value.remaining());
                    buffer.putInt(id);
                    buffer.put(value);
                    buffer.flip();
                    RemoteEndpoint.Async remote = session.getAsyncRemote();
                    remote.sendBinary(buffer);
                }
                finally {
                    ByteBufferStream.free(value);
                }
            }
        }).whenComplete(new Runnable(){

            @Override
            public void run() {
                currentContext.remove();
                ByteBufferStream.free(buf);
            }
        });
    }

    public void handleError(Session session, Throwable error) {
        WebSocketContext context = new WebSocketContext(this, session, this.config);
        this.fireErrorEvent(error, context);
    }
}

