/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.csp.value;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import org.htmlunit.csp.Constants;

public final class RFC7230Token {
    private final String value_;

    private RFC7230Token(String value) {
        this.value_ = value;
    }

    public String getValue() {
        return this.value_;
    }

    public static Optional<RFC7230Token> parseRFC7230Token(String value) {
        Matcher matcher = Constants.rfc7230TokenPattern.matcher(value);
        if (matcher.find()) {
            return Optional.of(new RFC7230Token(value));
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RFC7230Token)) {
            return false;
        }
        RFC7230Token that = (RFC7230Token)o;
        return this.value_.equals(that.value_);
    }

    public int hashCode() {
        return Objects.hash(this.value_);
    }

    public String toString() {
        return this.value_;
    }
}

