/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware;

import java.io.Serializable;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import javax.xml.bind.DatatypeConverter;
import org.http4s.AttributeMap;
import org.http4s.ContentCoding$;
import org.http4s.Fallthrough$;
import org.http4s.Header;
import org.http4s.HeaderKey;
import org.http4s.Headers;
import org.http4s.HttpVersion;
import org.http4s.MediaType$;
import org.http4s.MessageOps;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Service$;
import org.http4s.Status;
import org.http4s.headers.Accept;
import org.http4s.headers.Accept$minusEncoding$;
import org.http4s.headers.Content;
import org.http4s.headers.Content$minusEncoding$;
import org.http4s.headers.Content$minusLength$;
import org.http4s.headers.Content$minusType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.math.Integral;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scalaz.Functor;
import scalaz.Kleisli;
import scalaz.Kleisli$;
import scalaz.concurrent.Task;
import scalaz.concurrent.Task$;
import scalaz.stream.Process;
import scalaz.stream.Process$;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class GZip$ {
    public static GZip$ MODULE$;
    private final Logger logger;
    private final int GZIP_MAGIC_NUMBER;
    private final long GZIP_LENGTH_MOD;
    private final ByteVector header;

    static {
        new GZip$();
    }

    public Kleisli<Task, Request, Response> apply(Kleisli<Task, Request, Response> service, int bufferSize, int level) {
        return Service$.MODULE$.lift((Function1 & Serializable & scala.Serializable)req -> {
            Some some;
            Accept.minusEncoding acceptEncoding;
            Option option = req.headers().get((HeaderKey.Extractable)Accept$minusEncoding$.MODULE$);
            Task task = option instanceof Some && ((acceptEncoding = (Accept.minusEncoding)(some = (Some)option).value()).satisfiedBy(ContentCoding$.MODULE$.gzip()) || acceptEncoding.satisfiedBy(ContentCoding$.MODULE$.x$minusgzip())) ? (Task)Kleisli$.MODULE$.kleisliFn(service.map((Function1 & Serializable & scala.Serializable)resp -> {
                Response response;
                if (this.isZippable((Response)resp)) {
                    $this.logger.trace("GZip middleware encoding content");
                    Process b = resp.body().pipe(this.gzip(level, true, bufferSize));
                    Response qual$1 = (Response)((MessageOps)resp.removeHeader((HeaderKey)Content$minusLength$.MODULE$)).putHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{new Content.minusEncoding(ContentCoding$.MODULE$.gzip())}));
                    Process x$1 = b;
                    Status x$2 = qual$1.copy$default$1();
                    HttpVersion x$3 = qual$1.copy$default$2();
                    Headers x$4 = qual$1.copy$default$3();
                    AttributeMap x$5 = qual$1.copy$default$5();
                    response = qual$1.copy(x$2, x$3, x$4, x$1, x$5);
                } else {
                    response = resp;
                }
                return response;
            }, (Functor)Task$.MODULE$.taskInstance())).apply(req) : (Task)Kleisli$.MODULE$.kleisliFn(service).apply(req);
            return task;
        });
    }

    public int apply$default$2() {
        return 32768;
    }

    public int apply$default$3() {
        return -1;
    }

    public Process<Process.Env.Is, ByteVector> gzip(int level, boolean nowrap, int bufferSize) {
        return Process$.MODULE$.suspend((Function0 & Serializable & scala.Serializable)() -> {
            CRC32 crc = new CRC32();
            LongRef length = LongRef.create((long)0L);
            Deflater deflater = new Deflater(level, nowrap);
            byte[] buf = (byte[])Array$.MODULE$.ofDim(bufferSize, ClassTag$.MODULE$.Byte());
            return Process$.MODULE$.emit((Object)this.header()).$plus$plus((Function0 & Serializable & scala.Serializable)() -> this.go$1(crc, length, deflater, buf).onComplete((Function0 & Serializable & scala.Serializable)() -> this.flush$1(crc, length, deflater, buf)));
        });
    }

    public int gzip$default$1() {
        return -1;
    }

    public boolean gzip$default$2() {
        return false;
    }

    public int gzip$default$3() {
        return 32768;
    }

    private boolean isZippable(Response resp) {
        Option contentType = resp.headers().get((HeaderKey.Extractable)Content$minusType$.MODULE$);
        return !Fallthrough$.MODULE$.apply(Response$.MODULE$.instance()).isFallthrough((Object)resp) && resp.headers().get((HeaderKey.Extractable)Content$minusEncoding$.MODULE$).isEmpty() && (contentType.isEmpty() || ((Content.minusType)contentType.get()).mediaType().compressible() || ((Content.minusType)contentType.get()).mediaType() == MediaType$.MODULE$.application$divoctet$minusstream());
    }

    private int GZIP_MAGIC_NUMBER() {
        return this.GZIP_MAGIC_NUMBER;
    }

    private long GZIP_LENGTH_MOD() {
        return this.GZIP_LENGTH_MOD;
    }

    private ByteVector header() {
        return this.header;
    }

    private final Vector collect$1(int flush, Vector acc, Deflater deflater$1, byte[] buf$1) {
        block3: while (true) {
            int n = deflater$1.deflate(buf$1, 0, buf$1.length, flush);
            switch (n) {
                case 0: {
                    break block3;
                }
                default: {
                    acc = (Vector)acc.$colon$plus((Object)ByteVector$.MODULE$.view((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(buf$1)).take(n)), Vector$.MODULE$.canBuildFrom());
                    continue block3;
                }
            }
            break;
        }
        return acc;
    }

    private static final Vector collect$default$2$1() {
        return package$.MODULE$.Vector().empty();
    }

    private final Process go$1(CRC32 crc$1, LongRef length$1, Deflater deflater$1, byte[] buf$1) {
        return Process$.MODULE$.receive1((Function1 & Serializable & scala.Serializable)bytes -> {
            byte[] arr = bytes.toArray();
            crc$1.update(arr);
            length$1.elem += bytes.length();
            deflater$1.setInput(arr);
            Vector chunks = this.collect$1(0, GZip$.collect$default$2$1(), deflater$1, buf$1);
            return Process$.MODULE$.emitAll((Seq)chunks).$plus$plus((Function0 & Serializable & scala.Serializable)() -> this.go$1(crc$1, length$1, deflater$1, buf$1));
        });
    }

    private final Process flush$1(CRC32 crc$1, LongRef length$1, Deflater deflater$1, byte[] buf$1) {
        deflater$1.finish();
        Vector vecs = this.collect$1(3, GZip$.collect$default$2$1(), deflater$1, buf$1);
        deflater$1.end();
        return Process$.MODULE$.emitAll((Seq)vecs).$plus$plus((Function0 & Serializable & scala.Serializable)() -> Process$.MODULE$.emit((Object)this.trailer$1(crc$1, length$1)));
    }

    private final ByteVector trailer$1(CRC32 crc$1, LongRef length$1) {
        return ByteVector$.MODULE$.view((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(DatatypeConverter.parseHexBinary((String)new StringOps(Predef$.MODULE$.augmentString("%08x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)crc$1.getValue())}))))).reverse()).$plus$plus(ByteVector$.MODULE$.view((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(DatatypeConverter.parseHexBinary((String)new StringOps(Predef$.MODULE$.augmentString("%08x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(length$1.elem % this.GZIP_LENGTH_MOD()))}))))).reverse()));
    }

    private GZip$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.server.middleware.GZip");
        this.GZIP_MAGIC_NUMBER = 35615;
        this.GZIP_LENGTH_MOD = (long)Math.pow(2.0, 32.0);
        this.header = ByteVector$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)this.GZIP_MAGIC_NUMBER(), (byte)(this.GZIP_MAGIC_NUMBER() >> 8), (byte)8, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0}), (Integral)Numeric.ByteIsIntegral$.MODULE$);
    }
}

