/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware.authentication;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import org.http4s.AuthScheme$;
import org.http4s.AuthedRequest;
import org.http4s.Challenge;
import org.http4s.Credentials;
import org.http4s.GenericCredentials;
import org.http4s.HeaderKey;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Service$;
import org.http4s.headers.Authorization;
import org.http4s.headers.Authorization$;
import org.http4s.server.middleware.authentication.DigestAuth;
import org.http4s.server.middleware.authentication.DigestAuth$BadNC$;
import org.http4s.server.middleware.authentication.DigestAuth$BadParameters$;
import org.http4s.server.middleware.authentication.DigestAuth$NoAuthorizationHeader$;
import org.http4s.server.middleware.authentication.DigestAuth$NoCredentials$;
import org.http4s.server.middleware.authentication.DigestAuth$StaleNonce$;
import org.http4s.server.middleware.authentication.DigestAuth$UserUnknown$;
import org.http4s.server.middleware.authentication.DigestAuth$WrongResponse$;
import org.http4s.server.middleware.authentication.DigestUtil$;
import org.http4s.server.middleware.authentication.NonceKeeper;
import org.http4s.server.middleware.authentication.NonceKeeper$BadNCReply$;
import org.http4s.server.middleware.authentication.NonceKeeper$OKReply$;
import org.http4s.server.middleware.authentication.NonceKeeper$StaleReply$;
import org.http4s.server.middleware.authentication.package$;
import org.http4s.util.CaseInsensitiveString;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenSetLike;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.runtime.Nothing$;
import scalaz.;
import scalaz.Kleisli;
import scalaz.concurrent.Task;
import scalaz.concurrent.Task$;

public final class DigestAuth$ {
    public static DigestAuth$ MODULE$;

    static {
        new DigestAuth$();
    }

    public <A> Function1<Kleisli<Task, AuthedRequest<A>, Response>, Kleisli<Task, Request, Response>> apply(String realm, Function1<String, Task<Option<Tuple2<A, String>>>> store, Duration nonceCleanupInterval, Duration nonceStaleTime, int nonceBits) {
        NonceKeeper nonceKeeper = new NonceKeeper(nonceStaleTime.toMillis(), nonceCleanupInterval.toMillis(), nonceBits);
        Kleisli kleisli = Service$.MODULE$.lift((Function1 & Serializable & scala.Serializable)req -> this.getChallenge(realm, store, nonceKeeper, (Request)req));
        return (Function1 & Serializable & scala.Serializable)service -> package$.MODULE$.challenged(kleisli, service);
    }

    public <A> Duration apply$default$3() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public <A> Duration apply$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public <A> int apply$default$5() {
        return 160;
    }

    private <A> Task<.bslash.div<Challenge, AuthedRequest<A>>> getChallenge(String realm, Function1<String, Task<Option<Tuple2<A, String>>>> store, NonceKeeper nonceKeeper, Request req) {
        return this.checkAuth(realm, store, nonceKeeper, req).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> {
            Task task;
            DigestAuth.AuthReply authReply = x$1;
            if (authReply instanceof DigestAuth.OK) {
                DigestAuth.OK oK = (DigestAuth.OK)authReply;
                Object authInfo = oK.authInfo();
                task = Task$.MODULE$.now((Object)new .bslash.div.minus((Object)new AuthedRequest(authInfo, req)));
            } else {
                task = DigestAuth$StaleNonce$.MODULE$.equals(authReply) ? this.getChallengeParams(nonceKeeper, true).map((Function1 & Serializable & scala.Serializable)params -> DigestAuth$.paramsToChallenge$1(params, realm)) : this.getChallengeParams(nonceKeeper, false).map((Function1 & Serializable & scala.Serializable)params -> DigestAuth$.paramsToChallenge$1(params, realm));
            }
            return task;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <A> Task<DigestAuth.AuthReply<A>> checkAuth(String realm, Function1<String, Task<Option<Tuple2<A, String>>>> store, NonceKeeper nonceKeeper, Request req) {
        Authorization authorization;
        Option option;
        boolean bl = false;
        Some some = null;
        Option option2 = req.headers().get((HeaderKey.Extractable)Authorization$.MODULE$);
        if (option2 instanceof Some) {
            Credentials credentials;
            bl = true;
            some = (Some)option2;
            Authorization authorization2 = (Authorization)some.value();
            Option option3 = Authorization$.MODULE$.unapply(authorization2);
            if (!option3.isEmpty() && (credentials = (Credentials)option3.get()) instanceof GenericCredentials) {
                GenericCredentials genericCredentials = (GenericCredentials)credentials;
                CaseInsensitiveString caseInsensitiveString = genericCredentials.authScheme();
                Map params = genericCredentials.params();
                CaseInsensitiveString caseInsensitiveString2 = AuthScheme$.MODULE$.Digest();
                CaseInsensitiveString caseInsensitiveString3 = caseInsensitiveString;
                if (caseInsensitiveString2 == null) {
                    if (caseInsensitiveString3 == null) return this.checkAuthParams(realm, store, nonceKeeper, req, (Map<String, String>)params);
                } else if (caseInsensitiveString2.equals(caseInsensitiveString3)) {
                    return this.checkAuthParams(realm, store, nonceKeeper, req, (Map<String, String>)params);
                }
            }
        }
        if (bl && !(option = Authorization$.MODULE$.unapply(authorization = (Authorization)some.value())).isEmpty()) {
            return Task$.MODULE$.now((Object)DigestAuth$NoCredentials$.MODULE$);
        }
        if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
        return Task$.MODULE$.now((Object)DigestAuth$NoAuthorizationHeader$.MODULE$);
    }

    private Task<Map<String, String>> getChallengeParams(NonceKeeper nonceKeeper, boolean staleNonce) {
        Function0 & Serializable & scala.Serializable x$2 = (Function0 & Serializable & scala.Serializable)() -> {
            void var3_3;
            String nonce = nonceKeeper.newNonce();
            Map m = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"qop"), (Object)"auth"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nonce"), (Object)nonce)}));
            return staleNonce ? m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stale"), (Object)"TRUE")) : var3_3;
        };
        ExecutorService x$3 = Task$.MODULE$.apply$default$2((Function0)x$2);
        return Task$.MODULE$.apply((Function0)x$2, x$3);
    }

    private <A> Task<DigestAuth.AuthReply<A>> checkAuthParams(String realm, Function1<String, Task<Option<Tuple2<A, String>>>> store, NonceKeeper nonceKeeper, Request req, Map<String, String> params) {
        Task task;
        String nc;
        if (!((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"realm", "nonce", "nc", "username", "cnonce", "qop"}))).subsetOf((GenSet)params.keySet())) {
            return Task$.MODULE$.now((Object)DigestAuth$BadParameters$.MODULE$);
        }
        String method = req.method().toString();
        String uri = req.uri().toString();
        Option option = params.get((Object)"realm");
        Some some = new Some((Object)realm);
        if (option == null ? some != null : !option.equals(some)) {
            return Task$.MODULE$.now((Object)DigestAuth$BadParameters$.MODULE$);
        }
        String nonce = (String)params.apply((Object)"nonce");
        NonceKeeper.Reply reply = nonceKeeper.receiveNonce(nonce, Integer.parseInt(nc = (String)params.apply((Object)"nc"), 16));
        if (NonceKeeper$StaleReply$.MODULE$.equals(reply)) {
            task = Task$.MODULE$.now((Object)DigestAuth$StaleNonce$.MODULE$);
        } else if (NonceKeeper$BadNCReply$.MODULE$.equals(reply)) {
            task = Task$.MODULE$.now((Object)DigestAuth$BadNC$.MODULE$);
        } else if (NonceKeeper$OKReply$.MODULE$.equals(reply)) {
            task = ((Task)store.apply(params.apply((Object)"username"))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Some some;
                Tuple2 tuple2;
                DigestAuth.AuthReply<Nothing$> authReply;
                Option option = x0$1;
                if (None$.MODULE$.equals(option)) {
                    authReply = DigestAuth$UserUnknown$.MODULE$;
                } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                    String resp;
                    Object authInfo = tuple2._1();
                    String password = (String)tuple2._2();
                    String string = resp = DigestUtil$.MODULE$.computeResponse(method, (String)params.apply((Object)"username"), realm, password, uri, nonce, nc, (String)params.apply((Object)"cnonce"), (String)params.apply((Object)"qop"));
                    Object object = params.apply((Object)"response");
                    authReply = !(string != null ? !string.equals(object) : object != null) ? new DigestAuth.OK<Object>(authInfo) : DigestAuth$WrongResponse$.MODULE$;
                } else {
                    throw new MatchError((Object)option);
                }
                return authReply;
            });
        } else {
            throw new MatchError((Object)reply);
        }
        return task;
    }

    private static final .minus.bslash.div paramsToChallenge$1(Map params, String realm$2) {
        return new .minus.bslash.div((Object)new Challenge("Digest", realm$2, params));
    }

    private DigestAuth$() {
        MODULE$ = this;
    }
}

