/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.time.Clock;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.http4s.Cookie;
import org.http4s.Request;
import org.http4s.headers.Cookie$;
import org.http4s.server.middleware.CSRF;
import org.http4s.util.package$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scalaz.OptionT;
import scalaz.concurrent.Task;
import scalaz.concurrent.Task$;

public final class CSRF$ {
    public static CSRF$ MODULE$;
    private final SecureRandom CachedRandom;
    private final String SigningAlgo;
    private final int SHA1ByteLen;
    private final int CSRFTokenLength;

    static {
        new CSRF$();
    }

    public String $lessinit$greater$default$1() {
        return "X-Csrf-Token";
    }

    public String $lessinit$greater$default$2() {
        return "csrf-token";
    }

    public Clock $lessinit$greater$default$4() {
        return Clock.systemUTC();
    }

    public CSRF apply(String headerName, String cookieName, SecretKey key, Clock clock) {
        return new CSRF(headerName, cookieName, key, clock);
    }

    public String apply$default$1() {
        return "X-Csrf-Token";
    }

    public String apply$default$2() {
        return "csrf-token";
    }

    public Clock apply$default$4() {
        return Clock.systemUTC();
    }

    public Task<CSRF> withGeneratedKey(String headerName, String cookieName, Clock clock) {
        return this.generateSigningKey().map((Function1 & Serializable & scala.Serializable)x$8 -> MODULE$.apply(headerName, cookieName, (SecretKey)x$8, clock));
    }

    public String withGeneratedKey$default$1() {
        return "X-Csrf-Token";
    }

    public String withGeneratedKey$default$2() {
        return "csrf-token";
    }

    public Clock withGeneratedKey$default$3() {
        return Clock.systemUTC();
    }

    public Task<CSRF> withKeyBytes(byte[] keyBytes, String headerName, String cookieName, Clock clock) {
        return this.buildSigningKey(keyBytes).map((Function1 & Serializable & scala.Serializable)x$9 -> MODULE$.apply(headerName, cookieName, (SecretKey)x$9, clock));
    }

    public String withKeyBytes$default$2() {
        return "X-Csrf-Token";
    }

    public String withKeyBytes$default$3() {
        return "csrf-token";
    }

    public Clock withKeyBytes$default$4() {
        return Clock.systemUTC();
    }

    private SecureRandom CachedRandom() {
        return this.CachedRandom;
    }

    public String SigningAlgo() {
        return this.SigningAlgo;
    }

    public int SHA1ByteLen() {
        return this.SHA1ByteLen;
    }

    public int CSRFTokenLength() {
        return this.CSRFTokenLength;
    }

    public OptionT<Task, Cookie> liftedCookieFromHeader(Request request, String cookieName) {
        return new OptionT((Object)Task$.MODULE$.now((Object)Cookie$.MODULE$.from(request.headers()).flatMap((Function1 & Serializable & scala.Serializable)x$10 -> x$10.values().find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)CSRF$.$anonfun$liftedCookieFromHeader$2(cookieName, x$11))))));
    }

    public Option<Cookie> cookieFromHeader(Request request, String cookieName) {
        return Cookie$.MODULE$.from(request.headers()).flatMap((Function1 & Serializable & scala.Serializable)x$12 -> x$12.values().find((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)CSRF$.$anonfun$cookieFromHeader$2(cookieName, x$13))));
    }

    public boolean isEqual(String s1, String s2) {
        return MessageDigest.isEqual(s1.getBytes(StandardCharsets.UTF_8), s2.getBytes(StandardCharsets.UTF_8));
    }

    public String genTokenString() {
        byte[] bytes = new byte[this.CSRFTokenLength()];
        this.CachedRandom().nextBytes(bytes);
        return new String(package$.MODULE$.encodeHex(bytes));
    }

    public Task<SecretKey> generateSigningKey() {
        return Task$.MODULE$.delay((Function0 & Serializable & scala.Serializable)() -> KeyGenerator.getInstance(MODULE$.SigningAlgo()).generateKey());
    }

    public Task<SecretKey> buildSigningKey(byte[] array) {
        return Task$.MODULE$.delay((Function0 & Serializable & scala.Serializable)() -> new SecretKeySpec((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(array)).slice(0, MODULE$.SHA1ByteLen()), MODULE$.SigningAlgo()));
    }

    public static final /* synthetic */ boolean $anonfun$liftedCookieFromHeader$2(String cookieName$2, Cookie x$11) {
        String string = x$11.name();
        String string2 = cookieName$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$cookieFromHeader$2(String cookieName$1, Cookie x$13) {
        String string = x$13.name();
        String string2 = cookieName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * WARNING - void declaration
     */
    private CSRF$() {
        void var1_1;
        MODULE$ = this;
        SecureRandom r = new SecureRandom();
        r.nextBytes(new byte[20]);
        this.CachedRandom = var1_1;
        this.SigningAlgo = "HmacSHA1";
        this.SHA1ByteLen = 20;
        this.CSRFTokenLength = 32;
    }
}

