/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.staticcontent;

import cats.Applicative;
import cats.FlatMap;
import cats.Functor;
import cats.Monad;
import cats.data.Kleisli;
import cats.data.NonEmptyList;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.implicits$;
import fs2.Stream;
import fs2.Task;
import fs2.Task$;
import java.io.File;
import java.io.Serializable;
import org.http4s.AttributeMap;
import org.http4s.Header;
import org.http4s.HeaderKey;
import org.http4s.Headers;
import org.http4s.HttpVersion;
import org.http4s.MaybeResponse;
import org.http4s.Pass$;
import org.http4s.RangeUnit;
import org.http4s.RangeUnit$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Service$;
import org.http4s.StaticFile$;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.headers.Content$minusRange$;
import org.http4s.headers.Range;
import org.http4s.headers.Range$;
import org.http4s.server.staticcontent.FileService;
import org.http4s.server.staticcontent.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class FileService$ {
    public static FileService$ MODULE$;

    static {
        new FileService$();
    }

    public Kleisli<Task, Request, MaybeResponse> apply(FileService.Config config) {
        return Service$.MODULE$.lift((Function1 & Serializable & scala.Serializable)req -> {
            String uriPath = req.pathInfo();
            return !uriPath.startsWith(config.pathPrefix()) ? Pass$.MODULE$.now() : (Task)implicits$.MODULE$.catsSyntaxFlatten(MODULE$.getFile(config.systemPath() + '/' + package$.MODULE$.getSubPath(uriPath, config.pathPrefix())).flatMap((Function1 & Serializable & scala.Serializable)f -> (OptionT)config.pathCollector().apply(f, (Object)config, req), (Monad)fs2.interop.cats.package$.MODULE$.effectToMonadError(Task$.MODULE$.effectInstance())).orElse((Function0 & Serializable & scala.Serializable)() -> OptionT$.MODULE$.none((Applicative)fs2.interop.cats.package$.MODULE$.effectToMonadError(Task$.MODULE$.effectInstance())), (Monad)fs2.interop.cats.package$.MODULE$.effectToMonadError(Task$.MODULE$.effectInstance())).fold((Function0 & Serializable & scala.Serializable)() -> Pass$.MODULE$.now(), (Function1 & Serializable & scala.Serializable)x$1 -> config.cacheStrategy().cache(uriPath, (Response)x$1), (Functor)fs2.interop.cats.package$.MODULE$.effectToMonadError(Task$.MODULE$.effectInstance())), (FlatMap)fs2.interop.cats.package$.MODULE$.effectToMonadError(Task$.MODULE$.effectInstance())).flatten();
        });
    }

    public OptionT<Task, Response> org$http4s$server$staticcontent$FileService$$filesOnly(File file, FileService.Config config, Request req) {
        return new OptionT(implicits$.MODULE$.catsSyntaxFlatten((Object)Task$.MODULE$.delay((Function0 & Serializable & scala.Serializable)() -> file.isDirectory() ? (Task)StaticFile$.MODULE$.fromFile(new File(file, "index.html"), (Option)new Some((Object)req)).value() : (!file.isFile() ? Task$.MODULE$.now((Object)None$.MODULE$) : (Task)MODULE$.getPartialContentFile(file, config, req).orElse((Function0 & Serializable & scala.Serializable)() -> StaticFile$.MODULE$.fromFile(file, config.bufferSize(), (Option)new Some((Object)req)).map((Function1 & Serializable & scala.Serializable)x$2 -> (Response)x$2.putHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{package$.MODULE$.AcceptRangeHeader()})), (Functor)fs2.interop.cats.package$.MODULE$.effectToMonadError(Task$.MODULE$.effectInstance())), (Monad)fs2.interop.cats.package$.MODULE$.effectToMonadError(Task$.MODULE$.effectInstance())).value())), (FlatMap)fs2.interop.cats.package$.MODULE$.effectToMonadError(Task$.MODULE$.effectInstance())).flatten());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validRange(long start, Option<Object> end, long fileLength) {
        if (start >= fileLength) return false;
        Option<Object> option = end;
        if (option instanceof Some) {
            Some some = (Some)option;
            long end2 = BoxesRunTime.unboxToLong((Object)some.value());
            if (start < 0L) return false;
            if (start > end2) return false;
            return true;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        if (start >= 0L) return true;
        if (fileLength + start - 1L < 0L) return false;
        return true;
    }

    private OptionT<Task, Response> getPartialContentFile(File file, FileService.Config config, Request req) {
        return OptionT$.MODULE$.fromOption().apply(req.headers().get((HeaderKey.Extractable)Range$.MODULE$), (Applicative)fs2.interop.cats.package$.MODULE$.effectToMonadError(Task$.MODULE$.effectInstance())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Range range = x0$1;
            Option option = Range$.MODULE$.unapply(range);
            if (option.isEmpty()) return OptionT$.MODULE$.none((Applicative)fs2.interop.cats.package$.MODULE$.effectToMonadError(Task$.MODULE$.effectInstance()));
            RangeUnit rangeUnit = (RangeUnit)((Tuple2)option.get())._1();
            NonEmptyList nonEmptyList = (NonEmptyList)((Tuple2)option.get())._2();
            RangeUnit rangeUnit2 = RangeUnit$.MODULE$.Bytes();
            RangeUnit rangeUnit3 = rangeUnit;
            if (rangeUnit2 == null) {
                if (rangeUnit3 != null) {
                    return OptionT$.MODULE$.none((Applicative)fs2.interop.cats.package$.MODULE$.effectToMonadError(Task$.MODULE$.effectInstance()));
                }
            } else if (!rangeUnit2.equals(rangeUnit3)) return OptionT$.MODULE$.none((Applicative)fs2.interop.cats.package$.MODULE$.effectToMonadError(Task$.MODULE$.effectInstance()));
            if (nonEmptyList == null) return OptionT$.MODULE$.none((Applicative)fs2.interop.cats.package$.MODULE$.effectToMonadError(Task$.MODULE$.effectInstance()));
            Range.SubRange subRange = (Range.SubRange)nonEmptyList.head();
            List list = nonEmptyList.tail();
            if (subRange == null) return OptionT$.MODULE$.none((Applicative)fs2.interop.cats.package$.MODULE$.effectToMonadError(Task$.MODULE$.effectInstance()));
            long s = subRange.first();
            Option e = subRange.second();
            if (!Nil$.MODULE$.equals(list)) return OptionT$.MODULE$.none((Applicative)fs2.interop.cats.package$.MODULE$.effectToMonadError(Task$.MODULE$.effectInstance()));
            if (!MODULE$.validRange(s, (Option<Object>)e, file.length())) return OptionT$.MODULE$.none((Applicative)fs2.interop.cats.package$.MODULE$.effectToMonadError(Task$.MODULE$.effectInstance()));
            return new OptionT(implicits$.MODULE$.catsSyntaxFlatten((Object)Task$.MODULE$.delay((Function0 & Serializable & scala.Serializable)() -> {
                long size = file.length();
                long start = s >= 0L ? s : scala.math.package$.MODULE$.max(0L, size + s);
                long end = scala.math.package$.MODULE$.min(size - 1L, BoxesRunTime.unboxToLong((Object)e.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> size - 1L)));
                return (Task)StaticFile$.MODULE$.fromFile(file, start, end + 1L, config.bufferSize(), (Option)new Some((Object)req)).map((Function1 & Serializable & scala.Serializable)resp -> {
                    Headers hs = resp.headers().put((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{package$.MODULE$.AcceptRangeHeader(), Content$minusRange$.MODULE$.apply(Range.SubRange$.MODULE$.apply(start, end), (Option)new Some((Object)BoxesRunTime.boxToLong((long)size)))}));
                    Status x$3 = Status$.MODULE$.PartialContent();
                    Headers x$4 = hs;
                    HttpVersion x$5 = resp.copy$default$2();
                    Stream x$6 = resp.copy$default$4();
                    AttributeMap x$7 = resp.copy$default$5();
                    return resp.copy(x$3, x$5, x$4, x$6, x$7);
                }, (Functor)fs2.interop.cats.package$.MODULE$.effectToMonadError(Task$.MODULE$.effectInstance())).value();
            }), (FlatMap)fs2.interop.cats.package$.MODULE$.effectToMonadError(Task$.MODULE$.effectInstance())).flatten());
        }, (Monad)fs2.interop.cats.package$.MODULE$.effectToMonadError(Task$.MODULE$.effectInstance()));
    }

    private OptionT<Task, File> getFile(String unsafePath) {
        return new OptionT((Object)Task$.MODULE$.delay((Function0 & Serializable & scala.Serializable)() -> {
            File f = new File((String)package$.MODULE$.sanitize().apply((Object)unsafePath));
            return f.exists() ? new Some((Object)f) : None$.MODULE$;
        }));
    }

    private FileService$() {
        MODULE$ = this;
    }
}

