/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server;

import cats.effect.Effect;
import cats.effect.IO$;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.CountDownLatch;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001q4Q!\u0001\u0002\u0002\u0002%\u0011aaU3sm\u0016\u0014(BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\u0011QAB\u0001\u0007QR$\b\u000fN:\u000b\u0003\u001d\t1a\u001c:h\u0007\u0001)\"AC\u000f\u0014\u0005\u0001Y\u0001C\u0001\u0007\u0010\u001b\u0005i!\"\u0001\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ai!AB!osJ+g\r\u0003\u0005\u0013\u0001\t\u0005\t\u0015a\u0003\u0014\u0003\u00051\u0005c\u0001\u000b\u001a75\tQC\u0003\u0002\u0017/\u00051QM\u001a4fGRT\u0011\u0001G\u0001\u0005G\u0006$8/\u0003\u0002\u001b+\t1QI\u001a4fGR\u0004\"\u0001H\u000f\r\u0001\u0011)a\u0004\u0001b\u0001?\t\ta)\u0006\u0002!OE\u0011\u0011\u0005\n\t\u0003\u0019\tJ!aI\u0007\u0003\u000f9{G\u000f[5oOB\u0011A\"J\u0005\u0003M5\u00111!\u00118z\t\u0015ASD1\u0001!\u0005\u0005y\u0006\"\u0002\u0016\u0001\t\u0003Y\u0013A\u0002\u001fj]&$h\bF\u0001-)\tis\u0006E\u0002/\u0001mi\u0011A\u0001\u0005\u0006%%\u0002\u001da\u0005\u0005\u0007c\u0001\u0001\u000b\u0011\u0002\u001a\u0002\r1|wmZ3s!\t\u0019d'D\u00015\u0015\t)d!A\u0003m_\u001e$4/\u0003\u00028i\t1Aj\\4hKJDQ!\u000f\u0001\u0007\u0002i\n\u0001b\u001d5vi\u0012|wO\\\u000b\u0002wA\u0019A$\b\u001f\u0011\u00051i\u0014B\u0001 \u000e\u0005\u0011)f.\u001b;\t\u000b\u0001\u0003A\u0011A!\u0002\u0017MDW\u000f\u001e3po:tun\u001e\u000b\u0002y!)1\t\u0001D\u0001\t\u0006QqN\\*ikR$wn\u001e8\u0015\u0005\u00153U\"\u0001\u0001\t\r\u001d\u0013E\u00111\u0001I\u0003\u00051\u0007c\u0001\u0007Jy%\u0011!*\u0004\u0002\ty\tLh.Y7f}!\"!\tT(R!\taQ*\u0003\u0002O\u001b\tQA-\u001a9sK\u000e\fG/\u001a3\"\u0003A\u000bqeQ8na>\u001cX\rI<ji\"\u0004C\u000f[3!g\",H\u000fZ8x]\u0002\"\u0018m]6!S:\u001cH/Z1e]\u0005\n!+\u0001\u00031]E\"\u0004\"\u0002+\u0001\r\u0003)\u0016aB1eIJ,7o]\u000b\u0002-B\u0011q\u000bX\u0007\u00021*\u0011\u0011LW\u0001\u0004]\u0016$(\"A.\u0002\t)\fg/Y\u0005\u0003;b\u0013\u0011#\u00138fiN{7m[3u\u0003\u0012$'/Z:t\u0011\u0015y\u0006A\"\u0001a\u0003!I7oU3dkJ,W#A1\u0011\u00051\u0011\u0017BA2\u000e\u0005\u001d\u0011un\u001c7fC:DQ!\u001a\u0001\u0005\u0002\u0019\fqAY1tKV\u0013\u0018.F\u0001h!\tA\u0017.D\u0001\u0005\u0013\tQGAA\u0002Ve&DQ\u0001\u001c\u0001\u0005\u0002\u0005\u000bQ\"Y<bSR\u001c\u0006.\u001e;e_^t\u0007\u0006B6M]F\u000b\u0013a\\\u0001\u0017+N,\u0007eU3sm\u0016\u0014\u0018\t\u001d9!S:\u001cH/Z1e]\u001d1\u0011O\u0001E\u0001\tI\faaU3sm\u0016\u0014\bC\u0001\u0018t\r\u0019\t!\u0001#\u0001\u0005iN\u00111o\u0003\u0005\u0006UM$\tA\u001e\u000b\u0002e\"1\u0011g\u001dQ\u0001\nIBQ!Z:\u0005\u0002e$2a\u001a>|\u0011\u0015!\u0006\u00101\u0001W\u0011\u0015y\u0006\u00101\u0001b\u0001")
public abstract class Server<F> {
    private final Effect<F> F;
    private final Logger logger;

    public abstract F shutdown();

    public void shutdownNow() {
        this.F.runAsync(this.shutdown(), (Function1 & Serializable & scala.Serializable)x$1 -> IO$.MODULE$.unit()).unsafeRunSync();
    }

    public abstract Server<F> onShutdown(Function0<BoxedUnit> var1);

    public abstract InetSocketAddress address();

    public abstract boolean isSecure();

    public Uri baseUri() {
        Uri.IPv4 iPv4;
        Some some = new Some((Object)(this.isSecure() ? Uri.Scheme$.MODULE$.https() : Uri.Scheme$.MODULE$.http()));
        InetAddress inetAddress = this.address().getAddress();
        if (inetAddress instanceof Inet4Address) {
            Inet4Address inet4Address = (Inet4Address)inetAddress;
            iPv4 = Uri.IPv4$.MODULE$.apply(inet4Address.getHostAddress());
        } else if (inetAddress instanceof Inet6Address) {
            Inet6Address inet6Address = (Inet6Address)inetAddress;
            iPv4 = Uri.IPv6$.MODULE$.apply(inet6Address.getHostAddress());
        } else {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected address type ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inetAddress.getClass(), inetAddress})));
            }
            iPv4 = Uri.RegName$.MODULE$.apply(inetAddress.getHostAddress());
        }
        Uri.IPv4 x$2 = iPv4;
        Some x$3 = new Some((Object)BoxesRunTime.boxToInteger((int)this.address().getPort()));
        Option x$4 = Uri.Authority$.MODULE$.apply$default$1();
        return new Uri((Option)some, (Option)new Some((Object)new Uri.Authority(x$4, (Uri.Host)x$2, (Option)x$3)), "/", Uri$.MODULE$.apply$default$4(), Uri$.MODULE$.apply$default$5());
    }

    public void awaitShutdown() {
        CountDownLatch latch = new CountDownLatch(1);
        this.onShutdown((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> latch.countDown());
        latch.await();
    }

    public Server(Effect<F> F) {
        this.F = F;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.server.Server");
    }
}

