/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server;

import cats.effect.Effect;
import cats.effect.IO$;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.CountDownLatch;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001q4Q\u0001E\t\u0002\u0002aA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006Y!\t\u0005\u0006o\u0001!\t\u0001\u000f\u0005\u0007{\u0001\u0001\u000b\u0011\u0002 \t\u000b\u0011\u0003a\u0011A#\t\u000b)\u0003A\u0011A&\t\u000b1\u0003a\u0011A'\t\u000bq\u0003a\u0011A/\t\u000b\u0019\u0004a\u0011A4\t\u000b-\u0004A\u0011\u00017\t\u000bE\u0004A\u0011A&\b\rU\f\u0002\u0012A\nw\r\u0019\u0001\u0012\u0003#\u0001\u0014o\")q\u0007\u0004C\u0001q\"1Q\b\u0004Q\u0001\nyBQa\u001b\u0007\u0005\u0002e\u0014aaU3sm\u0016\u0014(B\u0001\n\u0014\u0003\u0019\u0019XM\u001d<fe*\u0011A#F\u0001\u0007QR$\b\u000fN:\u000b\u0003Y\t1a\u001c:h\u0007\u0001)\"!G\u0016\u0014\u0005\u0001Q\u0002CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g-A\u0001G!\r\u0011s%K\u0007\u0002G)\u0011A%J\u0001\u0007K\u001a4Wm\u0019;\u000b\u0003\u0019\nAaY1ug&\u0011\u0001f\t\u0002\u0007\u000b\u001a4Wm\u0019;\u0011\u0005)ZC\u0002\u0001\u0003\u0006Y\u0001\u0011\r!\f\u0002\u0002\rV\u0011a&N\t\u0003_I\u0002\"a\u0007\u0019\n\u0005Eb\"a\u0002(pi\"Lgn\u001a\t\u00037MJ!\u0001\u000e\u000f\u0003\u0007\u0005s\u0017\u0010B\u00037W\t\u0007aFA\u0001`\u0003\u0019a\u0014N\\5u}Q\t\u0011\b\u0006\u0002;yA\u00191\bA\u0015\u000e\u0003EAQ\u0001\t\u0002A\u0004\u0005\na\u0001\\8hO\u0016\u0014\bCA C\u001b\u0005\u0001%BA!\u0016\u0003\u0015awn\u001a\u001bt\u0013\t\u0019\u0005I\u0001\u0004M_\u001e<WM]\u0001\tg\",H\u000fZ8x]V\ta\tE\u0002+W\u001d\u0003\"a\u0007%\n\u0005%c\"\u0001B+oSR\f1b\u001d5vi\u0012|wO\u001c(poR\tq)\u0001\u0006p]NCW\u000f\u001e3po:$\"AT(\u000e\u0003\u0001Aa\u0001\u0015\u0004\u0005\u0002\u0004\t\u0016!\u00014\u0011\u0007m\u0011v)\u0003\u0002T9\tAAHY=oC6,g\b\u000b\u0003\u0007+bS\u0006CA\u000eW\u0013\t9FD\u0001\u0006eKB\u0014XmY1uK\u0012\f\u0013!W\u0001(\u0007>l\u0007o\\:fA]LG\u000f\u001b\u0011uQ\u0016\u00043\u000f[;uI><h\u000e\t;bg.\u0004\u0013N\\:uK\u0006$g&I\u0001\\\u0003\u0011\u0001d&\r\u001b\u0002\u000f\u0005$GM]3tgV\ta\f\u0005\u0002`I6\t\u0001M\u0003\u0002bE\u0006\u0019a.\u001a;\u000b\u0003\r\fAA[1wC&\u0011Q\r\u0019\u0002\u0012\u0013:,GoU8dW\u0016$\u0018\t\u001a3sKN\u001c\u0018\u0001C5t'\u0016\u001cWO]3\u0016\u0003!\u0004\"aG5\n\u0005)d\"a\u0002\"p_2,\u0017M\\\u0001\bE\u0006\u001cX-\u0016:j+\u0005i\u0007C\u00018p\u001b\u0005\u0019\u0012B\u00019\u0014\u0005\r)&/[\u0001\u000eC^\f\u0017\u000e^*ikR$wn\u001e8)\t))6OW\u0011\u0002i\u00061Rk]3!'\u0016\u0014h/\u001a:BaB\u0004\u0013N\\:uK\u0006$g&\u0001\u0004TKJ4XM\u001d\t\u0003w1\u0019\"\u0001\u0004\u000e\u0015\u0003Y$2!\u001c>|\u0011\u0015av\u00021\u0001_\u0011\u00151w\u00021\u0001i\u0001")
public abstract class Server<F> {
    private final Effect<F> F;
    private final Logger logger;

    public abstract F shutdown();

    public void shutdownNow() {
        this.F.runAsync(this.shutdown(), (Function1 & Serializable & scala.Serializable)x$1 -> IO$.MODULE$.unit()).unsafeRunSync();
    }

    public abstract Server<F> onShutdown(Function0<BoxedUnit> var1);

    public abstract InetSocketAddress address();

    public abstract boolean isSecure();

    public Uri baseUri() {
        Uri.IPv4 iPv4;
        Some some = new Some((Object)(this.isSecure() ? Uri.Scheme$.MODULE$.https() : Uri.Scheme$.MODULE$.http()));
        InetAddress inetAddress = this.address().getAddress();
        if (inetAddress instanceof Inet4Address) {
            Inet4Address inet4Address = (Inet4Address)inetAddress;
            iPv4 = Uri.IPv4$.MODULE$.apply(inet4Address.getHostAddress());
        } else if (inetAddress instanceof Inet6Address) {
            Inet6Address inet6Address = (Inet6Address)inetAddress;
            iPv4 = Uri.IPv6$.MODULE$.apply(inet6Address.getHostAddress());
        } else {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(new StringBuilder(26).append("Unexpected address type ").append(inetAddress.getClass()).append(": ").append(inetAddress).toString());
            }
            iPv4 = Uri.RegName$.MODULE$.apply(inetAddress.getHostAddress());
        }
        Uri.IPv4 x$1 = iPv4;
        Some x$2 = new Some((Object)BoxesRunTime.boxToInteger((int)this.address().getPort()));
        Option x$3 = Uri.Authority$.MODULE$.apply$default$1();
        return new Uri((Option)some, (Option)new Some((Object)new Uri.Authority(x$3, (Uri.Host)x$1, (Option)x$2)), "/", Uri$.MODULE$.apply$default$4(), Uri$.MODULE$.apply$default$5());
    }

    public void awaitShutdown() {
        CountDownLatch latch = new CountDownLatch(1);
        this.onShutdown((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> latch.countDown());
        latch.await();
    }

    public Server(Effect<F> F) {
        this.F = F;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.server.Server");
    }
}

