/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00113Q!\u0001\u0002\u0002\u0002%\u0011aaU3sm\u0016\u0014(BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\u0011QAB\u0001\u0007QR$\b\u000fN:\u000b\u0003\u001d\t1a\u001c:h\u0007\u0001)\"A\u0003\r\u0014\u0005\u0001Y\u0001C\u0001\u0007\u0010\u001b\u0005i!\"\u0001\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ai!AB!osJ+g\rC\u0003\u0013\u0001\u0011\u00051#\u0001\u0004=S:LGO\u0010\u000b\u0002)A\u0019Q\u0003\u0001\f\u000e\u0003\t\u0001\"a\u0006\r\r\u0001\u0011)\u0011\u0004\u0001b\u00015\t\ta)\u0006\u0002\u001cEE\u0011Ad\b\t\u0003\u0019uI!AH\u0007\u0003\u000f9{G\u000f[5oOB\u0011A\u0002I\u0005\u0003C5\u00111!\u00118z\t\u0015\u0019\u0003D1\u0001\u001c\u0005\u0005y\u0006BB\u0013\u0001A\u0003%a%\u0001\u0004m_\u001e<WM\u001d\t\u0003O)j\u0011\u0001\u000b\u0006\u0003S\u0019\tQ\u0001\\8hiML!a\u000b\u0015\u0003\r1{wmZ3s\u0011\u0015i\u0003A\"\u0001/\u0003\u001d\tG\r\u001a:fgN,\u0012a\f\t\u0003aUj\u0011!\r\u0006\u0003eM\n1A\\3u\u0015\u0005!\u0014\u0001\u00026bm\u0006L!AN\u0019\u0003#%sW\r^*pG.,G/\u00113ee\u0016\u001c8\u000fC\u00039\u0001\u0019\u0005\u0011(\u0001\u0005jgN+7-\u001e:f+\u0005Q\u0004C\u0001\u0007<\u0013\taTBA\u0004C_>dW-\u00198\t\u000by\u0002A\u0011A \u0002\u000f\t\f7/Z+sSV\t\u0001\t\u0005\u0002B\u00056\tA!\u0003\u0002D\t\t\u0019QK]5")
public abstract class Server<F> {
    private final Logger logger = LoggerFactory.getLogger((String)"org.http4s.server.Server");

    public abstract InetSocketAddress address();

    public abstract boolean isSecure();

    public Uri baseUri() {
        Uri.IPv4 iPv4;
        Some some = new Some((Object)(this.isSecure() ? Uri.Scheme$.MODULE$.https() : Uri.Scheme$.MODULE$.http()));
        InetAddress inetAddress = this.address().getAddress();
        if (inetAddress instanceof Inet4Address) {
            Inet4Address inet4Address = (Inet4Address)inetAddress;
            iPv4 = Uri.IPv4$.MODULE$.apply(inet4Address.getHostAddress());
        } else if (inetAddress instanceof Inet6Address) {
            Inet6Address inet6Address = (Inet6Address)inetAddress;
            iPv4 = Uri.IPv6$.MODULE$.apply(inet6Address.getHostAddress());
        } else {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(new StringBuilder(26).append("Unexpected address type ").append(inetAddress.getClass()).append(": ").append(inetAddress).toString());
            }
            iPv4 = Uri.RegName$.MODULE$.apply(inetAddress.getHostAddress());
        }
        Uri.IPv4 x$1 = iPv4;
        Some x$2 = new Some((Object)BoxesRunTime.boxToInteger((int)this.address().getPort()));
        Option x$3 = Uri.Authority$.MODULE$.apply$default$1();
        return new Uri((Option)some, (Option)new Some((Object)new Uri.Authority(x$3, (Uri.Host)x$1, (Option)x$2)), "/", Uri$.MODULE$.apply$default$4(), Uri$.MODULE$.apply$default$5());
    }
}

