/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware;

import cats.Applicative;
import cats.effect.Sync;
import cats.syntax.package;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.time.Clock;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.http4s.HeaderKey;
import org.http4s.Request;
import org.http4s.RequestCookie;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status$;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.headers.Cookie$;
import org.http4s.headers.Host;
import org.http4s.headers.Host$;
import org.http4s.headers.Origin$;
import org.http4s.headers.Referer;
import org.http4s.headers.Referer$;
import org.http4s.headers.X;
import org.http4s.headers.X$minusForwarded$minusFor$;
import org.http4s.internal.package$;
import org.http4s.server.middleware.CSRF;
import org.http4s.server.middleware.CSRF$CSRFCheckFailed$;
import org.http4s.util.CaseInsensitiveString;
import org.http4s.util.CaseInsensitiveString$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class CSRF$ {
    public static CSRF$ MODULE$;
    private final String SigningAlgo;
    private final int SHA1ByteLen;
    private final int CSRFTokenLength;
    private final int InitialSeedArraySize;
    private final SecureRandom CachedRandom;

    static {
        new CSRF$();
    }

    public Object lift(String s) {
        return s;
    }

    public String unlift(Object s) {
        return (String)s;
    }

    public <F, G> CSRF<F, G> apply(CaseInsensitiveString headerName, String cookieName, Clock clock, boolean secure, Response<G> onFailure, boolean createIfNotFound, SecretKey key, Function1<Request<G>, Object> headerCheck, Sync<F> evidence$2, Applicative<G> evidence$3) {
        return new CSRF<F, G>(headerName, cookieName, clock, secure, onFailure, createIfNotFound, key, headerCheck, evidence$2, evidence$3);
    }

    public <F, G> CaseInsensitiveString apply$default$1() {
        return CaseInsensitiveString$.MODULE$.apply((CharSequence)"X-Csrf-Token");
    }

    public <F, G> String apply$default$2() {
        return "csrf-token";
    }

    public <F, G> Clock apply$default$3() {
        return Clock.systemUTC();
    }

    public <F, G> boolean apply$default$4() {
        return false;
    }

    public <F, G> Response<G> apply$default$5() {
        return new Response(Status$.MODULE$.Forbidden(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5());
    }

    public <F, G> boolean apply$default$6() {
        return true;
    }

    public <F, G> CSRF<F, G> default(CaseInsensitiveString headerName, String cookieName, Clock clock, boolean secure, Response<G> onFailure, boolean createIfNotFound, SecretKey key, String host, Uri.Scheme sc, Option<Object> port, Sync<F> evidence$4, Applicative<G> evidence$5) {
        return new CSRF<F, G>(headerName, cookieName, clock, secure, onFailure, createIfNotFound, key, (Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)CSRF$.MODULE$.defaultOriginCheck(x$4, host, sc, (Option<Object>)port)), evidence$4, evidence$5);
    }

    public <F, G> CaseInsensitiveString default$default$1() {
        return CaseInsensitiveString$.MODULE$.apply((CharSequence)"X-Csrf-Token");
    }

    public <F, G> String default$default$2() {
        return "csrf-token";
    }

    public <F, G> Clock default$default$3() {
        return Clock.systemUTC();
    }

    public <F, G> boolean default$default$4() {
        return false;
    }

    public <F, G> Response<G> default$default$5() {
        return new Response(Status$.MODULE$.Forbidden(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5());
    }

    public <F, G> boolean default$default$6() {
        return true;
    }

    public <F> boolean defaultOriginCheck(Request<F> r, String host, Uri.Scheme sc, Option<Object> port) {
        return r.headers().get((HeaderKey.Extractable)Origin$.MODULE$).flatMap((Function1 & Serializable & scala.Serializable)o -> {
            None$ none$;
            Either either = Uri$.MODULE$.fromString(o.value());
            if (either instanceof Right) {
                Right right = (Right)either;
                Uri uri = (Uri)right.value();
                none$ = new Some((Object)uri);
            } else if (either instanceof Left) {
                none$ = None$.MODULE$;
            } else {
                throw new MatchError((Object)either);
            }
            return none$;
        }).exists((Function1 & Serializable & scala.Serializable)u -> BoxesRunTime.boxToBoolean((boolean)CSRF$.$anonfun$defaultOriginCheck$2(host, sc, port, u))) || r.headers().get((HeaderKey.Extractable)Referer$.MODULE$).exists((Function1 & Serializable & scala.Serializable)u -> BoxesRunTime.boxToBoolean((boolean)CSRF$.$anonfun$defaultOriginCheck$4(host, sc, port, u)));
    }

    public <F> boolean proxyOriginCheck(Request<F> r, Host host, X.minusForwarded.minusFor xff) {
        return r.headers().get((HeaderKey.Extractable)Host$.MODULE$).contains((Object)host) || r.headers().get((HeaderKey.Extractable)X$minusForwarded$minusFor$.MODULE$).contains((Object)xff);
    }

    public <F, G> F withGeneratedKey(CaseInsensitiveString headerName, String cookieName, Clock clock, boolean secure, Response<G> onFailure, boolean createIfNotFound, Function1<Request<G>, Object> headerCheck, Sync<F> evidence$6, Applicative<G> evidence$7) {
        return (F)package.all$.MODULE$.toFunctorOps(this.generateSigningKey(evidence$6), evidence$6).map((Function1 & Serializable & scala.Serializable)x$7 -> MODULE$.apply(headerName, cookieName, clock, secure, onFailure, createIfNotFound, (SecretKey)x$7, headerCheck, evidence$6, evidence$7));
    }

    public <F, G> CaseInsensitiveString withGeneratedKey$default$1() {
        return CaseInsensitiveString$.MODULE$.apply((CharSequence)"X-Csrf-Token");
    }

    public <F, G> String withGeneratedKey$default$2() {
        return "csrf-token";
    }

    public <F, G> Clock withGeneratedKey$default$3() {
        return Clock.systemUTC();
    }

    public <F, G> boolean withGeneratedKey$default$4() {
        return false;
    }

    public <F, G> Response<G> withGeneratedKey$default$5() {
        return new Response(Status$.MODULE$.Forbidden(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5());
    }

    public <F, G> boolean withGeneratedKey$default$6() {
        return true;
    }

    public <F, G> F withKeyBytes(byte[] keyBytes, CaseInsensitiveString headerName, String cookieName, Clock clock, Response<G> onFailure, boolean secure, boolean createIfNotFound, Function1<Request<G>, Object> headerCheck, Sync<F> evidence$8, Applicative<G> evidence$9) {
        return (F)package.all$.MODULE$.toFunctorOps(this.buildSigningKey(keyBytes, evidence$8), evidence$8).map((Function1 & Serializable & scala.Serializable)x$8 -> MODULE$.apply(headerName, cookieName, clock, secure, onFailure, createIfNotFound, (SecretKey)x$8, headerCheck, evidence$8, evidence$9));
    }

    public <F, G> CaseInsensitiveString withKeyBytes$default$2() {
        return CaseInsensitiveString$.MODULE$.apply((CharSequence)"X-Csrf-Token");
    }

    public <F, G> String withKeyBytes$default$3() {
        return "csrf-token";
    }

    public <F, G> Clock withKeyBytes$default$4() {
        return Clock.systemUTC();
    }

    public <F, G> Response<G> withKeyBytes$default$5() {
        return new Response(Status$.MODULE$.Forbidden(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5());
    }

    public <F, G> boolean withKeyBytes$default$6() {
        return false;
    }

    public <F, G> boolean withKeyBytes$default$7() {
        return true;
    }

    public String SigningAlgo() {
        return this.SigningAlgo;
    }

    public int SHA1ByteLen() {
        return this.SHA1ByteLen;
    }

    public int CSRFTokenLength() {
        return this.CSRFTokenLength;
    }

    private int InitialSeedArraySize() {
        return this.InitialSeedArraySize;
    }

    private SecureRandom CachedRandom() {
        return this.CachedRandom;
    }

    public <F, G> F cookieFromHeadersF(Request<G> request, String cookieName, Sync<F> F) {
        Object object;
        Option<RequestCookie> option = this.cookieFromHeaders(request, cookieName);
        if (option instanceof Some) {
            Some some = (Some)option;
            RequestCookie e = (RequestCookie)some.value();
            object = F.pure((Object)e);
        } else if (None$.MODULE$.equals(option)) {
            object = F.raiseError((Object)CSRF$CSRFCheckFailed$.MODULE$);
        } else {
            throw new MatchError(option);
        }
        return (F)object;
    }

    public <F> Option<RequestCookie> cookieFromHeaders(Request<F> request, String cookieName) {
        return Cookie$.MODULE$.from(request.headers()).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> x$9.values().find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)CSRF$.$anonfun$cookieFromHeaders$2(cookieName, x$10))));
    }

    public boolean tokensEqual(Object s1, Object s2) {
        return this.isEqual(this.unlift(s1), this.unlift(s2));
    }

    public boolean isEqual(String s1, String s2) {
        return MessageDigest.isEqual(s1.getBytes(StandardCharsets.UTF_8), s2.getBytes(StandardCharsets.UTF_8));
    }

    public String genTokenString() {
        byte[] bytes = new byte[this.CSRFTokenLength()];
        this.CachedRandom().nextBytes(bytes);
        return package$.MODULE$.encodeHexString(bytes);
    }

    public <F> F generateSigningKey(Sync<F> F) {
        return (F)F.delay((Function0 & Serializable & scala.Serializable)() -> KeyGenerator.getInstance(MODULE$.SigningAlgo()).generateKey());
    }

    public <F> F buildSigningKey(byte[] array, Sync<F> F) {
        return (F)F.delay((Function0 & Serializable & scala.Serializable)() -> new SecretKeySpec((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(array)).slice(0, MODULE$.SHA1ByteLen()), MODULE$.SigningAlgo()));
    }

    public static final /* synthetic */ boolean $anonfun$defaultOriginCheck$3(String host$2, Uri.Host x$5) {
        String string = x$5.value();
        String string2 = host$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$defaultOriginCheck$2(String host$2, Uri.Scheme sc$2, Option port$2, Uri u) {
        if (!u.host().exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CSRF$.$anonfun$defaultOriginCheck$3(host$2, x$5)))) return false;
        if (!u.scheme().contains((Object)sc$2)) return false;
        Option option = u.port();
        Option option2 = port$2;
        if (option != null) {
            if (!option.equals(option2)) return false;
            return true;
        }
        if (option2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$defaultOriginCheck$5(String host$2, Uri.Host x$6) {
        String string = x$6.value();
        String string2 = host$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$defaultOriginCheck$4(String host$2, Uri.Scheme sc$2, Option port$2, Referer u) {
        if (!u.uri().host().exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)CSRF$.$anonfun$defaultOriginCheck$5(host$2, x$6)))) return false;
        if (!u.uri().scheme().contains((Object)sc$2)) return false;
        Option option = u.uri().port();
        Option option2 = port$2;
        if (option != null) {
            if (!option.equals(option2)) return false;
            return true;
        }
        if (option2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$cookieFromHeaders$2(String cookieName$1, RequestCookie x$10) {
        String string = x$10.name();
        String string2 = cookieName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * WARNING - void declaration
     */
    private CSRF$() {
        void var1_1;
        MODULE$ = this;
        this.SigningAlgo = "HmacSHA1";
        this.SHA1ByteLen = 20;
        this.CSRFTokenLength = 32;
        this.InitialSeedArraySize = 20;
        SecureRandom r = new SecureRandom();
        r.nextBytes(new byte[this.InitialSeedArraySize()]);
        this.CachedRandom = var1_1;
    }
}

