/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware.authentication;

import cats.Applicative;
import cats.FlatMap;
import cats.Functor;
import cats.data.Kleisli;
import cats.data.NonEmptyList;
import cats.effect.Sync;
import cats.implicits$;
import cats.syntax.EitherObjectOps$;
import java.io.Serializable;
import org.http4s.AuthScheme$;
import org.http4s.AuthedRequest;
import org.http4s.Challenge;
import org.http4s.Credentials;
import org.http4s.HeaderKey;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.headers.Authorization;
import org.http4s.headers.Authorization$;
import org.http4s.server.middleware.authentication.DigestAuth;
import org.http4s.server.middleware.authentication.DigestAuth$BadNC$;
import org.http4s.server.middleware.authentication.DigestAuth$BadParameters$;
import org.http4s.server.middleware.authentication.DigestAuth$NoAuthorizationHeader$;
import org.http4s.server.middleware.authentication.DigestAuth$NoCredentials$;
import org.http4s.server.middleware.authentication.DigestAuth$StaleNonce$;
import org.http4s.server.middleware.authentication.DigestAuth$UserUnknown$;
import org.http4s.server.middleware.authentication.DigestAuth$WrongResponse$;
import org.http4s.server.middleware.authentication.DigestUtil$;
import org.http4s.server.middleware.authentication.NonceKeeper;
import org.http4s.server.middleware.authentication.NonceKeeper$BadNCReply$;
import org.http4s.server.middleware.authentication.NonceKeeper$OKReply$;
import org.http4s.server.middleware.authentication.NonceKeeper$StaleReply$;
import org.http4s.server.middleware.authentication.package$;
import org.http4s.util.CaseInsensitiveString;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenSetLike;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.runtime.Nothing$;
import scala.util.Either;

public final class DigestAuth$ {
    public static DigestAuth$ MODULE$;

    static {
        new DigestAuth$();
    }

    public <F, A> Function1<Kleisli<?, AuthedRequest<F, A>, Response<F>>, Kleisli<?, Request<F>, Response<F>>> apply(String realm, Function1<String, F> store, Duration nonceCleanupInterval, Duration nonceStaleTime, int nonceBits, Sync<F> evidence$1) {
        NonceKeeper nonceKeeper = new NonceKeeper(nonceStaleTime.toMillis(), nonceCleanupInterval.toMillis(), nonceBits);
        Kleisli kleisli = this.challenge(realm, store, nonceKeeper, evidence$1);
        return (Function1 & Serializable & scala.Serializable)routes -> package$.MODULE$.challenged(kleisli, routes, evidence$1);
    }

    public <F, A> Duration apply$default$3() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public <F, A> Duration apply$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public <F, A> int apply$default$5() {
        return 160;
    }

    public <F, A> Kleisli<F, Request<F>, Either<Challenge, AuthedRequest<F, A>>> challenge(String realm, Function1<String, F> store, NonceKeeper nonceKeeper, Sync<F> F) {
        return new Kleisli((Function1 & Serializable & scala.Serializable)req -> implicits$.MODULE$.toFlatMapOps(MODULE$.checkAuth(realm, store, nonceKeeper, (Request)req, (Applicative)F), (FlatMap)F).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            DigestAuth.AuthReply authReply = x0$1;
            if (authReply instanceof DigestAuth.OK) {
                DigestAuth.OK oK = (DigestAuth.OK)authReply;
                Object authInfo = oK.authInfo();
                object = F.pure((Object)EitherObjectOps$.MODULE$.right$extension(implicits$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)new AuthedRequest(authInfo, req)));
            } else {
                object = DigestAuth$StaleNonce$.MODULE$.equals(authReply) ? implicits$.MODULE$.toFunctorOps(MODULE$.getChallengeParams(nonceKeeper, true, F), (Functor)F).map((Function1 & Serializable & scala.Serializable)params -> DigestAuth$.paramsToChallenge$1(params, realm)) : implicits$.MODULE$.toFunctorOps(MODULE$.getChallengeParams(nonceKeeper, false, F), (Functor)F).map((Function1 & Serializable & scala.Serializable)params -> DigestAuth$.paramsToChallenge$1(params, realm));
            }
            return object;
        }));
    }

    /*
     * Enabled aggressive block sorting
     */
    private <F, A> F checkAuth(String realm, Function1<String, F> store, NonceKeeper nonceKeeper, Request<F> req, Applicative<F> F) {
        Authorization authorization;
        Option option;
        Object object;
        boolean bl = false;
        Some some = null;
        Option option2 = req.headers().get((HeaderKey.Extractable)Authorization$.MODULE$);
        if (option2 instanceof Some) {
            Credentials credentials;
            bl = true;
            some = (Some)option2;
            Authorization authorization2 = (Authorization)some.value();
            Option option3 = Authorization$.MODULE$.unapply(authorization2);
            if (!option3.isEmpty() && (credentials = (Credentials)option3.get()) instanceof Credentials.AuthParams) {
                Credentials.AuthParams authParams = (Credentials.AuthParams)credentials;
                CaseInsensitiveString caseInsensitiveString = authParams.authScheme();
                NonEmptyList params = authParams.params();
                CaseInsensitiveString caseInsensitiveString2 = AuthScheme$.MODULE$.Digest();
                CaseInsensitiveString caseInsensitiveString3 = caseInsensitiveString;
                if (!(caseInsensitiveString2 != null ? !caseInsensitiveString2.equals(caseInsensitiveString3) : caseInsensitiveString3 != null)) {
                    object = this.checkAuthParams(realm, store, nonceKeeper, req, (NonEmptyList<Tuple2<String, String>>)params, F);
                    return (F)object;
                }
            }
        }
        if (bl && !(option = Authorization$.MODULE$.unapply(authorization = (Authorization)some.value())).isEmpty()) {
            object = F.pure((Object)DigestAuth$NoCredentials$.MODULE$);
            return (F)object;
        }
        if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
        object = F.pure((Object)DigestAuth$NoAuthorizationHeader$.MODULE$);
        return (F)object;
    }

    private <F> F getChallengeParams(NonceKeeper nonceKeeper, boolean staleNonce, Sync<F> F) {
        return (F)F.delay((Function0 & Serializable & scala.Serializable)() -> {
            void var3_3;
            String nonce = nonceKeeper.newNonce();
            Map m = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"qop"), (Object)"auth"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nonce"), (Object)nonce)}));
            return staleNonce ? m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stale"), (Object)"TRUE")) : var3_3;
        });
    }

    private <F, A> F checkAuthParams(String realm, Function1<String, F> store, NonceKeeper nonceKeeper, Request<F> req, NonEmptyList<Tuple2<String, String>> paramsNel, Applicative<F> F) {
        Object object;
        String nc;
        Map params = paramsNel.toList().toMap(Predef$.MODULE$.$conforms());
        if (!((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"realm", "nonce", "nc", "username", "cnonce", "qop"}))).subsetOf((GenSet)params.keySet())) {
            return (F)F.pure((Object)DigestAuth$BadParameters$.MODULE$);
        }
        String method = req.method().toString();
        String uri = req.uri().toString();
        Option option = params.get((Object)"realm");
        Some some = new Some((Object)realm);
        if (option == null ? some != null : !option.equals(some)) {
            return (F)F.pure((Object)DigestAuth$BadParameters$.MODULE$);
        }
        String nonce = (String)params.apply((Object)"nonce");
        NonceKeeper.Reply reply = nonceKeeper.receiveNonce(nonce, Integer.parseInt(nc = (String)params.apply((Object)"nc"), 16));
        if (NonceKeeper$StaleReply$.MODULE$.equals(reply)) {
            object = F.pure((Object)DigestAuth$StaleNonce$.MODULE$);
        } else if (NonceKeeper$BadNCReply$.MODULE$.equals(reply)) {
            object = F.pure((Object)DigestAuth$BadNC$.MODULE$);
        } else if (NonceKeeper$OKReply$.MODULE$.equals(reply)) {
            object = implicits$.MODULE$.toFunctorOps(store.apply(params.apply((Object)"username")), F).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Some some;
                Tuple2 tuple2;
                DigestAuth.AuthReply<Nothing$> authReply;
                Option option = x0$2;
                if (None$.MODULE$.equals(option)) {
                    authReply = DigestAuth$UserUnknown$.MODULE$;
                } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                    String resp;
                    Object authInfo = tuple2._1();
                    String password = (String)tuple2._2();
                    String string = resp = DigestUtil$.MODULE$.computeResponse(method, (String)params.apply((Object)"username"), realm, password, uri, nonce, nc, (String)params.apply((Object)"cnonce"), (String)params.apply((Object)"qop"));
                    Object object = params.apply((Object)"response");
                    authReply = !(string != null ? !string.equals(object) : object != null) ? new DigestAuth.OK<Object>(authInfo) : DigestAuth$WrongResponse$.MODULE$;
                } else {
                    throw new MatchError((Object)option);
                }
                return authReply;
            });
        } else {
            throw new MatchError((Object)reply);
        }
        return (F)object;
    }

    private static final Either paramsToChallenge$1(Map params, String realm$1) {
        return EitherObjectOps$.MODULE$.left$extension(implicits$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)new Challenge("Digest", realm$1, params));
    }

    private DigestAuth$() {
        MODULE$ = this;
    }
}

