/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.staticcontent;

import cats.Applicative;
import cats.ApplicativeError;
import cats.Functor;
import cats.Monad;
import cats.MonadError;
import cats.data.Kleisli;
import cats.data.NonEmptyList;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.ContextShift;
import cats.effect.Sync;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package;
import fs2.internal.FreeC;
import io.chrisdavenport.vault.Vault;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.http4s.Header;
import org.http4s.HeaderKey;
import org.http4s.Headers$;
import org.http4s.HttpVersion;
import org.http4s.RangeUnit;
import org.http4s.RangeUnit$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.StaticFile$;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.Uri$;
import org.http4s.headers.Content$minusRange$;
import org.http4s.headers.Range;
import org.http4s.headers.Range$;
import org.http4s.server.middleware.TranslateUri$;
import org.http4s.server.staticcontent.FileService;
import org.http4s.server.staticcontent.FileService$BadTraversal$1$;
import org.http4s.server.staticcontent.package$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class FileService$ {
    public static FileService$ MODULE$;
    private final Logger logger;

    static {
        new FileService$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <F> Kleisli<?, Request<F>, Response<F>> apply(FileService.Config<F> config, Sync<F> F) {
        LazyRef BadTraversal$module = new LazyRef();
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Paths.get(config.systemPath(), new String[0]).toRealPath(new LinkOption[0]));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Path rootPath = (Path)success.value();
            return TranslateUri$.MODULE$.apply(config.pathPrefix(), new Kleisli((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Request request = x0$1;
                OptionT optionT = (OptionT)ApplicativeErrorOps$.MODULE$.recoverWith$extension(package.all$.MODULE$.catsSyntaxApplicativeError((Object)this.resolvedPath$1(request, rootPath, F, BadTraversal$module).flatMapF((Function1 & Serializable & scala.Serializable)path -> F.delay((Function0 & Serializable & scala.Serializable)() -> Files.exists(path, LinkOption.NOFOLLOW_LINKS) ? new Some((Object)path.toRealPath(LinkOption.NOFOLLOW_LINKS)) : None$.MODULE$), (Monad)F).collect((PartialFunction)new scala.Serializable(rootPath){
                    public static final long serialVersionUID = 0L;
                    private final Path rootPath$1;

                    public final <A1 extends Path, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        Object object = A1.startsWith(this.rootPath$1) ? A1.toFile() : function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Path x1) {
                        Path path = x1;
                        boolean bl = path.startsWith(this.rootPath$1);
                        return bl;
                    }
                    {
                        this.rootPath$1 = rootPath$1;
                    }
                }, (Functor)F).flatMap((Function1 & Serializable & scala.Serializable)f -> (OptionT)config.pathCollector().apply(f, (Object)config, (Object)request), (Monad)F).semiflatMap((Function1 & Serializable & scala.Serializable)x$1 -> config.cacheStrategy().cache(request.pathInfo(), x$1, F), (Monad)F), (ApplicativeError)OptionT$.MODULE$.catsDataMonadErrorForOptionT((MonadError)F)), (PartialFunction)new scala.Serializable(F, BadTraversal$module){
                    public static final long serialVersionUID = 0L;
                    private final Sync F$1;
                    private final LazyRef BadTraversal$module$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        A1 A1 = x2;
                        Object object = FileService$.MODULE$.org$http4s$server$staticcontent$FileService$$BadTraversal$2(this.BadTraversal$module$1).equals(A1) ? OptionT.PurePartiallyApplied$.MODULE$.apply$extension(OptionT$.MODULE$.some(), (Object)new Response(Status$.MODULE$.BadRequest(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), (Applicative)this.F$1) : function1.apply(x2);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Throwable x2) {
                        Throwable throwable = x2;
                        boolean bl = FileService$.MODULE$.org$http4s$server$staticcontent$FileService$$BadTraversal$2(this.BadTraversal$module$1).equals(throwable);
                        return bl;
                    }
                    {
                        this.F$1 = F$1;
                        this.BadTraversal$module$1 = BadTraversal$module$1;
                    }
                }, (ApplicativeError)OptionT$.MODULE$.catsDataMonadErrorForOptionT((MonadError)F));
                return optionT;
            }), OptionT$.MODULE$.catsDataMonoidKForOptionT(F), F);
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof NoSuchFileException) {
                if (!this.logger.isErrorEnabled()) return new Kleisli((Function1 & Serializable & scala.Serializable)x$2 -> OptionT$.MODULE$.none((Applicative)F));
                this.logger.error(new StringBuilder(110).append("Could not find root path from FileService config: systemPath = ").append(config.systemPath()).append(", pathPrefix = ").append(config.pathPrefix()).append(". All requests will return none.").toString());
                return new Kleisli((Function1 & Serializable & scala.Serializable)x$2 -> OptionT$.MODULE$.none((Applicative)F));
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable e = failure.exception();
        if (!this.logger.isErrorEnabled()) return new Kleisli((Function1 & Serializable & scala.Serializable)x$3 -> OptionT.PurePartiallyApplied$.MODULE$.apply$extension(OptionT$.MODULE$.pure(), (Object)new Response(Status$.MODULE$.InternalServerError(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), (Applicative)F));
        this.logger.error(new StringBuilder(117).append("Could not resolve root path from FileService config: systemPath = ").append(config.systemPath()).append(", pathPrefix = ").append(config.pathPrefix()).append(". All requests will fail with a 500.").toString(), e);
        return new Kleisli((Function1 & Serializable & scala.Serializable)x$3 -> OptionT.PurePartiallyApplied$.MODULE$.apply$extension(OptionT$.MODULE$.pure(), (Object)new Response(Status$.MODULE$.InternalServerError(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), (Applicative)F));
    }

    public <F> OptionT<F, Response<F>> org$http4s$server$staticcontent$FileService$$filesOnly(File file, FileService.Config<F> config, Request<F> req, Sync<F> F, ContextShift<F> cs) {
        return new OptionT(F.defer((Function0 & Serializable & scala.Serializable)() -> file.isDirectory() ? StaticFile$.MODULE$.fromFile(new File(file, "index.html"), config.blocker(), (Option)new Some((Object)req), F, cs).value() : (!file.isFile() ? F.pure((Object)None$.MODULE$) : new OptionT(MODULE$.getPartialContentFile(file, config, req, F, cs)).orElse((Function0 & Serializable & scala.Serializable)() -> StaticFile$.MODULE$.fromFile(file, config.bufferSize(), config.blocker(), (Option)new Some((Object)req), StaticFile$.MODULE$.calcETag(F), F, cs).map((Function1 & Serializable & scala.Serializable)x$4 -> (Response)x$4.putHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{package$.MODULE$.AcceptRangeHeader()})), (Functor)F), (Monad)F).value())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validRange(long start, Option<Object> end, long fileLength) {
        if (start >= fileLength) return false;
        Option<Object> option = end;
        if (option instanceof Some) {
            Some some = (Some)option;
            long end2 = BoxesRunTime.unboxToLong((Object)some.value());
            if (start < 0L) return false;
            if (start > end2) return false;
            return true;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        if (start >= 0L) return true;
        if (fileLength + start - 1L < 0L) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private <F> F getPartialContentFile(File file, FileService.Config<F> config, Request<F> req, Sync<F> F, ContextShift<F> cs) {
        Object object;
        Some some;
        Range range;
        Option option;
        Option option2 = Headers$.MODULE$.get$extension0(req.headers(), (HeaderKey.Extractable)Range$.MODULE$);
        if (option2 instanceof Some && !(option = Range$.MODULE$.unapply(range = (Range)(some = (Some)option2).value())).isEmpty()) {
            RangeUnit rangeUnit = (RangeUnit)((Tuple2)option.get())._1();
            NonEmptyList nonEmptyList = (NonEmptyList)((Tuple2)option.get())._2();
            RangeUnit rangeUnit2 = RangeUnit$.MODULE$.Bytes();
            RangeUnit rangeUnit3 = rangeUnit;
            if (!(rangeUnit2 != null ? !rangeUnit2.equals(rangeUnit3) : rangeUnit3 != null) && nonEmptyList != null) {
                Range.SubRange subRange = (Range.SubRange)nonEmptyList.head();
                List list = nonEmptyList.tail();
                if (subRange != null) {
                    long s = subRange.first();
                    Option e = subRange.second();
                    if (Nil$.MODULE$.equals(list)) {
                        object = this.validRange(s, (Option<Object>)e, file.length()) ? F.defer((Function0 & Serializable & scala.Serializable)() -> {
                            long size = file.length();
                            long start = s >= 0L ? s : scala.math.package$.MODULE$.max(0L, size + s);
                            long end = scala.math.package$.MODULE$.min(size - 1L, BoxesRunTime.unboxToLong((Object)e.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> size - 1L)));
                            return StaticFile$.MODULE$.fromFile(file, start, end + 1L, config.bufferSize(), config.blocker(), (Option)new Some((Object)req), StaticFile$.MODULE$.calcETag(F), F, cs).map((Function1 & Serializable & scala.Serializable)resp -> {
                                List hs = Headers$.MODULE$.put$extension(resp.headers(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{package$.MODULE$.AcceptRangeHeader(), Content$minusRange$.MODULE$.apply(Range.SubRange$.MODULE$.apply(start, end), (Option)new Some((Object)BoxesRunTime.boxToLong((long)size)))}));
                                Status x$1 = Status$.MODULE$.PartialContent();
                                List x$2 = hs;
                                HttpVersion x$3 = resp.copy$default$2();
                                FreeC x$4 = resp.copy$default$4();
                                Vault x$5 = resp.copy$default$5();
                                return resp.copy(x$1, x$3, x$2, x$4, x$5);
                            }, (Functor)F).value();
                        }) : package.all$.MODULE$.toFunctorOps(F.delay((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> file.length()), F).map((Function1 & Serializable & scala.Serializable)size -> FileService$.$anonfun$getPartialContentFile$5(BoxesRunTime.unboxToLong((Object)size)));
                        return (F)object;
                    }
                }
            }
        }
        object = F.pure((Object)None$.MODULE$);
        return (F)object;
    }

    private static final /* synthetic */ FileService$BadTraversal$1$ BadTraversal$lzycompute$1(LazyRef BadTraversal$module$1) {
        FileService$BadTraversal$1$ fileService$BadTraversal$1$;
        LazyRef lazyRef = BadTraversal$module$1;
        synchronized (lazyRef) {
            fileService$BadTraversal$1$ = BadTraversal$module$1.initialized() ? (FileService$BadTraversal$1$)BadTraversal$module$1.value() : (FileService$BadTraversal$1$)BadTraversal$module$1.initialize((Object)new FileService$BadTraversal$1$());
        }
        return fileService$BadTraversal$1$;
    }

    public final FileService$BadTraversal$1$ org$http4s$server$staticcontent$FileService$$BadTraversal$2(LazyRef BadTraversal$module$1) {
        return BadTraversal$module$1.initialized() ? (FileService$BadTraversal$1$)BadTraversal$module$1.value() : FileService$.BadTraversal$lzycompute$1(BadTraversal$module$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final OptionT resolvedPath$1(Request x1$1, Path rootPath$1, Sync F$1, LazyRef BadTraversal$module$1) {
        String[] stringArray = x1$1.pathInfo().split("/");
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(0) == 0) {
            return OptionT.PurePartiallyApplied$.MODULE$.apply$extension(OptionT$.MODULE$.some(), (Object)rootPath$1, (Applicative)F$1);
        }
        Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (option2.isEmpty()) return OptionT$.MODULE$.none((Applicative)F$1);
        if (option2.get() == null) return OptionT$.MODULE$.none((Applicative)F$1);
        if (((SeqLike)option2.get()).lengthCompare(1) < 0) return OptionT$.MODULE$.none((Applicative)F$1);
        String head = (String)((SeqLike)option2.get()).apply(0);
        IndexedSeq segments = (IndexedSeq)((IterableLike)option2.get()).drop(1);
        if (!head.isEmpty()) return OptionT$.MODULE$.none((Applicative)F$1);
        return OptionT$.MODULE$.liftF(F$1.catchNonFatal((Function0 & Serializable & scala.Serializable)() -> (Path)segments.foldLeft((Object)rootPath$1, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            String segment;
            String string;
            boolean bl;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null && (bl = "".equals(string = (String)tuple2._2()) ? true : (".".equals(string) ? true : "..".equals(string)))) {
                throw this.org$http4s$server$staticcontent$FileService$$BadTraversal$2(BadTraversal$module$1);
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Path path = (Path)tuple2._1();
            String x$1 = segment = (String)tuple2._2();
            boolean x$2 = true;
            Charset x$3 = Uri$.MODULE$.decode$default$2();
            Function1 x$4 = Uri$.MODULE$.decode$default$4();
            Path path2 = path.resolve(Uri$.MODULE$.decode(x$1, x$3, x$2, x$4));
            return path2;
        }), Predef$.MODULE$.$conforms()), (Functor)F$1);
    }

    public static final /* synthetic */ Some $anonfun$getPartialContentFile$5(long size) {
        Status x$6 = Status$.MODULE$.RangeNotSatisfiable();
        List x$7 = Headers$.MODULE$.of((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{package$.MODULE$.AcceptRangeHeader(), Content$minusRange$.MODULE$.apply(Range.SubRange$.MODULE$.apply(0L, size - 1L), (Option)new Some((Object)BoxesRunTime.boxToLong((long)size)))}));
        HttpVersion x$8 = Response$.MODULE$.apply$default$2();
        FreeC x$9 = Response$.MODULE$.apply$default$4();
        Vault x$10 = Response$.MODULE$.apply$default$5();
        return new Some((Object)new Response(x$6, x$8, x$7, x$9, x$10));
    }

    private FileService$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.server.staticcontent.FileService");
    }
}

