/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware.authentication;

import cats.ApplicativeError;
import cats.FlatMap;
import cats.Functor;
import cats.Monad;
import cats.data.Kleisli;
import cats.data.NonEmptyList;
import cats.effect.Concurrent;
import cats.effect.ContextShift;
import cats.effect.Sync;
import cats.effect.Timer;
import cats.syntax.EitherObjectOps$;
import cats.syntax.package;
import java.io.Serializable;
import org.http4s.AuthScheme$;
import org.http4s.AuthedRequest$;
import org.http4s.Challenge;
import org.http4s.ContextRequest;
import org.http4s.Credentials;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.crypto.Hash;
import org.http4s.crypto.Hash$;
import org.http4s.headers.Authorization;
import org.http4s.headers.Authorization$;
import org.http4s.server.middleware.authentication.DigestAuth;
import org.http4s.server.middleware.authentication.DigestAuth$BadNC$;
import org.http4s.server.middleware.authentication.DigestAuth$BadParameters$;
import org.http4s.server.middleware.authentication.DigestAuth$NoAuthorizationHeader$;
import org.http4s.server.middleware.authentication.DigestAuth$NoCredentials$;
import org.http4s.server.middleware.authentication.DigestAuth$PlainTextAuthStore$;
import org.http4s.server.middleware.authentication.DigestAuth$StaleNonce$;
import org.http4s.server.middleware.authentication.DigestAuth$UserUnknown$;
import org.http4s.server.middleware.authentication.DigestAuth$WrongResponse$;
import org.http4s.server.middleware.authentication.DigestUtil$;
import org.http4s.server.middleware.authentication.NonceKeeper;
import org.http4s.server.middleware.authentication.NonceKeeper$BadNCReply$;
import org.http4s.server.middleware.authentication.NonceKeeper$OKReply$;
import org.http4s.server.middleware.authentication.NonceKeeper$StaleReply$;
import org.http4s.server.middleware.authentication.NonceKeeperF$;
import org.http4s.server.middleware.authentication.package$;
import org.typelevel.ci.CIString;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenSetLike;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public final class DigestAuth$ {
    public static DigestAuth$ MODULE$;

    static {
        new DigestAuth$();
    }

    public <F, A> Function1<Kleisli<?, ContextRequest<F, A>, Response<F>>, Kleisli<?, Request<F>, Response<F>>> apply(String realm, Function1<String, F> store, Duration nonceCleanupInterval, Duration nonceStaleTime, int nonceBits, Sync<F> evidence$3) {
        NonceKeeper nonceKeeper = new NonceKeeper(nonceStaleTime.toMillis(), nonceCleanupInterval.toMillis(), nonceBits);
        Kleisli kleisli = this.challenge(realm, store, nonceKeeper, evidence$3);
        return (Function1 & Serializable & scala.Serializable)routes -> package$.MODULE$.challenged(kleisli, routes, evidence$3);
    }

    public <F, A> Duration apply$default$3() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public <F, A> Duration apply$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public <F, A> int apply$default$5() {
        return 160;
    }

    public <F, A> F applyF(String realm, DigestAuth.AuthStore<F, A> store, ExecutionContext blocker, Duration nonceCleanupInterval, Duration nonceStaleTime, int nonceBits, Concurrent<F> F, Timer<F> t, ContextShift<F> cs) {
        String x$1 = realm;
        DigestAuth.AuthStore<F, A> x$2 = store;
        Duration x$3 = nonceCleanupInterval;
        Duration x$4 = nonceStaleTime;
        int x$5 = nonceBits;
        ExecutionContext x$6 = blocker;
        return (F)package.all$.MODULE$.toFunctorOps(this.challenge(x$1, x$2, x$6, x$3, x$4, x$5, F, t, cs), F).map((Function1 & Serializable & scala.Serializable)runChallenge -> (Function1 & Serializable & scala.Serializable)routes -> package$.MODULE$.challenged(runChallenge, routes, F));
    }

    public <F, A> Duration applyF$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public <F, A> Duration applyF$default$5() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public <F, A> int applyF$default$6() {
        return 160;
    }

    public <F, A> Kleisli<F, Request<F>, Either<Challenge, ContextRequest<F, A>>> challenge(String realm, Function1<String, F> store, NonceKeeper nonceKeeper, Sync<F> F) {
        return this.challengeInterop(realm, DigestAuth$PlainTextAuthStore$.MODULE$.apply(store), F.delay((Function0 & Serializable & scala.Serializable)() -> nonceKeeper.newNonce()), (Function2 & Serializable & scala.Serializable)(data, nc) -> F.delay((Function0 & Serializable & scala.Serializable)() -> nonceKeeper$1.receiveNonce(data, nc)), F);
    }

    public <F, A> F challenge(String realm, DigestAuth.AuthStore<F, A> store, ExecutionContext blocker, Duration nonceCleanupInterval, Duration nonceStaleTime, int nonceBits, Concurrent<F> F, Timer<F> t, ContextShift<F> cs) {
        return (F)package.all$.MODULE$.toFunctorOps(NonceKeeperF$.MODULE$.apply(nonceStaleTime, nonceCleanupInterval, nonceBits, blocker, F, t, cs), F).map((Function1 & Serializable & scala.Serializable)nonceKeeper -> MODULE$.challengeInterop(realm, store, nonceKeeper.newNonce(), (Function2)(Function2 & Serializable & scala.Serializable)(data, nc) -> nonceKeeper.receiveNonce(data, BoxesRunTime.unboxToInt((Object)nc)), (Sync)F));
    }

    public <F, A> Duration challenge$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public <F, A> Duration challenge$default$5() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public <F, A> int challenge$default$6() {
        return 160;
    }

    private <F, A> Kleisli<F, Request<F>, Either<Challenge, ContextRequest<F, A>>> challengeInterop(String realm, DigestAuth.AuthStore<F, A> store, F newNonce, Function2<String, Object, F> receiveNonce, Sync<F> F) {
        return new Kleisli((Function1 & Serializable & scala.Serializable)req -> package.all$.MODULE$.toFlatMapOps(MODULE$.checkAuth(realm, store, receiveNonce, (Request)req, (Hash)Hash$.MODULE$.forApplicativeThrow((ApplicativeError)F), (Monad)F), (FlatMap)F).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            DigestAuth.AuthReply authReply = x0$1;
            if (authReply instanceof DigestAuth.OK) {
                DigestAuth.OK oK = (DigestAuth.OK)authReply;
                Object authInfo = oK.authInfo();
                object = F.pure((Object)EitherObjectOps$.MODULE$.right$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)AuthedRequest$.MODULE$.apply(authInfo, req)));
            } else {
                object = DigestAuth$StaleNonce$.MODULE$.equals(authReply) ? package.all$.MODULE$.toFunctorOps(MODULE$.getChallengeParams(newNonce, true, F), (Functor)F).map((Function1 & Serializable & scala.Serializable)params -> DigestAuth$.paramsToChallenge$1(params, realm)) : package.all$.MODULE$.toFunctorOps(MODULE$.getChallengeParams(newNonce, false, F), (Functor)F).map((Function1 & Serializable & scala.Serializable)params -> DigestAuth$.paramsToChallenge$1(params, realm));
            }
            return object;
        }));
    }

    /*
     * Enabled aggressive block sorting
     */
    private <F, A> F checkAuth(String realm, DigestAuth.AuthStore<F, A> store, Function2<String, Object, F> receiveNonce, Request<F> req, Hash<F> evidence$4, Monad<F> F) {
        Object object;
        boolean bl = false;
        Some some = null;
        Option option = Headers$.MODULE$.get$extension0(req.headers(), Header.Select$.MODULE$.singleHeaders(Authorization$.MODULE$.headerInstance()));
        if (option instanceof Some) {
            Credentials credentials;
            bl = true;
            some = (Some)option;
            Authorization authorization = (Authorization)some.value();
            if (authorization != null && (credentials = authorization.credentials()) instanceof Credentials.AuthParams) {
                Credentials.AuthParams authParams = (Credentials.AuthParams)credentials;
                CIString cIString = authParams.authScheme();
                NonEmptyList params = authParams.params();
                CIString cIString2 = AuthScheme$.MODULE$.Digest();
                CIString cIString3 = cIString;
                if (!(cIString2 != null ? !cIString2.equals(cIString3) : cIString3 != null)) {
                    object = this.checkAuthParams(realm, store, receiveNonce, req, (NonEmptyList<Tuple2<String, String>>)params, evidence$4, F);
                    return (F)object;
                }
            }
        }
        if (bl) {
            object = F.pure((Object)DigestAuth$NoCredentials$.MODULE$);
            return (F)object;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
        object = F.pure((Object)DigestAuth$NoAuthorizationHeader$.MODULE$);
        return (F)object;
    }

    private <F> F getChallengeParams(F newNonce, boolean staleNonce, Sync<F> F) {
        return (F)package.all$.MODULE$.toFunctorOps(newNonce, F).map((Function1 & Serializable & scala.Serializable)nonce -> {
            void var2_2;
            Map m = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"qop"), (Object)"auth"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nonce"), nonce)}));
            return staleNonce ? m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stale"), (Object)"TRUE")) : var2_2;
        });
    }

    private <F, A> F checkAuthParams(String realm, DigestAuth.AuthStore<F, A> store, Function2<String, Object, F> receiveNonce, Request<F> req, NonEmptyList<Tuple2<String, String>> paramsNel, Hash<F> evidence$5, Monad<F> F) {
        Object object;
        Map params = paramsNel.toList().toMap(Predef$.MODULE$.$conforms());
        if (!((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"realm", "nonce", "nc", "username", "cnonce", "qop"}))).subsetOf((GenSet)params.keySet())) {
            object = F.pure((Object)DigestAuth$BadParameters$.MODULE$);
        } else {
            String method = req.method().toString();
            if (!params.get((Object)"realm").contains((Object)realm)) {
                object = F.pure((Object)DigestAuth$BadParameters$.MODULE$);
            } else {
                String nonce = (String)params.apply((Object)"nonce");
                String nc = (String)params.apply((Object)"nc");
                object = package.all$.MODULE$.toFlatMapOps(receiveNonce.apply((Object)nonce, (Object)BoxesRunTime.boxToInteger((int)Integer.parseInt(nc, 16))), F).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Object object;
                    NonceKeeper.Reply reply = x0$1;
                    if (NonceKeeper$StaleReply$.MODULE$.equals(reply)) {
                        object = F.pure((Object)DigestAuth$StaleNonce$.MODULE$);
                    } else if (NonceKeeper$BadNCReply$.MODULE$.equals(reply)) {
                        object = F.pure((Object)DigestAuth$BadNC$.MODULE$);
                    } else if (NonceKeeper$OKReply$.MODULE$.equals(reply)) {
                        Object object2;
                        DigestAuth.AuthStore authStore = store;
                        if (authStore instanceof DigestAuth.PlainTextAuthStore) {
                            DigestAuth.PlainTextAuthStore plainTextAuthStore = (DigestAuth.PlainTextAuthStore)authStore;
                            object2 = package.all$.MODULE$.toFlatMapOps(plainTextAuthStore.func().apply(params.apply((Object)"username")), (FlatMap)F).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                                Some some;
                                Tuple2 tuple2;
                                Object object;
                                Option option = x0$2;
                                if (None$.MODULE$.equals(option)) {
                                    object = F.pure((Object)DigestAuth$UserUnknown$.MODULE$);
                                } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                                    Object authInfo = tuple2._1();
                                    String password = (String)tuple2._2();
                                    object = package.all$.MODULE$.toFunctorOps(DigestUtil$.MODULE$.computeResponse(method, (String)params.apply((Object)"username"), realm, password, req.uri(), nonce, nc, (String)params.apply((Object)"cnonce"), (String)params.apply((Object)"qop"), F, evidence$5), (Functor)F).map((Function1 & Serializable & scala.Serializable)resp -> {
                                        String string = resp;
                                        Object object = params.apply((Object)"response");
                                        return !(string != null ? !string.equals(object) : object != null) ? new DigestAuth.OK<Object>(authInfo) : DigestAuth$WrongResponse$.MODULE$;
                                    });
                                } else {
                                    throw new MatchError((Object)option);
                                }
                                return object;
                            });
                        } else if (authStore instanceof DigestAuth.Md5HashedAuthStore) {
                            DigestAuth.Md5HashedAuthStore md5HashedAuthStore = (DigestAuth.Md5HashedAuthStore)authStore;
                            object2 = package.all$.MODULE$.toFlatMapOps(md5HashedAuthStore.func().apply(params.apply((Object)"username")), (FlatMap)F).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                                Some some;
                                Tuple2 tuple2;
                                Object object;
                                Option option = x0$3;
                                if (None$.MODULE$.equals(option)) {
                                    object = F.pure((Object)DigestAuth$UserUnknown$.MODULE$);
                                } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                                    Object authInfo = tuple2._1();
                                    String ha1Hash = (String)tuple2._2();
                                    object = package.all$.MODULE$.toFunctorOps(DigestUtil$.MODULE$.computeHashedResponse(method, ha1Hash, req.uri(), nonce, nc, (String)params.apply((Object)"cnonce"), (String)params.apply((Object)"qop"), F, evidence$5), (Functor)F).map((Function1 & Serializable & scala.Serializable)resp -> {
                                        String string = resp;
                                        Object object = params.apply((Object)"response");
                                        return !(string != null ? !string.equals(object) : object != null) ? new DigestAuth.OK<Object>(authInfo) : DigestAuth$WrongResponse$.MODULE$;
                                    });
                                } else {
                                    throw new MatchError((Object)option);
                                }
                                return object;
                            });
                        } else {
                            throw new MatchError((Object)authStore);
                        }
                        object = object2;
                    } else {
                        throw new MatchError((Object)reply);
                    }
                    return object;
                });
            }
        }
        return (F)object;
    }

    private static final Either paramsToChallenge$1(Map params, String realm$2) {
        return EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)new Challenge("Digest", realm$2, params));
    }

    private DigestAuth$() {
        MODULE$ = this;
    }
}

