/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.staticcontent;

import cats.Applicative;
import cats.ApplicativeError;
import cats.FlatMap;
import cats.Functor;
import cats.Monad;
import cats.MonadError;
import cats.data.Kleisli;
import cats.data.Kleisli$;
import cats.data.NonEmptyList;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.kernel.Async;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.FlattenOps$;
import cats.syntax.package;
import fs2.Stream;
import fs2.io.file.BasicFileAttributes;
import fs2.io.file.Files$;
import fs2.io.file.Path;
import fs2.io.file.Path$;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.NoSuchFileException;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpRoutes$;
import org.http4s.HttpVersion;
import org.http4s.RangeUnit;
import org.http4s.RangeUnit$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.StaticFile$;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.headers.Accept$minusRanges$;
import org.http4s.headers.Content$minusRange$;
import org.http4s.headers.Range;
import org.http4s.headers.Range$;
import org.http4s.server.middleware.TranslateUri$;
import org.http4s.server.staticcontent.FileService;
import org.http4s.server.staticcontent.FileService$BadTraversal$1$;
import org.http4s.server.staticcontent.package$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.typelevel.vault.Vault;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class FileService$ {
    public static FileService$ MODULE$;
    private final Logger logger;

    static {
        new FileService$();
    }

    public <F> Kleisli<?, Request<F>, Response<F>> apply(FileService.Config<F> config, Async<F> F) {
        LazyRef BadTraversal$module = new LazyRef();
        Object readPath = Files$.MODULE$.apply(Files$.MODULE$.forAsync(F)).realPath(Path$.MODULE$.apply(config.systemPath()));
        Object inner = package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(package.all$.MODULE$.catsSyntaxApplicativeError(readPath, F), F), F).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            boolean bl = false;
            Left left = null;
            Either either = x0$1;
            if (either instanceof Right) {
                Right right = (Right)either;
                Path rootPath = (Path)right.value();
                return TranslateUri$.MODULE$.apply(config.pathPrefix(), new Kleisli((Function1 & Serializable & scala.Serializable)request -> this.withPath$1(rootPath, (Request)request, F, config, BadTraversal$module)), OptionT$.MODULE$.catsDataMonoidKForOptionT((Monad)F));
            }
            if (either instanceof Left) {
                bl = true;
                left = (Left)either;
                if (left.value() instanceof NoSuchFileException) {
                    if (FileService$.MODULE$.logger.isErrorEnabled()) {
                        FileService$.MODULE$.logger.error(new StringBuilder(110).append("Could not find root path from FileService config: systemPath = ").append(config.systemPath()).append(", pathPrefix = ").append(config.pathPrefix()).append(". All requests will return none.").toString());
                    }
                    return HttpRoutes$.MODULE$.empty((Applicative)F);
                }
            }
            if (bl) {
                Throwable e = (Throwable)left.value();
                if (FileService$.MODULE$.logger.isErrorEnabled()) {
                    FileService$.MODULE$.logger.error(new StringBuilder(117).append("Could not resolve root path from FileService config: systemPath = ").append(config.systemPath()).append(", pathPrefix = ").append(config.pathPrefix()).append(". All requests will fail with a 500.").toString(), e);
                }
                return HttpRoutes$.MODULE$.pure(Response$.MODULE$.apply(Status$.MODULE$.InternalServerError(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), (Applicative)OptionT$.MODULE$.catsDataMonadErrorForOptionT((MonadError)F));
            }
            throw new MatchError((Object)either);
        });
        return (Kleisli)FlattenOps$.MODULE$.flatten$extension(package.all$.MODULE$.catsSyntaxFlatten((Object)new Kleisli((Function1 & Serializable & scala.Serializable)x$4 -> OptionT$.MODULE$.liftF(inner, (Functor)F)), (FlatMap)Kleisli$.MODULE$.catsDataMonadErrorForKleisli(OptionT$.MODULE$.catsDataMonadErrorForOptionT(F))), (FlatMap)Kleisli$.MODULE$.catsDataMonadErrorForKleisli(OptionT$.MODULE$.catsDataMonadErrorForOptionT(F)));
    }

    public <F> OptionT<F, Response<F>> org$http4s$server$staticcontent$FileService$$filesOnly(Path path, FileService.Config<F> config, Request<F> req, Async<F> F) {
        return new OptionT(package.all$.MODULE$.toFlatMapOps(Files$.MODULE$.apply(Files$.MODULE$.forAsync(F)).getBasicFileAttributes(path), F).flatMap((Function1 & Serializable & scala.Serializable)attr -> {
            if (attr.isDirectory()) {
                return StaticFile$.MODULE$.fromPath(path.$div("index.html"), (Option)new Some((Object)req), Files$.MODULE$.forAsync(F), (MonadError)F).value();
            }
            if (!attr.isRegularFile()) {
                return F.pure((Object)None$.MODULE$);
            }
            return new OptionT(MODULE$.getPartialContentFile(path, config, req, F)).orElse((Function0 & Serializable & scala.Serializable)() -> StaticFile$.MODULE$.fromPath(path, config.bufferSize(), (Option)new Some((Object)req), StaticFile$.MODULE$.calculateETag(Files$.MODULE$.forAsync(F), (ApplicativeError)F), Files$.MODULE$.forAsync(F), (MonadError)F).map((Function1 & Serializable & scala.Serializable)x$5 -> (Response)x$5.putHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)package$.MODULE$.AcceptRangeHeader(), Accept$minusRanges$.MODULE$.headerInstance())})), (Functor)F), (Monad)F).value();
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validRange(long start, Option<Object> end, long fileLength) {
        if (start >= fileLength) return false;
        Option<Object> option = end;
        if (option instanceof Some) {
            Some some = (Some)option;
            long end2 = BoxesRunTime.unboxToLong((Object)some.value());
            if (start < 0L) return false;
            if (start > end2) return false;
            return true;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        if (start >= 0L) return true;
        if (fileLength + start - 1L < 0L) return false;
        return true;
    }

    private <F> F getPartialContentFile(Path file, FileService.Config<F> config, Request<F> req, Async<F> F) {
        return (F)package.all$.MODULE$.toFlatMapOps(Files$.MODULE$.apply(Files$.MODULE$.forAsync(F)).getBasicFileAttributes(file), F).flatMap((Function1 & Serializable & scala.Serializable)attr -> {
            Option option;
            Some some;
            Range range;
            Option option2 = Headers$.MODULE$.get$extension0(req.headers(), Header.Select$.MODULE$.singleHeaders(Range$.MODULE$.headerInstance()));
            if (option2 instanceof Some && (range = (Range)(some = (Some)option2).value()) != null) {
                RangeUnit rangeUnit = range.unit();
                NonEmptyList nonEmptyList = range.ranges();
                RangeUnit rangeUnit2 = RangeUnit$.MODULE$.Bytes();
                RangeUnit rangeUnit3 = rangeUnit;
                if (!(rangeUnit2 != null ? !rangeUnit2.equals(rangeUnit3) : rangeUnit3 != null) && nonEmptyList != null) {
                    Range.SubRange subRange = (Range.SubRange)nonEmptyList.head();
                    List list = nonEmptyList.tail();
                    if (subRange != null) {
                        long s = subRange.first();
                        Option e = subRange.second();
                        if (Nil$.MODULE$.equals(list)) {
                            if (MODULE$.validRange(s, (Option<Object>)e, attr.size())) {
                                long size = attr.size();
                                long start = s >= 0L ? s : scala.math.package$.MODULE$.max(0L, size + s);
                                long end = scala.math.package$.MODULE$.min(size - 1L, BoxesRunTime.unboxToLong((Object)e.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> size - 1L)));
                                return StaticFile$.MODULE$.fromPath(file, start, end + 1L, config.bufferSize(), (Option)new Some((Object)req), StaticFile$.MODULE$.calculateETag(Files$.MODULE$.forAsync(F), (ApplicativeError)F), Files$.MODULE$.forAsync(F), (MonadError)F).map((Function1 & Serializable & scala.Serializable)resp -> {
                                    List hs = Headers$.MODULE$.put$extension(resp.headers(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)package$.MODULE$.AcceptRangeHeader(), Accept$minusRanges$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusRange$.MODULE$.apply(Range.SubRange$.MODULE$.apply(start, end), (Option)new Some((Object)BoxesRunTime.boxToLong((long)size))), Content$minusRange$.MODULE$.headerInstance())}));
                                    Status x$1 = Status$.MODULE$.PartialContent();
                                    List x$2 = hs;
                                    HttpVersion x$3 = resp.copy$default$2();
                                    Stream x$4 = resp.copy$default$4();
                                    Vault x$5 = resp.copy$default$5();
                                    return resp.copy(x$1, x$3, x$2, x$4, x$5);
                                }, (Functor)F).value();
                            }
                            return FileService$.nope$1(attr, F);
                        }
                    }
                }
            }
            if ((option = Headers$.MODULE$.get$extension1(req.headers(), org.typelevel.ci.package$.MODULE$.CIStringSyntax(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Range"}))).ci((Seq)Nil$.MODULE$))) instanceof Some) {
                return FileService$.nope$1(attr, F);
            }
            if (None$.MODULE$.equals(option)) {
                return F.pure((Object)None$.MODULE$);
            }
            throw new MatchError((Object)option);
        });
    }

    private static final /* synthetic */ FileService$BadTraversal$1$ BadTraversal$lzycompute$1(LazyRef BadTraversal$module$1) {
        FileService$BadTraversal$1$ fileService$BadTraversal$1$;
        LazyRef lazyRef = BadTraversal$module$1;
        synchronized (lazyRef) {
            fileService$BadTraversal$1$ = BadTraversal$module$1.initialized() ? (FileService$BadTraversal$1$)BadTraversal$module$1.value() : (FileService$BadTraversal$1$)BadTraversal$module$1.initialize((Object)new FileService$BadTraversal$1$());
        }
        return fileService$BadTraversal$1$;
    }

    public final FileService$BadTraversal$1$ org$http4s$server$staticcontent$FileService$$BadTraversal$2(LazyRef BadTraversal$module$1) {
        if (BadTraversal$module$1.initialized()) {
            return (FileService$BadTraversal$1$)BadTraversal$module$1.value();
        }
        return FileService$.BadTraversal$lzycompute$1(BadTraversal$module$1);
    }

    public static final /* synthetic */ Option $anonfun$apply$6(Path path$1, Path rootPath$1, boolean existsPath) {
        if (existsPath && path$1.startsWith(rootPath$1)) {
            return new Some((Object)path$1.absolute().normalize());
        }
        return None$.MODULE$;
    }

    private final OptionT withPath$1(Path rootPath, Request request, Async F$1, FileService.Config config$1, LazyRef BadTraversal$module$1) {
        Object object;
        if (request.pathInfo().isEmpty()) {
            object = F$1.pure((Object)rootPath);
        } else {
            Vector segments = (Vector)request.pathInfo().segments().map((Function1 & Serializable & scala.Serializable)x$2 -> {
                boolean x$1 = true;
                Charset x$22 = x$2.decoded$default$1();
                Function1 x$3 = x$2.decoded$default$3();
                return x$2.decoded(x$22, x$1, x$3);
            }, Vector$.MODULE$.canBuildFrom());
            object = F$1.catchNonFatal((Function0 & Serializable & scala.Serializable)() -> (Path)segments.foldLeft((Object)rootPath, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                String string;
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null && ("".equals(string = (String)tuple2._2()) ? true : (".".equals(string) ? true : "..".equals(string)))) {
                    throw this.org$http4s$server$staticcontent$FileService$$BadTraversal$2(BadTraversal$module$1);
                }
                if (tuple2 != null) {
                    Path path = (Path)tuple2._1();
                    String segment = (String)tuple2._2();
                    return path.resolve(segment);
                }
                throw new MatchError((Object)tuple2);
            }), Predef$.MODULE$.$conforms());
        }
        Object resolvePath = object;
        Object matchingPath = package.all$.MODULE$.toFlatMapOps(resolvePath, (FlatMap)F$1).flatMap((Function1 & Serializable & scala.Serializable)path -> package.all$.MODULE$.toFunctorOps(Files$.MODULE$.apply(Files$.MODULE$.forAsync(F$1)).exists(path, false), (Functor)F$1).map((Function1 & Serializable & scala.Serializable)existsPath -> FileService$.$anonfun$apply$6(path, rootPath, BoxesRunTime.unboxToBoolean((Object)existsPath))));
        return (OptionT)ApplicativeErrorOps$.MODULE$.recoverWith$extension(package.all$.MODULE$.catsSyntaxApplicativeError((Object)new OptionT(matchingPath).flatMap((Function1 & Serializable & scala.Serializable)path -> (OptionT)config$1.fs2PathCollector().apply(path, (Object)config$1, (Object)request), (Monad)F$1).semiflatMap((Function1 & Serializable & scala.Serializable)x$3 -> config$1.cacheStrategy().cache(request.pathInfo(), x$3, F$1), (Monad)F$1), (ApplicativeError)OptionT$.MODULE$.catsDataMonadErrorForOptionT((MonadError)F$1)), (PartialFunction)new scala.Serializable(F$1, BadTraversal$module$1){
            public static final long serialVersionUID = 0L;
            private final Async F$1;
            private final LazyRef BadTraversal$module$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (FileService$.MODULE$.org$http4s$server$staticcontent$FileService$$BadTraversal$2(this.BadTraversal$module$1).equals(A1)) {
                    return (B1)OptionT.PurePartiallyApplied$.MODULE$.apply$extension(OptionT$.MODULE$.some(), (Object)Response$.MODULE$.apply(Status$.MODULE$.BadRequest(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), (Applicative)this.F$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return FileService$.MODULE$.org$http4s$server$staticcontent$FileService$$BadTraversal$2(this.BadTraversal$module$1).equals(throwable);
            }
            {
                this.F$1 = F$1;
                this.BadTraversal$module$1 = BadTraversal$module$1;
            }
        }, (ApplicativeError)OptionT$.MODULE$.catsDataMonadErrorForOptionT((MonadError)F$1));
    }

    private static final Object nope$1(BasicFileAttributes attr$1, Async F$3) {
        Status x$1 = Status$.MODULE$.RangeNotSatisfiable();
        List x$2 = Headers$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)package$.MODULE$.AcceptRangeHeader(), Accept$minusRanges$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusRange$.MODULE$.apply(Range.SubRange$.MODULE$.apply(0L, attr$1.size() - 1L), (Option)new Some((Object)BoxesRunTime.boxToLong((long)attr$1.size()))), Content$minusRange$.MODULE$.headerInstance())}));
        HttpVersion x$3 = Response$.MODULE$.apply$default$2();
        Stream x$4 = Response$.MODULE$.apply$default$4();
        Vault x$5 = Response$.MODULE$.apply$default$5();
        return package.all$.MODULE$.toFunctorOps(ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)new Some((Object)Response$.MODULE$.apply(x$1, x$3, x$2, x$4, x$5))), (Applicative)F$3), (Functor)F$3).widen();
    }

    private FileService$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.server.staticcontent.FileService");
    }
}

