/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware.authentication;

import java.util.Iterator;
import java.util.LinkedHashMap;
import org.http4s.server.middleware.authentication.Nonce;
import org.http4s.server.middleware.authentication.Nonce$;
import org.http4s.server.middleware.authentication.NonceKeeper$BadNCReply$;
import org.http4s.server.middleware.authentication.NonceKeeper$OKReply$;
import org.http4s.server.middleware.authentication.NonceKeeper$StaleReply$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]vAB\u001a5\u0011\u0003!dH\u0002\u0004Ai!\u0005A'\u0011\u0005\u0006\u0011\u0006!\tA\u0013\u0004\u0006\u0017\u0006\t\t\u0003\u0014\u0005\u0006\u0011\u000e!\t!T\u0004\b\u0003c\t\u0001\u0012QA\u0014\r\u001d\t\t#\u0001EA\u0003GAa\u0001\u0013\u0004\u0005\u0002\u0005\u0015\u0002bB.\u0007\u0003\u0003%\t\u0005\u0018\u0005\bK\u001a\t\t\u0011\"\u0001g\u0011!Qg!!A\u0005\u0002\u0005%\u0002bB9\u0007\u0003\u0003%\tE\u001d\u0005\ts\u001a\t\t\u0011\"\u0001\u0002.!AqPBA\u0001\n\u0003\n\t\u0001C\u0005\u0002\u0004\u0019\t\t\u0011\"\u0011\u0002\u0006!I\u0011q\u0001\u0004\u0002\u0002\u0013%\u0011\u0011B\u0004\b\u0003g\t\u0001\u0012QA\f\r\u001d\t\t\"\u0001EA\u0003'Aa\u0001S\t\u0005\u0002\u0005U\u0001bB.\u0012\u0003\u0003%\t\u0005\u0018\u0005\bKF\t\t\u0011\"\u0001g\u0011!Q\u0017#!A\u0005\u0002\u0005e\u0001bB9\u0012\u0003\u0003%\tE\u001d\u0005\tsF\t\t\u0011\"\u0001\u0002\u001e!Aq0EA\u0001\n\u0003\n\t\u0001C\u0005\u0002\u0004E\t\t\u0011\"\u0011\u0002\u0006!I\u0011qA\t\u0002\u0002\u0013%\u0011\u0011B\u0004\u0007\u0003k\t\u0001\u0012\u0011.\u0007\u000bE\u000b\u0001\u0012\u0011*\t\u000b!cB\u0011A-\t\u000fmc\u0012\u0011!C!9\"9Q\rHA\u0001\n\u00031\u0007b\u00026\u001d\u0003\u0003%\ta\u001b\u0005\bcr\t\t\u0011\"\u0011s\u0011\u001dIH$!A\u0005\u0002iD\u0001b \u000f\u0002\u0002\u0013\u0005\u0013\u0011\u0001\u0005\n\u0003\u0007a\u0012\u0011!C!\u0003\u000bA\u0011\"a\u0002\u001d\u0003\u0003%I!!\u0003\u0007\r\u0001#\u0004\u0001NA$\u0011)\tIE\nB\u0001B\u0003%\u00111\n\u0005\u000b\u0003#2#\u0011!Q\u0001\n\u0005-\u0003\"CA*M\t\u0005\t\u0015!\u0003h\u0011\u0019Ae\u0005\"\u0001\u0002V!I\u0011q\f\u0014C\u0002\u0013%\u0011\u0011\r\u0005\t\u0003\u00133\u0003\u0015!\u0003\u0002d!I\u00111\u0012\u0014A\u0002\u0013%\u0011Q\u0012\u0005\n\u0003\u001f3\u0003\u0019!C\u0005\u0003#C\u0001\"a''A\u0003&\u00111\n\u0005\b\u0003;3C\u0011BAP\u0011\u001d\t\tK\nC\u0001\u0003GCq!!*'\t\u0003\t9+A\u0006O_:\u001cWmS3fa\u0016\u0014(BA\u001b7\u00039\tW\u000f\u001e5f]RL7-\u0019;j_:T!a\u000e\u001d\u0002\u00155LG\r\u001a7fo\u0006\u0014XM\u0003\u0002:u\u000511/\u001a:wKJT!a\u000f\u001f\u0002\r!$H\u000f\u001d\u001bt\u0015\u0005i\u0014aA8sOB\u0011q(A\u0007\u0002i\tYaj\u001c8dK.+W\r]3s'\t\t!\t\u0005\u0002D\r6\tAIC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9EI\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\taHA\u0003SKBd\u0017p\u0005\u0002\u0004\u0005R\ta\n\u0005\u0002P\u00075\t\u0011!\u000b\u0003\u00049E1!A\u0003\"bI:\u001b%+\u001a9msN!ADT*W!\t\u0019E+\u0003\u0002V\t\n9\u0001K]8ek\u000e$\bCA\"X\u0013\tAFI\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u0001[!\tyE$A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002;B\u0011alY\u0007\u0002?*\u0011\u0001-Y\u0001\u0005Y\u0006twMC\u0001c\u0003\u0011Q\u0017M^1\n\u0005\u0011|&AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001h!\t\u0019\u0005.\u0003\u0002j\t\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0011An\u001c\t\u0003\u00076L!A\u001c#\u0003\u0007\u0005s\u0017\u0010C\u0004qA\u0005\u0005\t\u0019A4\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\u0005\u0019\bc\u0001;xY6\tQO\u0003\u0002w\t\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005a,(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$\"a\u001f@\u0011\u0005\rc\u0018BA?E\u0005\u001d\u0011un\u001c7fC:Dq\u0001\u001d\u0012\u0002\u0002\u0003\u0007A.\u0001\u0005iCND7i\u001c3f)\u00059\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003u\u000b1B]3bIJ+7o\u001c7wKR\u0011\u00111\u0002\t\u0004=\u00065\u0011bAA\b?\n1qJ\u00196fGR\u0014qaT&SKBd\u0017p\u0005\u0003\u0012\u001dN3FCAA\f!\ty\u0015\u0003F\u0002m\u00037Aq\u0001]\u000b\u0002\u0002\u0003\u0007q\rF\u0002|\u0003?Aq\u0001]\f\u0002\u0002\u0003\u0007AN\u0001\u0006Ti\u0006dWMU3qYf\u001cBA\u0002(T-R\u0011\u0011q\u0005\t\u0003\u001f\u001a!2\u0001\\A\u0016\u0011\u001d\u0001(\"!AA\u0002\u001d$2a_A\u0018\u0011\u001d\u0001H\"!AA\u00021\f!b\u0015;bY\u0016\u0014V\r\u001d7z\u0003\u001dy5JU3qYf\f!BQ1e\u001d\u000e\u0013V\r\u001d7zQ\u001d\t\u0011\u0011HA \u0003\u0007\u00022aQA\u001e\u0013\r\ti\u0004\u0012\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017EAA!\u0003\u0005\u001a\u0016\u000eZ3.K\u001a4Wm\u0019;j]\u001et\u0003%V:fA9{gnY3LK\u0016\u0004XM\u001d$/C\t\t)%A\u00041]I\u001ad&\r\u001a\u0014\u0005\u0019\u0012\u0015\u0001D:uC2,G+[7f_V$\bcA\"\u0002N%\u0019\u0011q\n#\u0003\t1{gnZ\u0001\u0015]>t7-Z\"mK\u0006tW\u000f]%oi\u0016\u0014h/\u00197\u0002\t\tLGo\u001d\u000b\t\u0003/\nI&a\u0017\u0002^A\u0011qH\n\u0005\b\u0003\u0013R\u0003\u0019AA&\u0011\u001d\t\tF\u000ba\u0001\u0003\u0017Ba!a\u0015+\u0001\u00049\u0017A\u00028p]\u000e,7/\u0006\u0002\u0002dAA\u0011QMA6\u0003_\n\u0019)\u0004\u0002\u0002h)\u0019\u0011\u0011N1\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003[\n9GA\u0007MS:\\W\r\u001a%bg\"l\u0015\r\u001d\t\u0005\u0003c\nyH\u0004\u0003\u0002t\u0005m\u0004cAA;\t6\u0011\u0011q\u000f\u0006\u0004\u0003sJ\u0015A\u0002\u001fs_>$h(C\u0002\u0002~\u0011\u000ba\u0001\u0015:fI\u00164\u0017b\u00013\u0002\u0002*\u0019\u0011Q\u0010#\u0011\u0007}\n))C\u0002\u0002\bR\u0012QAT8oG\u0016\fqA\\8oG\u0016\u001c\b%A\u0006mCN$8\t\\3b]V\u0004XCAA&\u0003=a\u0017m\u001d;DY\u0016\fg.\u001e9`I\u0015\fH\u0003BAJ\u00033\u00032aQAK\u0013\r\t9\n\u0012\u0002\u0005+:LG\u000f\u0003\u0005q]\u0005\u0005\t\u0019AA&\u00031a\u0017m\u001d;DY\u0016\fg.\u001e9!\u0003)\u0019\u0007.Z2l'R\fG.\u001a\u000b\u0003\u0003'\u000b\u0001B\\3x\u001d>t7-\u001a\u000b\u0003\u0003_\nAB]3dK&4XMT8oG\u0016$b!!+\u0002.\u0006E\u0006cAAV\u00079\u0011q\b\u0001\u0005\b\u0003_\u0013\u0004\u0019AA8\u0003\u0011!\u0017\r^1\t\r\u0005M&\u00071\u0001h\u0003\tq7\rK\u0004'\u0003s\ty$a\u0011")
public class NonceKeeper {
    private final long staleTimeout;
    private final long nonceCleanupInterval;
    private final int bits;
    private final LinkedHashMap<String, Nonce> nonces;
    private long lastCleanup;

    private LinkedHashMap<String, Nonce> nonces() {
        return this.nonces;
    }

    private long lastCleanup() {
        return this.lastCleanup;
    }

    private void lastCleanup_$eq(long x$1) {
        this.lastCleanup = x$1;
    }

    private void checkStale() {
        long d = System.currentTimeMillis();
        if (d - this.lastCleanup() > this.nonceCleanupInterval) {
            this.lastCleanup_$eq(d);
            Iterator<Nonce> it = this.nonces().values().iterator();
            this.dropStale$1(it, d);
            return;
        }
    }

    public String newNonce() {
        Nonce n = null;
        LinkedHashMap<String, Nonce> linkedHashMap = this.nonces();
        synchronized (linkedHashMap) {
            this.checkStale();
            n = Nonce$.MODULE$.gen(this.bits);
            while (this.nonces().get(n.data()) != null) {
                n = Nonce$.MODULE$.gen(this.bits);
            }
            this.nonces().put(n.data(), n);
        }
        return n.data();
    }

    public Reply receiveNonce(String data, int nc) {
        NonceKeeper$StaleReply$ nonceKeeper$StaleReply$;
        LinkedHashMap<String, Nonce> linkedHashMap = this.nonces();
        synchronized (linkedHashMap) {
            Reply reply;
            this.checkStale();
            Nonce nonce = this.nonces().get(data);
            if (nonce == null) {
                reply = NonceKeeper$StaleReply$.MODULE$;
            } else if (nonce != null) {
                Nonce nonce2 = nonce;
                if (nc > nonce2.nc()) {
                    nonce2.nc_$eq(nonce2.nc() + 1);
                    reply = NonceKeeper$OKReply$.MODULE$;
                } else {
                    reply = NonceKeeper$BadNCReply$.MODULE$;
                }
            } else {
                throw new MatchError((Object)nonce);
            }
            nonceKeeper$StaleReply$ = reply;
        }
        return nonceKeeper$StaleReply$;
    }

    private final void dropStale$1(Iterator it$1, long d$1) {
        while (it$1.hasNext() && this.staleTimeout > d$1 - ((Nonce)it$1.next()).created().getTime()) {
            it$1.remove();
        }
    }

    public NonceKeeper(long staleTimeout, long nonceCleanupInterval, int bits) {
        this.staleTimeout = staleTimeout;
        this.nonceCleanupInterval = nonceCleanupInterval;
        this.bits = bits;
        Predef$.MODULE$.require(bits > 0, (Function0 & java.io.Serializable & Serializable)() -> "Please supply a positive integer for bits.");
        this.nonces = new LinkedHashMap();
        this.lastCleanup = System.currentTimeMillis();
    }

    public static abstract class Reply {
    }
}

