/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware;

import cats.Applicative;
import cats.Functor;
import cats.Monad;
import cats.data.Kleisli;
import cats.data.OptionT$;
import cats.kernel.Eq;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.package;
import java.io.Serializable;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status$;
import org.http4s.headers.Access;
import org.http4s.headers.Access$minusControl$minusRequest$minusMethod$;
import org.http4s.headers.Origin;
import org.http4s.headers.Origin$;
import org.http4s.server.middleware.CORSConfig;
import org.http4s.server.middleware.CORSConfig$;
import org.http4s.server.middleware.CORSPolicy;
import org.http4s.server.middleware.CORSPolicy$AllowCredentials$Deny$;
import org.http4s.server.middleware.CORSPolicy$AllowHeaders$Reflect$;
import org.http4s.server.middleware.CORSPolicy$AllowOrigin$All$;
import org.http4s.server.middleware.CORSPolicy$ExposeHeaders$None$;
import org.http4s.server.middleware.CORSPolicy$MaxAge$Default$;
import org.http4s.syntax.package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.typelevel.ci.CIString$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;

public final class CORS$ {
    public static CORS$ MODULE$;
    private final Logger logger;
    private final CORSPolicy policy;
    private final Header.Raw defaultVaryHeader;

    static {
        new CORS$();
    }

    public Logger logger() {
        return this.logger;
    }

    public CORSPolicy policy() {
        return this.policy;
    }

    public Header.Raw defaultVaryHeader() {
        return this.defaultVaryHeader;
    }

    public CORSConfig DefaultCORSConfig() {
        return CORSConfig$.MODULE$.default().withAnyOrigin(true).withAllowCredentials(true).withMaxAge(new package.DurationInt(package$.MODULE$.DurationInt(1)).day());
    }

    public <F, G> Kleisli<F, Request<G>, Response<G>> apply(Kleisli<F, Request<G>, Response<G>> http, CORSConfig config, Applicative<F> F) {
        if (config.anyOrigin() && config.allowCredentials()) {
            this.logger().warn("Insecure CORS config detected: `anyOrigin=true` and `allowCredentials=true` are mutually exclusive. `Access-Control-Allow-Credentials` header will not be sent. Change either flag to false to remove this warning.");
        }
        return new Kleisli((Function1 & Serializable & scala.Serializable)req -> {
            Object object;
            Tuple3 tuple3 = new Tuple3((Object)req.method(), (Object)Headers$.MODULE$.get$extension0(req.headers(), Header.Select$.MODULE$.singleHeaders(Origin$.MODULE$.headerInstance())), (Object)Headers$.MODULE$.get$extension0(req.headers(), Header.Select$.MODULE$.singleHeaders(Access$minusControl$minusRequest$minusMethod$.MODULE$.headerInstance())));
            if (tuple3 != null) {
                Method method = (Method)tuple3._1();
                Option option = (Option)tuple3._2();
                Option option2 = (Option)tuple3._3();
                Method method2 = Method$.MODULE$.OPTIONS();
                Method method3 = method;
                if (!(method2 != null ? !method2.equals(method3) : method3 != null) && option instanceof Some) {
                    Some some;
                    Access.minusControl.minusRequest.minusMethod acrm;
                    Some some2 = (Some)option;
                    Origin origin = (Origin)some2.value();
                    if (option2 instanceof Some && CORS$.allowCORS$1(origin, (acrm = (Access.minusControl.minusRequest.minusMethod)(some = (Some)option2).value()).method(), config)) {
                        if (!MODULE$.logger().isDebugEnabled()) return ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)CORS$.createOptionsResponse$1(origin, acrm, config)), F);
                        MODULE$.logger().debug(new StringBuilder(39).append("Serving OPTIONS with CORS headers for ").append(acrm).append(" ").append(req.uri()).toString());
                        return ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)CORS$.createOptionsResponse$1(origin, acrm, config)), F);
                    }
                }
            }
            if (tuple3 == null) return http.apply(req);
            Option option = (Option)tuple3._2();
            if (!(option instanceof Some)) return http.apply(req);
            Some some = (Some)option;
            Origin origin = (Origin)some.value();
            if (CORS$.allowCORS$1(origin, req.method(), config)) {
                object = package.all$.MODULE$.toFunctorOps(http.apply(req), (Functor)F).map((Function1 & Serializable & scala.Serializable)resp -> {
                    block0: {
                        if (!MODULE$.logger().isDebugEnabled()) break block0;
                        MODULE$.logger().debug(new StringBuilder(24).append("Adding CORS headers to ").append(req.method()).append(" ").append(req.uri()).toString());
                    }
                    return CORS$.corsHeaders$1(origin, req.method(), false, resp, config);
                });
                return object;
            } else {
                if (MODULE$.logger().isDebugEnabled()) {
                    MODULE$.logger().debug(new StringBuilder(30).append("CORS headers were denied for ").append(req.method()).append(" ").append(req.uri()).toString());
                }
                object = ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)Response$.MODULE$.apply(Status$.MODULE$.Forbidden(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5())), F);
            }
            return object;
        });
    }

    public <F, G> CORSConfig apply$default$2() {
        return CORSConfig$.MODULE$.default();
    }

    public <F> Kleisli<?, Request<F>, Response<F>> httpRoutes(Kleisli<?, Request<F>, Response<F>> httpRoutes, Monad<F> evidence$1) {
        return this.apply((Kleisli)httpRoutes, CORSConfig$.MODULE$.default(), (Applicative<F>)OptionT$.MODULE$.catsDataMonadErrorMonadForOptionT(evidence$1));
    }

    public <F> Kleisli<F, Request<F>, Response<F>> httpApp(Kleisli<F, Request<F>, Response<F>> httpApp, Applicative<F> evidence$2) {
        return this.apply(httpApp, CORSConfig$.MODULE$.default(), evidence$2);
    }

    private static final Response createOptionsResponse$1(Origin origin, Access.minusControl.minusRequest.minusMethod acrm, CORSConfig config$1) {
        return CORS$.corsHeaders$1(origin, acrm.method(), true, Response$.MODULE$.apply(Response$.MODULE$.apply$default$1(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), config$1);
    }

    private static final Option methodBasedHeader$1(boolean isPreflight, CORSConfig config$1) {
        return isPreflight ? config$1.allowedHeaders().map((Function1 & Serializable & scala.Serializable)x$2 -> CORS$.headerFromStrings$1("Access-Control-Allow-Headers", x$2)) : config$1.exposedHeaders().map((Function1 & Serializable & scala.Serializable)x$3 -> CORS$.headerFromStrings$1("Access-Control-Expose-Headers", x$3));
    }

    private static final Response varyHeader$1(Response response) {
        Option option = Headers$.MODULE$.get$extension1(response.headers(), org.typelevel.ci.package$.MODULE$.CIStringSyntax(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Vary"}))).ci((Seq)Nil$.MODULE$));
        Response response2 = None$.MODULE$.equals(option) ? (Response)response.putHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.rawToRaw(MODULE$.defaultVaryHeader())})) : response;
        return response2;
    }

    private static final Response allowCredentialsHeader$1(Response resp, CORSConfig config$1) {
        return !config$1.anyOrigin() && config$1.allowCredentials() ? (Response)resp.putHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.keyValuesToRaw(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Access-Control-Allow-Credentials"), (Object)"true"))})) : resp;
    }

    private static final Response corsHeaders$1(Origin origin, Method method, boolean isPreflight, Response resp, CORSConfig config$1) {
        Response withMethodBasedHeader = (Response)CORS$.methodBasedHeader$1(isPreflight, config$1).fold((Function0 & Serializable & scala.Serializable)() -> resp, (Function1 & Serializable & scala.Serializable)h -> (Response)resp.putHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.rawToRaw(h)})));
        return (Response)CORS$.varyHeader$1(CORS$.allowCredentialsHeader$1(withMethodBasedHeader, config$1)).putHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.keyValuesToRaw(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Access-Control-Allow-Methods"), config$1.allowedMethods().fold((Function0 & Serializable & scala.Serializable)() -> method.renderString(), (Function1 & Serializable & scala.Serializable)x$4 -> x$4.mkString("", ", ", "")))), Header.ToRaw$.MODULE$.keyValuesToRaw(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Access-Control-Allow-Origin"), (Object)package.header$.MODULE$.http4sHeaderSyntax((Object)origin, Origin$.MODULE$.headerInstance()).value())), Header.ToRaw$.MODULE$.keyValuesToRaw(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Access-Control-Max-Age"), (Object)Long.toString(config$1.maxAge().toSeconds())))}));
    }

    private static final boolean allowOrigin$1(CORSConfig config$1, Origin origin$1) {
        return config$1.anyOrigin() || BoxesRunTime.unboxToBoolean((Object)config$1.allowedOrigins().apply((Object)package.header$.MODULE$.http4sHeaderSyntax((Object)origin$1, Origin$.MODULE$.headerInstance()).value()));
    }

    public static final /* synthetic */ boolean $anonfun$apply$9(Method method$2, Method x$6) {
        return package.all$.MODULE$.catsSyntaxEq((Object)x$6, (Eq)Method$.MODULE$.catsInstancesForHttp4sMethod()).$eq$eq$eq((Object)method$2);
    }

    private static final boolean allowMethod$1(CORSConfig config$1, Method method$2) {
        return config$1.anyMethod() || config$1.allowedMethods().exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)CORS$.$anonfun$apply$9(method$2, x$6)))));
    }

    private static final boolean allowCORS$1(Origin origin, Method method, CORSConfig config$1) {
        return CORS$.allowOrigin$1(config$1, origin) && CORS$.allowMethod$1(config$1, method);
    }

    private static final Header.Raw headerFromStrings$1(String headerName, Set values) {
        return new Header.Raw(CIString$.MODULE$.apply(headerName), values.mkString("", ", ", ""));
    }

    private CORS$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.server.middleware.CORS");
        this.policy = new CORSPolicy(CORSPolicy$AllowOrigin$All$.MODULE$, CORSPolicy$AllowCredentials$Deny$.MODULE$, CORSPolicy$ExposeHeaders$None$.MODULE$, new CORSPolicy.AllowMethods.In((Set<Method>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Method[]{Method$.MODULE$.GET(), Method$.MODULE$.HEAD(), Method$.MODULE$.PUT(), Method$.MODULE$.PATCH(), Method$.MODULE$.POST(), Method$.MODULE$.DELETE()})))), CORSPolicy$AllowHeaders$Reflect$.MODULE$, CORSPolicy$MaxAge$Default$.MODULE$);
        this.defaultVaryHeader = new Header.Raw(org.typelevel.ci.package$.MODULE$.CIStringSyntax(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Vary"}))).ci((Seq)Nil$.MODULE$), "Origin,Access-Control-Request-Method");
    }
}

